/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.test;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.test.TestUtils;

public class StreamsTestUtils {
    public static Properties getStreamsConfig(String applicationId, String bootstrapServers, String keySerdeClassName, String valueSerdeClassName, Properties additional) {
        Properties streamsConfiguration = new Properties();
        streamsConfiguration.put("application.id", applicationId);
        streamsConfiguration.put("bootstrap.servers", bootstrapServers);
        streamsConfiguration.put("metadata.max.age.ms", "1000");
        streamsConfiguration.put("key.serde", keySerdeClassName);
        streamsConfiguration.put("value.serde", valueSerdeClassName);
        streamsConfiguration.put("auto.offset.reset", "earliest");
        streamsConfiguration.put("state.dir", TestUtils.tempDirectory().getPath());
        streamsConfiguration.putAll((Map<?, ?>)additional);
        return streamsConfiguration;
    }

    public static Properties getStreamsConfig(String bootstrapServer, String keySerdeClassName, String valueSerdeClassName) {
        return StreamsTestUtils.getStreamsConfig(UUID.randomUUID().toString(), bootstrapServer, keySerdeClassName, valueSerdeClassName, new Properties());
    }

    public static <K, V> List<KeyValue<K, V>> toList(Iterator<KeyValue<K, V>> iterator) {
        ArrayList<KeyValue<K, V>> results = new ArrayList<KeyValue<K, V>>();
        while (iterator.hasNext()) {
            results.add(iterator.next());
        }
        return results;
    }
}

