/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateRestoreCallback;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.StateSerdes;
import org.apache.kafka.streams.state.internals.InMemoryKeyValueLoggedStore;

public class MemoryLRUCache<K, V>
implements KeyValueStore<K, V> {
    private final Serde<K> keySerde;
    private final Serde<V> valueSerde;
    private String name;
    protected Map<K, V> map;
    private StateSerdes<K, V> serdes;
    private volatile boolean open = true;
    protected EldestEntryRemovalListener<K, V> listener;

    public MemoryLRUCache(Serde<K> keySerde, Serde<V> valueSerde) {
        this.keySerde = keySerde;
        this.valueSerde = valueSerde;
    }

    public MemoryLRUCache(String name, final int maxCacheSize, Serde<K> keySerde, Serde<V> valueSerde) {
        this(keySerde, valueSerde);
        this.name = name;
        this.map = new LinkedHashMap<K, V>(maxCacheSize + 1, 1.01f, true){
            private static final long serialVersionUID = 1L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
                if (this.size() > maxCacheSize) {
                    Object key = eldest.getKey();
                    if (MemoryLRUCache.this.listener != null) {
                        MemoryLRUCache.this.listener.apply(key, eldest.getValue());
                    }
                    return true;
                }
                return false;
            }
        };
    }

    public KeyValueStore<K, V> enableLogging() {
        return new InMemoryKeyValueLoggedStore<K, V>(this.name, this, this.keySerde, this.valueSerde);
    }

    public MemoryLRUCache<K, V> whenEldestRemoved(EldestEntryRemovalListener<K, V> listener) {
        this.listener = listener;
        return this;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public void init(ProcessorContext context, StateStore root) {
        this.serdes = new StateSerdes(this.name, (Serde<?>)(this.keySerde == null ? context.keySerde() : this.keySerde), (Serde<?>)(this.valueSerde == null ? context.valueSerde() : this.valueSerde));
        context.register(root, true, new StateRestoreCallback(){

            @Override
            public void restore(byte[] key, byte[] value) {
                if (value == null) {
                    MemoryLRUCache.this.put(MemoryLRUCache.this.serdes.keyFrom(key), null);
                } else {
                    MemoryLRUCache.this.put(MemoryLRUCache.this.serdes.keyFrom(key), MemoryLRUCache.this.serdes.valueFrom(value));
                }
            }
        });
    }

    @Override
    public boolean persistent() {
        return false;
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public synchronized V get(K key) {
        return this.map.get(key);
    }

    @Override
    public synchronized void put(K key, V value) {
        this.map.put(key, value);
    }

    @Override
    public synchronized V putIfAbsent(K key, V value) {
        V originalValue = this.get(key);
        if (originalValue == null) {
            this.put(key, value);
        }
        return originalValue;
    }

    @Override
    public void putAll(List<KeyValue<K, V>> entries) {
        for (KeyValue<K, V> entry : entries) {
            this.put(entry.key, entry.value);
        }
    }

    @Override
    public synchronized V delete(K key) {
        V value = this.map.remove(key);
        return value;
    }

    @Override
    public KeyValueIterator<K, V> range(K from, K to) {
        throw new UnsupportedOperationException("MemoryLRUCache does not support range() function.");
    }

    @Override
    public KeyValueIterator<K, V> all() {
        throw new UnsupportedOperationException("MemoryLRUCache does not support all() function.");
    }

    @Override
    public long approximateNumEntries() {
        return this.map.size();
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
        this.open = false;
    }

    public int size() {
        return this.map.size();
    }

    public static interface EldestEntryRemovalListener<K, V> {
        public void apply(K var1, V var2);
    }
}

