/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.List;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.internals.SessionKeySerde;
import org.apache.kafka.streams.kstream.internals.SessionWindow;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.internals.HasNextCondition;
import org.apache.kafka.streams.state.internals.Segment;
import org.apache.kafka.streams.state.internals.SegmentedBytesStore;
import org.apache.kafka.streams.state.internals.Segments;

class SessionKeySchema
implements SegmentedBytesStore.KeySchema {
    SessionKeySchema() {
    }

    @Override
    public Bytes upperRange(Bytes key, long to) {
        Windowed<Bytes> sessionKey = new Windowed<Bytes>(key, new SessionWindow(to, Long.MAX_VALUE));
        return SessionKeySerde.toBinary(sessionKey, Serdes.Bytes().serializer());
    }

    @Override
    public Bytes lowerRange(Bytes key, long from) {
        Windowed<Bytes> sessionKey = new Windowed<Bytes>(key, new SessionWindow(0L, Math.max(0L, from)));
        return SessionKeySerde.toBinary(sessionKey, Serdes.Bytes().serializer());
    }

    @Override
    public long segmentTimestamp(Bytes key) {
        return SessionKeySerde.extractEnd(key.get());
    }

    @Override
    public HasNextCondition hasNextCondition(final Bytes binaryKey, final long from, final long to) {
        return new HasNextCondition(){

            @Override
            public boolean hasNext(KeyValueIterator<Bytes, ?> iterator) {
                if (iterator.hasNext()) {
                    Bytes bytes = iterator.peekNextKey();
                    Bytes keyBytes = Bytes.wrap((byte[])SessionKeySerde.extractKeyBytes(bytes.get()));
                    if (!keyBytes.equals((Object)binaryKey)) {
                        return false;
                    }
                    long start = SessionKeySerde.extractStart(bytes.get());
                    long end = SessionKeySerde.extractEnd(bytes.get());
                    return end >= from && start <= to;
                }
                return false;
            }
        };
    }

    @Override
    public List<Segment> segmentsToSearch(Segments segments, long from, long to) {
        return segments.segments(from, Long.MAX_VALUE);
    }
}

