/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.util.Map;
import org.apache.kafka.streams.kstream.Reducer;
import org.apache.kafka.streams.kstream.Window;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.Windows;
import org.apache.kafka.streams.kstream.internals.ForwardingCacheFlushListener;
import org.apache.kafka.streams.kstream.internals.KStreamAggProcessorSupplier;
import org.apache.kafka.streams.kstream.internals.KTableValueGetter;
import org.apache.kafka.streams.kstream.internals.KTableValueGetterSupplier;
import org.apache.kafka.streams.kstream.internals.TupleForwarder;
import org.apache.kafka.streams.processor.AbstractProcessor;
import org.apache.kafka.streams.processor.Processor;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.state.WindowStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KStreamWindowReduce<K, V, W extends Window>
implements KStreamAggProcessorSupplier<K, Windowed<K>, V, V> {
    private static final Logger LOG = LoggerFactory.getLogger(KStreamWindowReduce.class);
    private final String storeName;
    private final Windows<W> windows;
    private final Reducer<V> reducer;
    private boolean sendOldValues = false;

    KStreamWindowReduce(Windows<W> windows, String storeName, Reducer<V> reducer) {
        this.windows = windows;
        this.storeName = storeName;
        this.reducer = reducer;
    }

    @Override
    public Processor<K, V> get() {
        return new KStreamWindowReduceProcessor();
    }

    @Override
    public void enableSendingOldValues() {
        this.sendOldValues = true;
    }

    @Override
    public KTableValueGetterSupplier<Windowed<K>, V> view() {
        return new KTableValueGetterSupplier<Windowed<K>, V>(){

            @Override
            public KTableValueGetter<Windowed<K>, V> get() {
                return new KStreamWindowReduceValueGetter();
            }

            @Override
            public String[] storeNames() {
                return new String[]{KStreamWindowReduce.this.storeName};
            }
        };
    }

    private class KStreamWindowReduceValueGetter
    implements KTableValueGetter<Windowed<K>, V> {
        private WindowStore<K, V> windowStore;

        private KStreamWindowReduceValueGetter() {
        }

        @Override
        public void init(ProcessorContext context) {
            this.windowStore = (WindowStore)context.getStateStore(KStreamWindowReduce.this.storeName);
        }

        @Override
        public V get(Windowed<K> windowedKey) {
            Object key = windowedKey.key();
            Window window = windowedKey.window();
            return this.windowStore.fetch(key, window.start());
        }

        @Override
        public void close() {
        }
    }

    private class KStreamWindowReduceProcessor
    extends AbstractProcessor<K, V> {
        private WindowStore<K, V> windowStore;
        private TupleForwarder<Windowed<K>, V> tupleForwarder;
        private StreamsMetricsImpl metrics;

        private KStreamWindowReduceProcessor() {
        }

        @Override
        public void init(ProcessorContext context) {
            super.init(context);
            this.metrics = (StreamsMetricsImpl)context.metrics();
            this.windowStore = (WindowStore)context.getStateStore(KStreamWindowReduce.this.storeName);
            this.tupleForwarder = new TupleForwarder(this.windowStore, context, new ForwardingCacheFlushListener(context, KStreamWindowReduce.this.sendOldValues), KStreamWindowReduce.this.sendOldValues);
        }

        @Override
        public void process(K key, V value) {
            if (key == null) {
                LOG.warn("Skipping record due to null key. value=[{}] topic=[{}] partition=[{}] offset=[{}]", new Object[]{value, this.context().topic(), this.context().partition(), this.context().offset()});
                this.metrics.skippedRecordsSensor().record();
                return;
            }
            long timestamp = this.context().timestamp();
            Map matchedWindows = KStreamWindowReduce.this.windows.windowsFor(timestamp);
            for (Map.Entry entry : matchedWindows.entrySet()) {
                Object oldAgg = this.windowStore.fetch(key, entry.getKey());
                Object newAgg = oldAgg == null ? value : KStreamWindowReduce.this.reducer.apply(oldAgg, value);
                this.windowStore.put(key, newAgg, entry.getKey());
                this.tupleForwarder.maybeForward(new Windowed(key, (Window)entry.getValue()), newAgg, oldAgg);
            }
        }
    }
}

