/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.util.HashMap;
import java.util.Properties;
import org.apache.kafka.common.serialization.IntegerSerializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.TopologyTestDriver;
import org.apache.kafka.streams.kstream.Consumed;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.KTable;
import org.apache.kafka.streams.kstream.KeyValueMapper;
import org.apache.kafka.streams.test.ConsumerRecordFactory;
import org.apache.kafka.test.MockProcessorSupplier;
import org.apache.kafka.test.StreamsTestUtils;
import org.junit.Assert;
import org.junit.Test;

public class KTableMapKeysTest {
    private final ConsumerRecordFactory<Integer, String> recordFactory = new ConsumerRecordFactory((Serializer)new IntegerSerializer(), (Serializer)new StringSerializer());
    private final Properties props = StreamsTestUtils.getStreamsConfig(Serdes.Integer(), Serdes.String());

    @Test
    public void testMapKeysConvertingToStream() {
        StreamsBuilder builder = new StreamsBuilder();
        String topic1 = "topic_map_keys";
        KTable table1 = builder.table("topic_map_keys", Consumed.with((Serde)Serdes.Integer(), (Serde)Serdes.String()));
        final HashMap<Integer, String> keyMap = new HashMap<Integer, String>();
        keyMap.put(1, "ONE");
        keyMap.put(2, "TWO");
        keyMap.put(3, "THREE");
        KeyValueMapper<Integer, String, String> keyMapper = new KeyValueMapper<Integer, String, String>(){

            public String apply(Integer key, String value) {
                return (String)keyMap.get(key);
            }
        };
        KStream convertedStream = table1.toStream((KeyValueMapper)keyMapper);
        String[] expected = new String[]{"ONE:V_ONE", "TWO:V_TWO", "THREE:V_THREE"};
        int[] originalKeys = new int[]{1, 2, 3};
        String[] values = new String[]{"V_ONE", "V_TWO", "V_THREE"};
        MockProcessorSupplier supplier = new MockProcessorSupplier();
        convertedStream.process(supplier, new String[0]);
        try (TopologyTestDriver driver = new TopologyTestDriver(builder.build(), this.props);){
            for (int i = 0; i < originalKeys.length; ++i) {
                driver.pipeInput(this.recordFactory.create("topic_map_keys", (Object)originalKeys[i], (Object)values[i]));
            }
        }
        Assert.assertEquals((long)3L, (long)supplier.theCapturedProcessor().processed.size());
        for (int i = 0; i < expected.length; ++i) {
            Assert.assertEquals((Object)expected[i], (Object)supplier.theCapturedProcessor().processed.get(i));
        }
    }
}

