/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor;

import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.streams.processor.WallclockTimestampExtractor;
import org.hamcrest.BaseMatcher;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;

public class WallclockTimestampExtractorTest {
    @Test
    public void extractSystemTimestamp() {
        WallclockTimestampExtractor extractor = new WallclockTimestampExtractor();
        long before = System.currentTimeMillis();
        long timestamp = extractor.extract(new ConsumerRecord("anyTopic", 0, 0L, null, null), 42L);
        long after = System.currentTimeMillis();
        MatcherAssert.assertThat((Object)timestamp, (Matcher)CoreMatchers.is((Matcher)new InBetween(before, after)));
    }

    private static class InBetween
    extends BaseMatcher<Long> {
        private final long before;
        private final long after;

        public InBetween(long before, long after) {
            this.before = before;
            this.after = after;
        }

        public boolean matches(Object item) {
            long timestamp = (Long)item;
            return this.before <= timestamp && timestamp <= this.after;
        }

        public void describeMismatch(Object item, Description mismatchDescription) {
        }

        public void describeTo(Description description) {
        }
    }
}

