/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.time.Duration;
import java.util.Map;
import java.util.Properties;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeader;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.processor.Cancellable;
import org.apache.kafka.streams.processor.PunctuationType;
import org.apache.kafka.streams.processor.Punctuator;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.To;
import org.apache.kafka.streams.processor.internals.AbstractProcessorContext;
import org.apache.kafka.streams.processor.internals.MockStreamsMetrics;
import org.apache.kafka.streams.processor.internals.ProcessorRecordContext;
import org.apache.kafka.streams.processor.internals.StateManager;
import org.apache.kafka.streams.processor.internals.StateManagerStub;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.state.RocksDBConfigSetter;
import org.apache.kafka.streams.state.internals.ThreadCache;
import org.apache.kafka.test.MockKeyValueStore;
import org.apache.kafka.test.StreamsTestUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AbstractProcessorContextTest {
    private final MockStreamsMetrics metrics = new MockStreamsMetrics(new Metrics());
    private final AbstractProcessorContext context = new TestProcessorContext(this.metrics);
    private final MockKeyValueStore stateStore = new MockKeyValueStore("store", false);
    private final Headers headers = new RecordHeaders(new Header[]{new RecordHeader("key", "value".getBytes())});
    private final ProcessorRecordContext recordContext = new ProcessorRecordContext(10L, System.currentTimeMillis(), 1, "foo", this.headers);

    @Before
    public void before() {
        this.context.setRecordContext(this.recordContext);
    }

    @Test
    public void shouldThrowIllegalStateExceptionOnRegisterWhenContextIsInitialized() {
        this.context.initialize();
        try {
            this.context.register((StateStore)this.stateStore, null);
            Assert.fail((String)"should throw illegal state exception when context already initialized");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void shouldNotThrowIllegalStateExceptionOnRegisterWhenContextIsNotInitialized() {
        this.context.register((StateStore)this.stateStore, null);
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerOnRegisterIfStateStoreIsNull() {
        this.context.register(null, null);
    }

    @Test
    public void shouldThrowIllegalStateExceptionOnTopicIfNoRecordContext() {
        this.context.setRecordContext(null);
        try {
            this.context.topic();
            Assert.fail((String)"should throw illegal state exception when record context is null");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void shouldReturnTopicFromRecordContext() {
        MatcherAssert.assertThat((Object)this.context.topic(), (Matcher)CoreMatchers.equalTo((Object)this.recordContext.topic()));
    }

    @Test
    public void shouldReturnNullIfTopicEqualsNonExistTopic() {
        this.context.setRecordContext(new ProcessorRecordContext(0L, 0L, 0, "__null_topic__"));
        MatcherAssert.assertThat((Object)this.context.topic(), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void shouldThrowIllegalStateExceptionOnPartitionIfNoRecordContext() {
        this.context.setRecordContext(null);
        try {
            this.context.partition();
            Assert.fail((String)"should throw illegal state exception when record context is null");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void shouldReturnPartitionFromRecordContext() {
        MatcherAssert.assertThat((Object)this.context.partition(), (Matcher)CoreMatchers.equalTo((Object)this.recordContext.partition()));
    }

    @Test
    public void shouldThrowIllegalStateExceptionOnOffsetIfNoRecordContext() {
        this.context.setRecordContext(null);
        try {
            this.context.offset();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void shouldReturnOffsetFromRecordContext() {
        MatcherAssert.assertThat((Object)this.context.offset(), (Matcher)CoreMatchers.equalTo((Object)this.recordContext.offset()));
    }

    @Test
    public void shouldThrowIllegalStateExceptionOnTimestampIfNoRecordContext() {
        this.context.setRecordContext(null);
        try {
            this.context.timestamp();
            Assert.fail((String)"should throw illegal state exception when record context is null");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void shouldReturnTimestampFromRecordContext() {
        MatcherAssert.assertThat((Object)this.context.timestamp(), (Matcher)CoreMatchers.equalTo((Object)this.recordContext.timestamp()));
    }

    @Test
    public void shouldReturnHeadersFromRecordContext() {
        MatcherAssert.assertThat((Object)this.context.headers(), (Matcher)CoreMatchers.equalTo((Object)this.recordContext.headers()));
    }

    @Test
    public void shouldReturnNullIfHeadersAreNotSet() {
        this.context.setRecordContext(new ProcessorRecordContext(0L, 0L, 0, "__null_topic__"));
        MatcherAssert.assertThat((Object)this.context.headers(), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void shouldThrowIllegalStateExceptionOnHeadersIfNoRecordContext() {
        this.context.setRecordContext(null);
        try {
            this.context.headers();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void appConfigsShouldReturnParsedValues() {
        MatcherAssert.assertThat((Object)((Class)this.context.appConfigs().get("rocksdb.config.setter")), (Matcher)CoreMatchers.equalTo(RocksDBConfigSetter.class));
    }

    @Test
    public void appConfigsShouldReturnUnrecognizedValues() {
        MatcherAssert.assertThat((Object)((String)this.context.appConfigs().get("user.supplied.config")), (Matcher)CoreMatchers.equalTo((Object)"user-suppplied-value"));
    }

    private static class TestProcessorContext
    extends AbstractProcessorContext {
        static Properties config = StreamsTestUtils.getStreamsConfig();

        TestProcessorContext(MockStreamsMetrics metrics) {
            super(new TaskId(0, 0), new StreamsConfig((Map)config), (StreamsMetricsImpl)metrics, (StateManager)new StateManagerStub(), new ThreadCache(new LogContext("name "), 0L, (StreamsMetricsImpl)metrics));
        }

        public StateStore getStateStore(String name) {
            return null;
        }

        public Cancellable schedule(long interval, PunctuationType type, Punctuator callback) {
            return null;
        }

        public Cancellable schedule(Duration interval, PunctuationType type, Punctuator callback) throws IllegalArgumentException {
            return null;
        }

        public <K, V> void forward(K key, V value) {
        }

        public <K, V> void forward(K key, V value, To to) {
        }

        public <K, V> void forward(K key, V value, int childIndex) {
        }

        public <K, V> void forward(K key, V value, String childName) {
        }

        public void commit() {
        }

        public long streamTime() {
            throw new RuntimeException("not implemented");
        }

        static {
            config.put("rocksdb.config.setter", RocksDBConfigSetter.class.getName());
            config.put("user.supplied.config", "user-suppplied-value");
        }
    }
}

