/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals.assignment;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.assignment.ClientState;
import org.apache.kafka.streams.processor.internals.assignment.StickyTaskAssignor;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsCollectionContaining;
import org.hamcrest.core.IsNot;
import org.junit.Assert;
import org.junit.Test;

public class StickyTaskAssignorTest {
    private final TaskId task00 = new TaskId(0, 0);
    private final TaskId task01 = new TaskId(0, 1);
    private final TaskId task02 = new TaskId(0, 2);
    private final TaskId task03 = new TaskId(0, 3);
    private final TaskId task04 = new TaskId(0, 4);
    private final TaskId task05 = new TaskId(0, 5);
    private final TaskId task10 = new TaskId(1, 0);
    private final TaskId task11 = new TaskId(1, 1);
    private final TaskId task12 = new TaskId(1, 2);
    private final TaskId task20 = new TaskId(2, 0);
    private final TaskId task21 = new TaskId(2, 1);
    private final TaskId task22 = new TaskId(2, 2);
    private final List<Integer> expectedTopicGroupIds = Arrays.asList(1, 2);
    private final Map<Integer, ClientState> clients = new TreeMap<Integer, ClientState>();
    private final Integer p1 = 1;
    private final Integer p2 = 2;
    private final Integer p3 = 3;
    private final Integer p4 = 4;

    @Test
    public void shouldAssignOneActiveTaskToEachProcessWhenTaskCountSameAsProcessCount() {
        this.createClient(this.p1, 1);
        this.createClient(this.p2, 1);
        this.createClient(this.p3, 1);
        StickyTaskAssignor<Integer> taskAssignor = this.createTaskAssignor(this.task00, this.task01, this.task02);
        taskAssignor.assign(0);
        for (Integer processId : this.clients.keySet()) {
            MatcherAssert.assertThat((Object)this.clients.get(processId).activeTaskCount(), (Matcher)CoreMatchers.equalTo((Object)1));
        }
    }

    @Test
    public void shouldAssignTopicGroupIdEvenlyAcrossClientsWithNoStandByTasks() {
        this.createClient(this.p1, 2);
        this.createClient(this.p2, 2);
        this.createClient(this.p3, 2);
        StickyTaskAssignor<Integer> taskAssignor = this.createTaskAssignor(this.task10, this.task11, this.task22, this.task20, this.task21, this.task12);
        taskAssignor.assign(0);
        this.assertActiveTaskTopicGroupIdsEvenlyDistributed();
    }

    @Test
    public void shouldAssignTopicGroupIdEvenlyAcrossClientsWithStandByTasks() {
        this.createClient(this.p1, 2);
        this.createClient(this.p2, 2);
        this.createClient(this.p3, 2);
        StickyTaskAssignor<Integer> taskAssignor = this.createTaskAssignor(this.task20, this.task11, this.task12, this.task10, this.task21, this.task22);
        taskAssignor.assign(1);
        this.assertActiveTaskTopicGroupIdsEvenlyDistributed();
    }

    @Test
    public void shouldNotMigrateActiveTaskToOtherProcess() {
        this.createClientWithPreviousActiveTasks(this.p1, 1, this.task00);
        this.createClientWithPreviousActiveTasks(this.p2, 1, this.task01);
        StickyTaskAssignor<Integer> firstAssignor = this.createTaskAssignor(this.task00, this.task01, this.task02);
        firstAssignor.assign(0);
        MatcherAssert.assertThat((Object)this.clients.get(this.p1).activeTasks(), (Matcher)IsCollectionContaining.hasItems((Object[])new TaskId[]{this.task00}));
        MatcherAssert.assertThat((Object)this.clients.get(this.p2).activeTasks(), (Matcher)IsCollectionContaining.hasItems((Object[])new TaskId[]{this.task01}));
        MatcherAssert.assertThat(this.allActiveTasks(), (Matcher)CoreMatchers.equalTo(Arrays.asList(this.task00, this.task01, this.task02)));
        this.clients.clear();
        this.createClientWithPreviousActiveTasks(this.p1, 1, this.task01);
        this.createClientWithPreviousActiveTasks(this.p2, 1, this.task02);
        StickyTaskAssignor<Integer> secondAssignor = this.createTaskAssignor(this.task00, this.task01, this.task02);
        secondAssignor.assign(0);
        MatcherAssert.assertThat((Object)this.clients.get(this.p1).activeTasks(), (Matcher)IsCollectionContaining.hasItems((Object[])new TaskId[]{this.task01}));
        MatcherAssert.assertThat((Object)this.clients.get(this.p2).activeTasks(), (Matcher)IsCollectionContaining.hasItems((Object[])new TaskId[]{this.task02}));
        MatcherAssert.assertThat(this.allActiveTasks(), (Matcher)CoreMatchers.equalTo(Arrays.asList(this.task00, this.task01, this.task02)));
    }

    @Test
    public void shouldMigrateActiveTasksToNewProcessWithoutChangingAllAssignments() {
        this.createClientWithPreviousActiveTasks(this.p1, 1, this.task00, this.task02);
        this.createClientWithPreviousActiveTasks(this.p2, 1, this.task01);
        this.createClient(this.p3, 1);
        StickyTaskAssignor<Integer> taskAssignor = this.createTaskAssignor(this.task00, this.task01, this.task02);
        taskAssignor.assign(0);
        MatcherAssert.assertThat((Object)this.clients.get(this.p2).activeTasks(), (Matcher)CoreMatchers.equalTo(Collections.singleton(this.task01)));
        MatcherAssert.assertThat((Object)this.clients.get(this.p1).activeTasks().size(), (Matcher)CoreMatchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)this.clients.get(this.p3).activeTasks().size(), (Matcher)CoreMatchers.equalTo((Object)1));
        MatcherAssert.assertThat(this.allActiveTasks(), (Matcher)CoreMatchers.equalTo(Arrays.asList(this.task00, this.task01, this.task02)));
    }

    @Test
    public void shouldAssignBasedOnCapacity() {
        this.createClient(this.p1, 1);
        this.createClient(this.p2, 2);
        StickyTaskAssignor<Integer> taskAssignor = this.createTaskAssignor(this.task00, this.task01, this.task02);
        taskAssignor.assign(0);
        MatcherAssert.assertThat((Object)this.clients.get(this.p1).activeTasks().size(), (Matcher)CoreMatchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)this.clients.get(this.p2).activeTasks().size(), (Matcher)CoreMatchers.equalTo((Object)2));
    }

    @Test
    public void shouldAssignTasksEvenlyWithUnequalTopicGroupSizes() {
        this.createClientWithPreviousActiveTasks(this.p1, 1, this.task00, this.task01, this.task02, this.task03, this.task04, this.task05, this.task10);
        this.createClient(this.p2, 1);
        StickyTaskAssignor<Integer> taskAssignor = this.createTaskAssignor(this.task10, this.task00, this.task01, this.task02, this.task03, this.task04, this.task05);
        HashSet<TaskId> expectedClientITasks = new HashSet<TaskId>(Arrays.asList(this.task00, this.task01, this.task10, this.task05));
        HashSet<TaskId> expectedClientIITasks = new HashSet<TaskId>(Arrays.asList(this.task02, this.task03, this.task04));
        taskAssignor.assign(0);
        MatcherAssert.assertThat((Object)this.clients.get(this.p1).activeTasks(), (Matcher)CoreMatchers.equalTo(expectedClientITasks));
        MatcherAssert.assertThat((Object)this.clients.get(this.p2).activeTasks(), (Matcher)CoreMatchers.equalTo(expectedClientIITasks));
    }

    @Test
    public void shouldKeepActiveTaskStickynessWhenMoreClientThanActiveTasks() {
        int p5 = 5;
        this.createClientWithPreviousActiveTasks(this.p1, 1, this.task00);
        this.createClientWithPreviousActiveTasks(this.p2, 1, this.task02);
        this.createClientWithPreviousActiveTasks(this.p3, 1, this.task01);
        this.createClient(this.p4, 1);
        this.createClient(5, 1);
        StickyTaskAssignor<Integer> taskAssignor = this.createTaskAssignor(this.task00, this.task01, this.task02);
        taskAssignor.assign(0);
        MatcherAssert.assertThat((Object)this.clients.get(this.p1).activeTasks(), (Matcher)CoreMatchers.equalTo(Collections.singleton(this.task00)));
        MatcherAssert.assertThat((Object)this.clients.get(this.p2).activeTasks(), (Matcher)CoreMatchers.equalTo(Collections.singleton(this.task02)));
        MatcherAssert.assertThat((Object)this.clients.get(this.p3).activeTasks(), (Matcher)CoreMatchers.equalTo(Collections.singleton(this.task01)));
        this.clients.clear();
        this.createClient(this.p1, 1);
        this.createClientWithPreviousActiveTasks(this.p2, 1, this.task00);
        this.createClient(this.p3, 1);
        this.createClientWithPreviousActiveTasks(this.p4, 1, this.task02);
        this.createClientWithPreviousActiveTasks(5, 1, this.task01);
        StickyTaskAssignor<Integer> secondAssignor = this.createTaskAssignor(this.task00, this.task01, this.task02);
        secondAssignor.assign(0);
        MatcherAssert.assertThat((Object)this.clients.get(this.p2).activeTasks(), (Matcher)CoreMatchers.equalTo(Collections.singleton(this.task00)));
        MatcherAssert.assertThat((Object)this.clients.get(this.p4).activeTasks(), (Matcher)CoreMatchers.equalTo(Collections.singleton(this.task02)));
        MatcherAssert.assertThat((Object)this.clients.get(5).activeTasks(), (Matcher)CoreMatchers.equalTo(Collections.singleton(this.task01)));
    }

    @Test
    public void shouldAssignTasksToClientWithPreviousStandbyTasks() {
        ClientState client1 = this.createClient(this.p1, 1);
        client1.addPreviousStandbyTasks(Utils.mkSet((Object[])new TaskId[]{this.task02}));
        ClientState client2 = this.createClient(this.p2, 1);
        client2.addPreviousStandbyTasks(Utils.mkSet((Object[])new TaskId[]{this.task01}));
        ClientState client3 = this.createClient(this.p3, 1);
        client3.addPreviousStandbyTasks(Utils.mkSet((Object[])new TaskId[]{this.task00}));
        StickyTaskAssignor<Integer> taskAssignor = this.createTaskAssignor(this.task00, this.task01, this.task02);
        taskAssignor.assign(0);
        MatcherAssert.assertThat((Object)this.clients.get(this.p1).activeTasks(), (Matcher)CoreMatchers.equalTo(Collections.singleton(this.task02)));
        MatcherAssert.assertThat((Object)this.clients.get(this.p2).activeTasks(), (Matcher)CoreMatchers.equalTo(Collections.singleton(this.task01)));
        MatcherAssert.assertThat((Object)this.clients.get(this.p3).activeTasks(), (Matcher)CoreMatchers.equalTo(Collections.singleton(this.task00)));
    }

    @Test
    public void shouldAssignBasedOnCapacityWhenMultipleClientHaveStandbyTasks() {
        ClientState c1 = this.createClientWithPreviousActiveTasks(this.p1, 1, this.task00);
        c1.addPreviousStandbyTasks(Utils.mkSet((Object[])new TaskId[]{this.task01}));
        ClientState c2 = this.createClientWithPreviousActiveTasks(this.p2, 2, this.task02);
        c2.addPreviousStandbyTasks(Utils.mkSet((Object[])new TaskId[]{this.task01}));
        StickyTaskAssignor<Integer> taskAssignor = this.createTaskAssignor(this.task00, this.task01, this.task02);
        taskAssignor.assign(0);
        MatcherAssert.assertThat((Object)this.clients.get(this.p1).activeTasks(), (Matcher)CoreMatchers.equalTo(Collections.singleton(this.task00)));
        MatcherAssert.assertThat((Object)this.clients.get(this.p2).activeTasks(), (Matcher)CoreMatchers.equalTo((Object)Utils.mkSet((Object[])new TaskId[]{this.task02, this.task01})));
    }

    @Test
    public void shouldAssignStandbyTasksToDifferentClientThanCorrespondingActiveTaskIsAssingedTo() {
        this.createClientWithPreviousActiveTasks(this.p1, 1, this.task00);
        this.createClientWithPreviousActiveTasks(this.p2, 1, this.task01);
        this.createClientWithPreviousActiveTasks(this.p3, 1, this.task02);
        this.createClientWithPreviousActiveTasks(this.p4, 1, this.task03);
        StickyTaskAssignor<Integer> taskAssignor = this.createTaskAssignor(this.task00, this.task01, this.task02, this.task03);
        taskAssignor.assign(1);
        MatcherAssert.assertThat((Object)this.clients.get(this.p1).standbyTasks(), (Matcher)IsNot.not((Matcher)IsCollectionContaining.hasItems((Object[])new TaskId[]{this.task00})));
        Assert.assertTrue((this.clients.get(this.p1).standbyTasks().size() <= 2 ? 1 : 0) != 0);
        MatcherAssert.assertThat((Object)this.clients.get(this.p2).standbyTasks(), (Matcher)IsNot.not((Matcher)IsCollectionContaining.hasItems((Object[])new TaskId[]{this.task01})));
        Assert.assertTrue((this.clients.get(this.p2).standbyTasks().size() <= 2 ? 1 : 0) != 0);
        MatcherAssert.assertThat((Object)this.clients.get(this.p3).standbyTasks(), (Matcher)IsNot.not((Matcher)IsCollectionContaining.hasItems((Object[])new TaskId[]{this.task02})));
        Assert.assertTrue((this.clients.get(this.p3).standbyTasks().size() <= 2 ? 1 : 0) != 0);
        MatcherAssert.assertThat((Object)this.clients.get(this.p4).standbyTasks(), (Matcher)IsNot.not((Matcher)IsCollectionContaining.hasItems((Object[])new TaskId[]{this.task03})));
        Assert.assertTrue((this.clients.get(this.p4).standbyTasks().size() <= 2 ? 1 : 0) != 0);
        int nonEmptyStandbyTaskCount = 0;
        for (Integer client : this.clients.keySet()) {
            nonEmptyStandbyTaskCount += this.clients.get(client).standbyTasks().isEmpty() ? 0 : 1;
        }
        Assert.assertTrue((nonEmptyStandbyTaskCount >= 3 ? 1 : 0) != 0);
        MatcherAssert.assertThat(this.allStandbyTasks(), (Matcher)CoreMatchers.equalTo(Arrays.asList(this.task00, this.task01, this.task02, this.task03)));
    }

    @Test
    public void shouldAssignMultipleReplicasOfStandbyTask() {
        this.createClientWithPreviousActiveTasks(this.p1, 1, this.task00);
        this.createClientWithPreviousActiveTasks(this.p2, 1, this.task01);
        this.createClientWithPreviousActiveTasks(this.p3, 1, this.task02);
        StickyTaskAssignor<Integer> taskAssignor = this.createTaskAssignor(this.task00, this.task01, this.task02);
        taskAssignor.assign(2);
        MatcherAssert.assertThat((Object)this.clients.get(this.p1).standbyTasks(), (Matcher)CoreMatchers.equalTo((Object)Utils.mkSet((Object[])new TaskId[]{this.task01, this.task02})));
        MatcherAssert.assertThat((Object)this.clients.get(this.p2).standbyTasks(), (Matcher)CoreMatchers.equalTo((Object)Utils.mkSet((Object[])new TaskId[]{this.task02, this.task00})));
        MatcherAssert.assertThat((Object)this.clients.get(this.p3).standbyTasks(), (Matcher)CoreMatchers.equalTo((Object)Utils.mkSet((Object[])new TaskId[]{this.task00, this.task01})));
    }

    @Test
    public void shouldNotAssignStandbyTaskReplicasWhenNoClientAvailableWithoutHavingTheTaskAssigned() {
        this.createClient(this.p1, 1);
        StickyTaskAssignor<Integer> taskAssignor = this.createTaskAssignor(this.task00);
        taskAssignor.assign(1);
        MatcherAssert.assertThat((Object)this.clients.get(this.p1).standbyTasks().size(), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Test
    public void shouldAssignActiveAndStandbyTasks() {
        this.createClient(this.p1, 1);
        this.createClient(this.p2, 1);
        this.createClient(this.p3, 1);
        StickyTaskAssignor<Integer> taskAssignor = this.createTaskAssignor(this.task00, this.task01, this.task02);
        taskAssignor.assign(1);
        MatcherAssert.assertThat(this.allActiveTasks(), (Matcher)CoreMatchers.equalTo(Arrays.asList(this.task00, this.task01, this.task02)));
        MatcherAssert.assertThat(this.allStandbyTasks(), (Matcher)CoreMatchers.equalTo(Arrays.asList(this.task00, this.task01, this.task02)));
    }

    @Test
    public void shouldAssignAtLeastOneTaskToEachClientIfPossible() {
        this.createClient(this.p1, 3);
        this.createClient(this.p2, 1);
        this.createClient(this.p3, 1);
        StickyTaskAssignor<Integer> taskAssignor = this.createTaskAssignor(this.task00, this.task01, this.task02);
        taskAssignor.assign(0);
        MatcherAssert.assertThat((Object)this.clients.get(this.p1).assignedTaskCount(), (Matcher)CoreMatchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)this.clients.get(this.p2).assignedTaskCount(), (Matcher)CoreMatchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)this.clients.get(this.p3).assignedTaskCount(), (Matcher)CoreMatchers.equalTo((Object)1));
    }

    @Test
    public void shouldAssignEachActiveTaskToOneClientWhenMoreClientsThanTasks() {
        this.createClient(this.p1, 1);
        this.createClient(this.p2, 1);
        this.createClient(this.p3, 1);
        this.createClient(this.p4, 1);
        this.createClient(5, 1);
        this.createClient(6, 1);
        StickyTaskAssignor<Integer> taskAssignor = this.createTaskAssignor(this.task00, this.task01, this.task02);
        taskAssignor.assign(0);
        MatcherAssert.assertThat(this.allActiveTasks(), (Matcher)CoreMatchers.equalTo(Arrays.asList(this.task00, this.task01, this.task02)));
    }

    @Test
    public void shouldBalanceActiveAndStandbyTasksAcrossAvailableClients() {
        this.createClient(this.p1, 1);
        this.createClient(this.p2, 1);
        this.createClient(this.p3, 1);
        this.createClient(this.p4, 1);
        this.createClient(5, 1);
        this.createClient(6, 1);
        StickyTaskAssignor<Integer> taskAssignor = this.createTaskAssignor(this.task00, this.task01, this.task02);
        taskAssignor.assign(1);
        for (ClientState clientState : this.clients.values()) {
            MatcherAssert.assertThat((Object)clientState.assignedTaskCount(), (Matcher)CoreMatchers.equalTo((Object)1));
        }
    }

    @Test
    public void shouldAssignMoreTasksToClientWithMoreCapacity() {
        this.createClient(this.p2, 2);
        this.createClient(this.p1, 1);
        StickyTaskAssignor<Integer> taskAssignor = this.createTaskAssignor(this.task00, this.task01, this.task02, new TaskId(1, 0), new TaskId(1, 1), new TaskId(1, 2), new TaskId(2, 0), new TaskId(2, 1), new TaskId(2, 2), new TaskId(3, 0), new TaskId(3, 1), new TaskId(3, 2));
        taskAssignor.assign(0);
        MatcherAssert.assertThat((Object)this.clients.get(this.p2).assignedTaskCount(), (Matcher)CoreMatchers.equalTo((Object)8));
        MatcherAssert.assertThat((Object)this.clients.get(this.p1).assignedTaskCount(), (Matcher)CoreMatchers.equalTo((Object)4));
    }

    @Test
    public void shouldEvenlyDistributeByTaskIdAndPartition() {
        this.createClient(this.p1, 4);
        this.createClient(this.p2, 4);
        this.createClient(this.p3, 4);
        this.createClient(this.p4, 4);
        ArrayList<TaskId> taskIds = new ArrayList<TaskId>();
        TaskId[] taskIdArray = new TaskId[16];
        for (int i = 1; i <= 2; ++i) {
            for (int j = 0; j < 8; ++j) {
                taskIds.add(new TaskId(i, j));
            }
        }
        Collections.shuffle(taskIds);
        taskIds.toArray(taskIdArray);
        StickyTaskAssignor<Integer> taskAssignor = this.createTaskAssignor(taskIdArray);
        taskAssignor.assign(0);
        Collections.sort(taskIds);
        Set<TaskId> expectedClientOneAssignment = this.getExpectedTaskIdAssignment(taskIds, 0, 4, 8, 12);
        Set<TaskId> expectedClientTwoAssignment = this.getExpectedTaskIdAssignment(taskIds, 1, 5, 9, 13);
        Set<TaskId> expectedClientThreeAssignment = this.getExpectedTaskIdAssignment(taskIds, 2, 6, 10, 14);
        Set<TaskId> expectedClientFourAssignment = this.getExpectedTaskIdAssignment(taskIds, 3, 7, 11, 15);
        Map<Integer, Set<TaskId>> sortedAssignments = this.sortClientAssignments(this.clients);
        MatcherAssert.assertThat(sortedAssignments.get(this.p1), (Matcher)CoreMatchers.equalTo(expectedClientOneAssignment));
        MatcherAssert.assertThat(sortedAssignments.get(this.p2), (Matcher)CoreMatchers.equalTo(expectedClientTwoAssignment));
        MatcherAssert.assertThat(sortedAssignments.get(this.p3), (Matcher)CoreMatchers.equalTo(expectedClientThreeAssignment));
        MatcherAssert.assertThat(sortedAssignments.get(this.p4), (Matcher)CoreMatchers.equalTo(expectedClientFourAssignment));
    }

    @Test
    public void shouldNotHaveSameAssignmentOnAnyTwoHosts() {
        this.createClient(this.p1, 1);
        this.createClient(this.p2, 1);
        this.createClient(this.p3, 1);
        this.createClient(this.p4, 1);
        StickyTaskAssignor<Integer> taskAssignor = this.createTaskAssignor(this.task00, this.task02, this.task01, this.task03);
        taskAssignor.assign(1);
        for (int i = this.p1.intValue(); i <= this.p4; ++i) {
            Set taskIds = this.clients.get(i).assignedTasks();
            for (int j = this.p1.intValue(); j <= this.p4; ++j) {
                if (j == i) continue;
                MatcherAssert.assertThat((String)"clients shouldn't have same task assignment", (Object)this.clients.get(j).assignedTasks(), (Matcher)IsNot.not((Matcher)CoreMatchers.equalTo((Object)taskIds)));
            }
        }
    }

    @Test
    public void shouldNotHaveSameAssignmentOnAnyTwoHostsWhenThereArePreviousActiveTasks() {
        this.createClientWithPreviousActiveTasks(this.p1, 1, this.task01, this.task02);
        this.createClientWithPreviousActiveTasks(this.p2, 1, this.task03);
        this.createClientWithPreviousActiveTasks(this.p3, 1, this.task00);
        this.createClient(this.p4, 1);
        StickyTaskAssignor<Integer> taskAssignor = this.createTaskAssignor(this.task00, this.task02, this.task01, this.task03);
        taskAssignor.assign(1);
        for (int i = this.p1.intValue(); i <= this.p4; ++i) {
            Set taskIds = this.clients.get(i).assignedTasks();
            for (int j = this.p1.intValue(); j <= this.p4; ++j) {
                if (j == i) continue;
                MatcherAssert.assertThat((String)"clients shouldn't have same task assignment", (Object)this.clients.get(j).assignedTasks(), (Matcher)IsNot.not((Matcher)CoreMatchers.equalTo((Object)taskIds)));
            }
        }
    }

    @Test
    public void shouldNotHaveSameAssignmentOnAnyTwoHostsWhenThereArePreviousStandbyTasks() {
        ClientState c1 = this.createClientWithPreviousActiveTasks(this.p1, 1, this.task01, this.task02);
        c1.addPreviousStandbyTasks(Utils.mkSet((Object[])new TaskId[]{this.task03, this.task00}));
        ClientState c2 = this.createClientWithPreviousActiveTasks(this.p2, 1, this.task03, this.task00);
        c2.addPreviousStandbyTasks(Utils.mkSet((Object[])new TaskId[]{this.task01, this.task02}));
        this.createClient(this.p3, 1);
        this.createClient(this.p4, 1);
        StickyTaskAssignor<Integer> taskAssignor = this.createTaskAssignor(this.task00, this.task02, this.task01, this.task03);
        taskAssignor.assign(1);
        for (int i = this.p1.intValue(); i <= this.p4; ++i) {
            Set taskIds = this.clients.get(i).assignedTasks();
            for (int j = this.p1.intValue(); j <= this.p4; ++j) {
                if (j == i) continue;
                MatcherAssert.assertThat((String)"clients shouldn't have same task assignment", (Object)this.clients.get(j).assignedTasks(), (Matcher)IsNot.not((Matcher)CoreMatchers.equalTo((Object)taskIds)));
            }
        }
    }

    @Test
    public void shouldReBalanceTasksAcrossAllClientsWhenCapacityAndTaskCountTheSame() {
        this.createClientWithPreviousActiveTasks(this.p3, 1, this.task00, this.task01, this.task02, this.task03);
        this.createClient(this.p1, 1);
        this.createClient(this.p2, 1);
        this.createClient(this.p4, 1);
        StickyTaskAssignor<Integer> taskAssignor = this.createTaskAssignor(this.task00, this.task02, this.task01, this.task03);
        taskAssignor.assign(0);
        MatcherAssert.assertThat((Object)this.clients.get(this.p1).assignedTaskCount(), (Matcher)CoreMatchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)this.clients.get(this.p2).assignedTaskCount(), (Matcher)CoreMatchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)this.clients.get(this.p3).assignedTaskCount(), (Matcher)CoreMatchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)this.clients.get(this.p4).assignedTaskCount(), (Matcher)CoreMatchers.equalTo((Object)1));
    }

    @Test
    public void shouldReBalanceTasksAcrossClientsWhenCapacityLessThanTaskCount() {
        this.createClientWithPreviousActiveTasks(this.p3, 1, this.task00, this.task01, this.task02, this.task03);
        this.createClient(this.p1, 1);
        this.createClient(this.p2, 1);
        StickyTaskAssignor<Integer> taskAssignor = this.createTaskAssignor(this.task00, this.task02, this.task01, this.task03);
        taskAssignor.assign(0);
        MatcherAssert.assertThat((Object)this.clients.get(this.p3).assignedTaskCount(), (Matcher)CoreMatchers.equalTo((Object)2));
        MatcherAssert.assertThat((Object)this.clients.get(this.p1).assignedTaskCount(), (Matcher)CoreMatchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)this.clients.get(this.p2).assignedTaskCount(), (Matcher)CoreMatchers.equalTo((Object)1));
    }

    @Test
    public void shouldRebalanceTasksToClientsBasedOnCapacity() {
        this.createClientWithPreviousActiveTasks(this.p2, 1, this.task00, this.task03, this.task02);
        this.createClient(this.p3, 2);
        StickyTaskAssignor<Integer> taskAssignor = this.createTaskAssignor(this.task00, this.task02, this.task03);
        taskAssignor.assign(0);
        MatcherAssert.assertThat((Object)this.clients.get(this.p2).assignedTaskCount(), (Matcher)CoreMatchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)this.clients.get(this.p3).assignedTaskCount(), (Matcher)CoreMatchers.equalTo((Object)2));
    }

    @Test
    public void shouldMoveMinimalNumberOfTasksWhenPreviouslyAboveCapacityAndNewClientAdded() {
        Set p1PrevTasks = Utils.mkSet((Object[])new TaskId[]{this.task00, this.task02});
        Set p2PrevTasks = Utils.mkSet((Object[])new TaskId[]{this.task01, this.task03});
        this.createClientWithPreviousActiveTasks(this.p1, 1, this.task00, this.task02);
        this.createClientWithPreviousActiveTasks(this.p2, 1, this.task01, this.task03);
        this.createClientWithPreviousActiveTasks(this.p3, 1, new TaskId[0]);
        StickyTaskAssignor<Integer> taskAssignor = this.createTaskAssignor(this.task00, this.task02, this.task01, this.task03);
        taskAssignor.assign(0);
        Set p3ActiveTasks = this.clients.get(this.p3).activeTasks();
        MatcherAssert.assertThat((Object)p3ActiveTasks.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        if (p1PrevTasks.removeAll(p3ActiveTasks)) {
            MatcherAssert.assertThat((Object)this.clients.get(this.p2).activeTasks(), (Matcher)CoreMatchers.equalTo((Object)p2PrevTasks));
        } else {
            MatcherAssert.assertThat((Object)this.clients.get(this.p1).activeTasks(), (Matcher)CoreMatchers.equalTo((Object)p1PrevTasks));
        }
    }

    @Test
    public void shouldNotMoveAnyTasksWhenNewTasksAdded() {
        this.createClientWithPreviousActiveTasks(this.p1, 1, this.task00, this.task01);
        this.createClientWithPreviousActiveTasks(this.p2, 1, this.task02, this.task03);
        StickyTaskAssignor<Integer> taskAssignor = this.createTaskAssignor(this.task03, this.task01, this.task04, this.task02, this.task00, this.task05);
        taskAssignor.assign(0);
        MatcherAssert.assertThat((Object)this.clients.get(this.p1).activeTasks(), (Matcher)IsCollectionContaining.hasItems((Object[])new TaskId[]{this.task00, this.task01}));
        MatcherAssert.assertThat((Object)this.clients.get(this.p2).activeTasks(), (Matcher)IsCollectionContaining.hasItems((Object[])new TaskId[]{this.task02, this.task03}));
    }

    @Test
    public void shouldAssignNewTasksToNewClientWhenPreviousTasksAssignedToOldClients() {
        this.createClientWithPreviousActiveTasks(this.p1, 1, this.task02, this.task01);
        this.createClientWithPreviousActiveTasks(this.p2, 1, this.task00, this.task03);
        this.createClient(this.p3, 1);
        StickyTaskAssignor<Integer> taskAssignor = this.createTaskAssignor(this.task03, this.task01, this.task04, this.task02, this.task00, this.task05);
        taskAssignor.assign(0);
        MatcherAssert.assertThat((Object)this.clients.get(this.p1).activeTasks(), (Matcher)IsCollectionContaining.hasItems((Object[])new TaskId[]{this.task02, this.task01}));
        MatcherAssert.assertThat((Object)this.clients.get(this.p2).activeTasks(), (Matcher)IsCollectionContaining.hasItems((Object[])new TaskId[]{this.task00, this.task03}));
        MatcherAssert.assertThat((Object)this.clients.get(this.p3).activeTasks(), (Matcher)IsCollectionContaining.hasItems((Object[])new TaskId[]{this.task04, this.task05}));
    }

    @Test
    public void shouldAssignTasksNotPreviouslyActiveToNewClient() {
        TaskId task10 = new TaskId(0, 10);
        TaskId task11 = new TaskId(0, 11);
        TaskId task12 = new TaskId(1, 2);
        TaskId task13 = new TaskId(1, 3);
        TaskId task20 = new TaskId(2, 0);
        TaskId task21 = new TaskId(2, 1);
        TaskId task22 = new TaskId(2, 2);
        TaskId task23 = new TaskId(2, 3);
        ClientState c1 = this.createClientWithPreviousActiveTasks(this.p1, 1, this.task01, task12, task13);
        c1.addPreviousStandbyTasks(Utils.mkSet((Object[])new TaskId[]{this.task00, task11, task20, task21, task23}));
        ClientState c2 = this.createClientWithPreviousActiveTasks(this.p2, 1, this.task00, task11, task22);
        c2.addPreviousStandbyTasks(Utils.mkSet((Object[])new TaskId[]{this.task01, task10, this.task02, task20, this.task03, task12, task21, task13, task23}));
        ClientState c3 = this.createClientWithPreviousActiveTasks(this.p3, 1, task20, task21, task23);
        c3.addPreviousStandbyTasks(Utils.mkSet((Object[])new TaskId[]{this.task02, task12}));
        ClientState newClient = this.createClient(this.p4, 1);
        newClient.addPreviousStandbyTasks(Utils.mkSet((Object[])new TaskId[]{this.task00, task10, this.task01, this.task02, task11, task20, this.task03, task12, task21, task13, task22, task23}));
        StickyTaskAssignor<Integer> taskAssignor = this.createTaskAssignor(this.task00, task10, this.task01, this.task02, task11, task20, this.task03, task12, task21, task13, task22, task23);
        taskAssignor.assign(0);
        MatcherAssert.assertThat((Object)c1.activeTasks(), (Matcher)CoreMatchers.equalTo((Object)Utils.mkSet((Object[])new TaskId[]{this.task01, task12, task13})));
        MatcherAssert.assertThat((Object)c2.activeTasks(), (Matcher)CoreMatchers.equalTo((Object)Utils.mkSet((Object[])new TaskId[]{this.task00, task11, task22})));
        MatcherAssert.assertThat((Object)c3.activeTasks(), (Matcher)CoreMatchers.equalTo((Object)Utils.mkSet((Object[])new TaskId[]{task20, task21, task23})));
        MatcherAssert.assertThat((Object)newClient.activeTasks(), (Matcher)CoreMatchers.equalTo((Object)Utils.mkSet((Object[])new TaskId[]{this.task02, this.task03, task10})));
    }

    @Test
    public void shouldAssignTasksNotPreviouslyActiveToMultipleNewClients() {
        TaskId task10 = new TaskId(0, 10);
        TaskId task11 = new TaskId(0, 11);
        TaskId task12 = new TaskId(1, 2);
        TaskId task13 = new TaskId(1, 3);
        TaskId task20 = new TaskId(2, 0);
        TaskId task21 = new TaskId(2, 1);
        TaskId task22 = new TaskId(2, 2);
        TaskId task23 = new TaskId(2, 3);
        ClientState c1 = this.createClientWithPreviousActiveTasks(this.p1, 1, this.task01, task12, task13);
        c1.addPreviousStandbyTasks(Utils.mkSet((Object[])new TaskId[]{this.task00, task11, task20, task21, task23}));
        ClientState c2 = this.createClientWithPreviousActiveTasks(this.p2, 1, this.task00, task11, task22);
        c2.addPreviousStandbyTasks(Utils.mkSet((Object[])new TaskId[]{this.task01, task10, this.task02, task20, this.task03, task12, task21, task13, task23}));
        ClientState bounce1 = this.createClient(this.p3, 1);
        bounce1.addPreviousStandbyTasks(Utils.mkSet((Object[])new TaskId[]{task20, task21, task23}));
        ClientState bounce2 = this.createClient(this.p4, 1);
        bounce2.addPreviousStandbyTasks(Utils.mkSet((Object[])new TaskId[]{this.task02, this.task03, task10}));
        StickyTaskAssignor<Integer> taskAssignor = this.createTaskAssignor(this.task00, task10, this.task01, this.task02, task11, task20, this.task03, task12, task21, task13, task22, task23);
        taskAssignor.assign(0);
        MatcherAssert.assertThat((Object)c1.activeTasks(), (Matcher)CoreMatchers.equalTo((Object)Utils.mkSet((Object[])new TaskId[]{this.task01, task12, task13})));
        MatcherAssert.assertThat((Object)c2.activeTasks(), (Matcher)CoreMatchers.equalTo((Object)Utils.mkSet((Object[])new TaskId[]{this.task00, task11, task22})));
        MatcherAssert.assertThat((Object)bounce1.activeTasks(), (Matcher)CoreMatchers.equalTo((Object)Utils.mkSet((Object[])new TaskId[]{task20, task21, task23})));
        MatcherAssert.assertThat((Object)bounce2.activeTasks(), (Matcher)CoreMatchers.equalTo((Object)Utils.mkSet((Object[])new TaskId[]{this.task02, this.task03, task10})));
    }

    @Test
    public void shouldAssignTasksToNewClient() {
        this.createClientWithPreviousActiveTasks(this.p1, 1, this.task01, this.task02);
        this.createClient(this.p2, 1);
        this.createTaskAssignor(this.task01, this.task02).assign(0);
        MatcherAssert.assertThat((Object)this.clients.get(this.p1).activeTaskCount(), (Matcher)CoreMatchers.equalTo((Object)1));
    }

    @Test
    public void shouldAssignTasksToNewClientWithoutFlippingAssignmentBetweenExistingClients() {
        ClientState c1 = this.createClientWithPreviousActiveTasks(this.p1, 1, this.task00, this.task01, this.task02);
        ClientState c2 = this.createClientWithPreviousActiveTasks(this.p2, 1, this.task03, this.task04, this.task05);
        ClientState newClient = this.createClient(this.p3, 1);
        StickyTaskAssignor<Integer> taskAssignor = this.createTaskAssignor(this.task00, this.task01, this.task02, this.task03, this.task04, this.task05);
        taskAssignor.assign(0);
        MatcherAssert.assertThat((Object)c1.activeTasks(), (Matcher)IsNot.not((Matcher)IsCollectionContaining.hasItem((Object)this.task03)));
        MatcherAssert.assertThat((Object)c1.activeTasks(), (Matcher)IsNot.not((Matcher)IsCollectionContaining.hasItem((Object)this.task04)));
        MatcherAssert.assertThat((Object)c1.activeTasks(), (Matcher)IsNot.not((Matcher)IsCollectionContaining.hasItem((Object)this.task05)));
        MatcherAssert.assertThat((Object)c1.activeTaskCount(), (Matcher)CoreMatchers.equalTo((Object)2));
        MatcherAssert.assertThat((Object)c2.activeTasks(), (Matcher)IsNot.not((Matcher)IsCollectionContaining.hasItems((Object[])new TaskId[]{this.task00})));
        MatcherAssert.assertThat((Object)c2.activeTasks(), (Matcher)IsNot.not((Matcher)IsCollectionContaining.hasItems((Object[])new TaskId[]{this.task01})));
        MatcherAssert.assertThat((Object)c2.activeTasks(), (Matcher)IsNot.not((Matcher)IsCollectionContaining.hasItems((Object[])new TaskId[]{this.task02})));
        MatcherAssert.assertThat((Object)c2.activeTaskCount(), (Matcher)CoreMatchers.equalTo((Object)2));
        MatcherAssert.assertThat((Object)newClient.activeTaskCount(), (Matcher)CoreMatchers.equalTo((Object)2));
    }

    @Test
    public void shouldAssignTasksToNewClientWithoutFlippingAssignmentBetweenExistingAndBouncedClients() {
        TaskId task06 = new TaskId(0, 6);
        ClientState c1 = this.createClientWithPreviousActiveTasks(this.p1, 1, this.task00, this.task01, this.task02, task06);
        ClientState c2 = this.createClient(this.p2, 1);
        c2.addPreviousStandbyTasks(Utils.mkSet((Object[])new TaskId[]{this.task03, this.task04, this.task05}));
        ClientState newClient = this.createClient(this.p3, 1);
        StickyTaskAssignor<Integer> taskAssignor = this.createTaskAssignor(this.task00, this.task01, this.task02, this.task03, this.task04, this.task05, task06);
        taskAssignor.assign(0);
        MatcherAssert.assertThat((Object)c1.activeTasks(), (Matcher)IsNot.not((Matcher)IsCollectionContaining.hasItem((Object)this.task03)));
        MatcherAssert.assertThat((Object)c1.activeTasks(), (Matcher)IsNot.not((Matcher)IsCollectionContaining.hasItem((Object)this.task04)));
        MatcherAssert.assertThat((Object)c1.activeTasks(), (Matcher)IsNot.not((Matcher)IsCollectionContaining.hasItem((Object)this.task05)));
        MatcherAssert.assertThat((Object)c1.activeTaskCount(), (Matcher)CoreMatchers.equalTo((Object)3));
        MatcherAssert.assertThat((Object)c2.activeTasks(), (Matcher)IsNot.not((Matcher)IsCollectionContaining.hasItems((Object[])new TaskId[]{this.task00})));
        MatcherAssert.assertThat((Object)c2.activeTasks(), (Matcher)IsNot.not((Matcher)IsCollectionContaining.hasItems((Object[])new TaskId[]{this.task01})));
        MatcherAssert.assertThat((Object)c2.activeTasks(), (Matcher)IsNot.not((Matcher)IsCollectionContaining.hasItems((Object[])new TaskId[]{this.task02})));
        MatcherAssert.assertThat((Object)c2.activeTaskCount(), (Matcher)CoreMatchers.equalTo((Object)2));
        MatcherAssert.assertThat((Object)newClient.activeTaskCount(), (Matcher)CoreMatchers.equalTo((Object)2));
    }

    private StickyTaskAssignor<Integer> createTaskAssignor(TaskId ... tasks) {
        List<TaskId> taskIds = Arrays.asList(tasks);
        Collections.shuffle(taskIds);
        return new StickyTaskAssignor(this.clients, new HashSet<TaskId>(taskIds));
    }

    private List<TaskId> allActiveTasks() {
        ArrayList<TaskId> allActive = new ArrayList<TaskId>();
        for (ClientState client : this.clients.values()) {
            allActive.addAll(client.activeTasks());
        }
        Collections.sort(allActive);
        return allActive;
    }

    private List<TaskId> allStandbyTasks() {
        ArrayList<TaskId> tasks = new ArrayList<TaskId>();
        for (ClientState client : this.clients.values()) {
            tasks.addAll(client.standbyTasks());
        }
        Collections.sort(tasks);
        return tasks;
    }

    private ClientState createClient(Integer processId, int capacity) {
        return this.createClientWithPreviousActiveTasks(processId, capacity, new TaskId[0]);
    }

    private ClientState createClientWithPreviousActiveTasks(Integer processId, int capacity, TaskId ... taskIds) {
        ClientState clientState = new ClientState(capacity);
        clientState.addPreviousActiveTasks(Utils.mkSet((Object[])taskIds));
        this.clients.put(processId, clientState);
        return clientState;
    }

    private void assertActiveTaskTopicGroupIdsEvenlyDistributed() {
        for (Map.Entry<Integer, ClientState> clientStateEntry : this.clients.entrySet()) {
            ArrayList<Integer> topicGroupIds = new ArrayList<Integer>();
            Set activeTasks = clientStateEntry.getValue().activeTasks();
            for (TaskId activeTask : activeTasks) {
                topicGroupIds.add(activeTask.topicGroupId);
            }
            Collections.sort(topicGroupIds);
            MatcherAssert.assertThat(topicGroupIds, (Matcher)CoreMatchers.equalTo(this.expectedTopicGroupIds));
        }
    }

    private Map<Integer, Set<TaskId>> sortClientAssignments(Map<Integer, ClientState> clients) {
        HashMap<Integer, Set<TaskId>> sortedAssignments = new HashMap<Integer, Set<TaskId>>();
        for (Map.Entry<Integer, ClientState> entry : clients.entrySet()) {
            TreeSet sorted = new TreeSet(entry.getValue().activeTasks());
            sortedAssignments.put(entry.getKey(), sorted);
        }
        return sortedAssignments;
    }

    private Set<TaskId> getExpectedTaskIdAssignment(List<TaskId> tasks, int ... indices) {
        TreeSet<TaskId> sortedAssignment = new TreeSet<TaskId>();
        for (int index : indices) {
            sortedAssignment.add(tasks.get(index));
        }
        return sortedAssignment;
    }
}

