/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.errors.InvalidStateStoreException;
import org.apache.kafka.streams.kstream.Window;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.internals.Change;
import org.apache.kafka.streams.kstream.internals.SessionWindow;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.internals.MockStreamsMetrics;
import org.apache.kafka.streams.processor.internals.ProcessorRecordContext;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.SessionStore;
import org.apache.kafka.streams.state.StateSerdes;
import org.apache.kafka.streams.state.internals.CachingSessionStore;
import org.apache.kafka.streams.state.internals.RocksDBSegmentedBytesStore;
import org.apache.kafka.streams.state.internals.RocksDBSessionStore;
import org.apache.kafka.streams.state.internals.RocksDBSessionStoreTest;
import org.apache.kafka.streams.state.internals.SegmentedBytesStore;
import org.apache.kafka.streams.state.internals.SessionKeySchema;
import org.apache.kafka.streams.state.internals.ThreadCache;
import org.apache.kafka.streams.state.internals.WrappedSessionStoreIterator;
import org.apache.kafka.test.InternalMockProcessorContext;
import org.apache.kafka.test.StreamsTestUtils;
import org.apache.kafka.test.TestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CachingSessionStoreTest {
    private static final int MAX_CACHE_SIZE_BYTES = 600;
    private static final Long DEFAULT_TIMESTAMP = 10L;
    private static final long SEGMENT_INTERVAL = 100L;
    private RocksDBSegmentedBytesStore underlying;
    private CachingSessionStore<String, String> cachingStore;
    private ThreadCache cache;
    private final Bytes keyA = Bytes.wrap((byte[])"a".getBytes());
    private final Bytes keyAA = Bytes.wrap((byte[])"aa".getBytes());
    private final Bytes keyB = Bytes.wrap((byte[])"b".getBytes());

    @Before
    public void setUp() {
        SessionKeySchema schema = new SessionKeySchema();
        schema.init("topic");
        this.underlying = new RocksDBSegmentedBytesStore("test", "metrics-scope", 0L, 100L, (SegmentedBytesStore.KeySchema)schema);
        RocksDBSessionStore sessionStore = new RocksDBSessionStore((SegmentedBytesStore)this.underlying, Serdes.Bytes(), Serdes.ByteArray());
        this.cachingStore = new CachingSessionStore((SessionStore)sessionStore, Serdes.String(), Serdes.String(), 100L);
        this.cache = new ThreadCache(new LogContext("testCache "), 600L, (StreamsMetricsImpl)new MockStreamsMetrics(new Metrics()));
        InternalMockProcessorContext context = new InternalMockProcessorContext(TestUtils.tempDirectory(), null, null, null, this.cache);
        context.setRecordContext(new ProcessorRecordContext(DEFAULT_TIMESTAMP.longValue(), 0L, 0, "topic", null));
        this.cachingStore.init((ProcessorContext)context, this.cachingStore);
    }

    @After
    public void close() {
        this.cachingStore.close();
    }

    @Test
    public void shouldPutFetchFromCache() {
        this.cachingStore.put(new Windowed((Object)this.keyA, (Window)new SessionWindow(0L, 0L)), "1".getBytes());
        this.cachingStore.put(new Windowed((Object)this.keyAA, (Window)new SessionWindow(0L, 0L)), "1".getBytes());
        this.cachingStore.put(new Windowed((Object)this.keyB, (Window)new SessionWindow(0L, 0L)), "1".getBytes());
        Assert.assertEquals((long)3L, (long)this.cache.size());
        KeyValueIterator a = this.cachingStore.findSessions(this.keyA, 0L, 0L);
        KeyValueIterator b = this.cachingStore.findSessions(this.keyB, 0L, 0L);
        StreamsTestUtils.verifyWindowedKeyValue((KeyValue<Windowed<Bytes>, byte[]>)((KeyValue)a.next()), (Windowed<Bytes>)new Windowed((Object)this.keyA, (Window)new SessionWindow(0L, 0L)), "1");
        StreamsTestUtils.verifyWindowedKeyValue((KeyValue<Windowed<Bytes>, byte[]>)((KeyValue)b.next()), (Windowed<Bytes>)new Windowed((Object)this.keyB, (Window)new SessionWindow(0L, 0L)), "1");
        Assert.assertFalse((boolean)a.hasNext());
        Assert.assertFalse((boolean)b.hasNext());
    }

    @Test
    public void shouldPutFetchAllKeysFromCache() {
        this.cachingStore.put(new Windowed((Object)this.keyA, (Window)new SessionWindow(0L, 0L)), "1".getBytes());
        this.cachingStore.put(new Windowed((Object)this.keyAA, (Window)new SessionWindow(0L, 0L)), "1".getBytes());
        this.cachingStore.put(new Windowed((Object)this.keyB, (Window)new SessionWindow(0L, 0L)), "1".getBytes());
        Assert.assertEquals((long)3L, (long)this.cache.size());
        KeyValueIterator all = this.cachingStore.findSessions(this.keyA, this.keyB, 0L, 0L);
        StreamsTestUtils.verifyWindowedKeyValue((KeyValue<Windowed<Bytes>, byte[]>)((KeyValue)all.next()), (Windowed<Bytes>)new Windowed((Object)this.keyA, (Window)new SessionWindow(0L, 0L)), "1");
        StreamsTestUtils.verifyWindowedKeyValue((KeyValue<Windowed<Bytes>, byte[]>)((KeyValue)all.next()), (Windowed<Bytes>)new Windowed((Object)this.keyAA, (Window)new SessionWindow(0L, 0L)), "1");
        StreamsTestUtils.verifyWindowedKeyValue((KeyValue<Windowed<Bytes>, byte[]>)((KeyValue)all.next()), (Windowed<Bytes>)new Windowed((Object)this.keyB, (Window)new SessionWindow(0L, 0L)), "1");
        Assert.assertFalse((boolean)all.hasNext());
    }

    @Test
    public void shouldPutFetchRangeFromCache() {
        this.cachingStore.put(new Windowed((Object)this.keyA, (Window)new SessionWindow(0L, 0L)), "1".getBytes());
        this.cachingStore.put(new Windowed((Object)this.keyAA, (Window)new SessionWindow(0L, 0L)), "1".getBytes());
        this.cachingStore.put(new Windowed((Object)this.keyB, (Window)new SessionWindow(0L, 0L)), "1".getBytes());
        Assert.assertEquals((long)3L, (long)this.cache.size());
        KeyValueIterator some = this.cachingStore.findSessions(this.keyAA, this.keyB, 0L, 0L);
        StreamsTestUtils.verifyWindowedKeyValue((KeyValue<Windowed<Bytes>, byte[]>)((KeyValue)some.next()), (Windowed<Bytes>)new Windowed((Object)this.keyAA, (Window)new SessionWindow(0L, 0L)), "1");
        StreamsTestUtils.verifyWindowedKeyValue((KeyValue<Windowed<Bytes>, byte[]>)((KeyValue)some.next()), (Windowed<Bytes>)new Windowed((Object)this.keyB, (Window)new SessionWindow(0L, 0L)), "1");
        Assert.assertFalse((boolean)some.hasNext());
    }

    @Test
    public void shouldFetchAllSessionsWithSameRecordKey() {
        List expected = Arrays.asList(KeyValue.pair((Object)new Windowed((Object)this.keyA, (Window)new SessionWindow(0L, 0L)), (Object)"1".getBytes()), KeyValue.pair((Object)new Windowed((Object)this.keyA, (Window)new SessionWindow(10L, 10L)), (Object)"2".getBytes()), KeyValue.pair((Object)new Windowed((Object)this.keyA, (Window)new SessionWindow(100L, 100L)), (Object)"3".getBytes()), KeyValue.pair((Object)new Windowed((Object)this.keyA, (Window)new SessionWindow(1000L, 1000L)), (Object)"4".getBytes()));
        for (KeyValue keyValue : expected) {
            this.cachingStore.put((Windowed)keyValue.key, (byte[])keyValue.value);
        }
        this.cachingStore.put(new Windowed((Object)this.keyAA, (Window)new SessionWindow(0L, 0L)), "5".getBytes());
        List results = RocksDBSessionStoreTest.toList(this.cachingStore.fetch(this.keyA));
        StreamsTestUtils.verifyKeyValueList(expected, results);
    }

    @Test
    public void shouldFlushItemsToStoreOnEviction() {
        StateSerdes serdes = new StateSerdes("topic", Serdes.Bytes(), Serdes.ByteArray());
        List<KeyValue<Windowed<Bytes>, byte[]>> added = this.addSessionsUntilOverflow("a", "b", "c", "d");
        Assert.assertEquals((long)(added.size() - 1), (long)this.cache.size());
        WrappedSessionStoreIterator iterator = WrappedSessionStoreIterator.bytesIterator((KeyValueIterator)this.underlying.fetch((Bytes)((Windowed)added.get((int)0).key).key(), 0L, 0L), (StateSerdes)serdes);
        KeyValue next = (KeyValue)iterator.next();
        Assert.assertEquals((Object)added.get((int)0).key, (Object)next.key);
        Assert.assertArrayEquals((byte[])((byte[])added.get((int)0).value), (byte[])((byte[])next.value));
    }

    @Test
    public void shouldQueryItemsInCacheAndStore() {
        List added = this.addSessionsUntilOverflow("a");
        KeyValueIterator iterator = this.cachingStore.findSessions(Bytes.wrap((byte[])"a".getBytes()), 0L, (long)(added.size() * 10));
        List actual = RocksDBSessionStoreTest.toList(iterator);
        StreamsTestUtils.verifyKeyValueList(added, actual);
    }

    @Test
    public void shouldRemove() {
        Windowed a = new Windowed((Object)this.keyA, (Window)new SessionWindow(0L, 0L));
        Windowed b = new Windowed((Object)this.keyB, (Window)new SessionWindow(0L, 0L));
        this.cachingStore.put(a, "2".getBytes());
        this.cachingStore.put(b, "2".getBytes());
        this.cachingStore.flush();
        this.cachingStore.remove(a);
        this.cachingStore.flush();
        KeyValueIterator rangeIter = this.cachingStore.findSessions(this.keyA, 0L, 0L);
        Assert.assertFalse((boolean)rangeIter.hasNext());
    }

    @Test
    public void shouldFetchCorrectlyAcrossSegments() {
        Windowed a1 = new Windowed((Object)this.keyA, (Window)new SessionWindow(0L, 0L));
        Windowed a2 = new Windowed((Object)this.keyA, (Window)new SessionWindow(100L, 100L));
        Windowed a3 = new Windowed((Object)this.keyA, (Window)new SessionWindow(200L, 200L));
        this.cachingStore.put(a1, "1".getBytes());
        this.cachingStore.put(a2, "2".getBytes());
        this.cachingStore.put(a3, "3".getBytes());
        this.cachingStore.flush();
        KeyValueIterator results = this.cachingStore.findSessions(this.keyA, 0L, 200L);
        Assert.assertEquals((Object)a1, (Object)((KeyValue)results.next()).key);
        Assert.assertEquals((Object)a2, (Object)((KeyValue)results.next()).key);
        Assert.assertEquals((Object)a3, (Object)((KeyValue)results.next()).key);
        Assert.assertFalse((boolean)results.hasNext());
    }

    @Test
    public void shouldFetchRangeCorrectlyAcrossSegments() {
        Windowed a1 = new Windowed((Object)this.keyA, (Window)new SessionWindow(0L, 0L));
        Windowed aa1 = new Windowed((Object)this.keyAA, (Window)new SessionWindow(0L, 0L));
        Windowed a2 = new Windowed((Object)this.keyA, (Window)new SessionWindow(100L, 100L));
        Windowed a3 = new Windowed((Object)this.keyA, (Window)new SessionWindow(200L, 200L));
        Windowed aa3 = new Windowed((Object)this.keyAA, (Window)new SessionWindow(200L, 200L));
        this.cachingStore.put(a1, "1".getBytes());
        this.cachingStore.put(aa1, "1".getBytes());
        this.cachingStore.put(a2, "2".getBytes());
        this.cachingStore.put(a3, "3".getBytes());
        this.cachingStore.put(aa3, "3".getBytes());
        this.cachingStore.flush();
        KeyValueIterator rangeResults = this.cachingStore.findSessions(this.keyA, this.keyAA, 0L, 200L);
        HashSet<Object> keys = new HashSet<Object>();
        while (rangeResults.hasNext()) {
            keys.add(((KeyValue)rangeResults.next()).key);
        }
        rangeResults.close();
        Assert.assertEquals((Object)Utils.mkSet((Object[])new Windowed[]{a1, a2, a3, aa1, aa3}), keys);
    }

    @Test
    public void shouldForwardChangedValuesDuringFlush() {
        Windowed a = new Windowed((Object)this.keyA, (Window)new SessionWindow(0L, 0L));
        Windowed aDeserialized = new Windowed((Object)"a", (Window)new SessionWindow(0L, 0L));
        ArrayList flushed = new ArrayList();
        this.cachingStore.setFlushListener((key, newValue, oldValue) -> flushed.add(KeyValue.pair((Object)key, (Object)new Change(newValue, oldValue))), true);
        this.cachingStore.put(a, "1".getBytes());
        this.cachingStore.flush();
        this.cachingStore.put(a, "2".getBytes());
        this.cachingStore.flush();
        this.cachingStore.remove(a);
        this.cachingStore.flush();
        Assert.assertEquals(flushed, Arrays.asList(KeyValue.pair((Object)aDeserialized, (Object)new Change((Object)"1", null)), KeyValue.pair((Object)aDeserialized, (Object)new Change((Object)"2", (Object)"1")), KeyValue.pair((Object)aDeserialized, (Object)new Change(null, (Object)"2"))));
    }

    @Test
    public void shouldForwardChangedValuesDuringFlushWhenSendOldValuesDisabledNewRecordIsNull() {
        Windowed a = new Windowed((Object)this.keyA, (Window)new SessionWindow(0L, 0L));
        Windowed aDeserialized = new Windowed((Object)"a", (Window)new SessionWindow(0L, 0L));
        ArrayList flushed = new ArrayList();
        this.cachingStore.setFlushListener((key, newValue, oldValue) -> flushed.add(KeyValue.pair((Object)key, (Object)new Change(newValue, oldValue))), false);
        this.cachingStore.put(a, "1".getBytes());
        this.cachingStore.flush();
        this.cachingStore.put(a, "2".getBytes());
        this.cachingStore.flush();
        this.cachingStore.remove(a);
        this.cachingStore.flush();
        Assert.assertEquals(flushed, Arrays.asList(KeyValue.pair((Object)aDeserialized, (Object)new Change((Object)"1", null)), KeyValue.pair((Object)aDeserialized, (Object)new Change((Object)"2", null)), KeyValue.pair((Object)aDeserialized, (Object)new Change(null, (Object)"2"))));
    }

    @Test
    public void shouldNotForwardChangedValuesDuringFlushWhenSendOldValuesDisabled() {
        Windowed a = new Windowed((Object)this.keyA, (Window)new SessionWindow(0L, 0L));
        Windowed aDeserialized = new Windowed((Object)"a", (Window)new SessionWindow(0L, 0L));
        ArrayList flushed = new ArrayList();
        this.cachingStore.setFlushListener((key, newValue, oldValue) -> flushed.add(KeyValue.pair((Object)key, (Object)new Change(newValue, oldValue))), false);
        this.cachingStore.put(a, "1".getBytes());
        this.cachingStore.flush();
        this.cachingStore.put(a, "2".getBytes());
        this.cachingStore.flush();
        Assert.assertEquals(flushed, Arrays.asList(KeyValue.pair((Object)aDeserialized, (Object)new Change((Object)"1", null)), KeyValue.pair((Object)aDeserialized, (Object)new Change((Object)"2", null))));
    }

    @Test
    public void shouldClearNamespaceCacheOnClose() {
        Windowed a1 = new Windowed((Object)this.keyA, (Window)new SessionWindow(0L, 0L));
        this.cachingStore.put(a1, "1".getBytes());
        Assert.assertEquals((long)1L, (long)this.cache.size());
        this.cachingStore.close();
        Assert.assertEquals((long)0L, (long)this.cache.size());
    }

    @Test(expected=InvalidStateStoreException.class)
    public void shouldThrowIfTryingToFetchFromClosedCachingStore() {
        this.cachingStore.close();
        this.cachingStore.fetch(this.keyA);
    }

    @Test(expected=InvalidStateStoreException.class)
    public void shouldThrowIfTryingToFindMergeSessionFromClosedCachingStore() {
        this.cachingStore.close();
        this.cachingStore.findSessions(this.keyA, 0L, Long.MAX_VALUE);
    }

    @Test(expected=InvalidStateStoreException.class)
    public void shouldThrowIfTryingToRemoveFromClosedCachingStore() {
        this.cachingStore.close();
        this.cachingStore.remove(new Windowed((Object)this.keyA, (Window)new SessionWindow(0L, 0L)));
    }

    @Test(expected=InvalidStateStoreException.class)
    public void shouldThrowIfTryingToPutIntoClosedCachingStore() {
        this.cachingStore.close();
        this.cachingStore.put(new Windowed((Object)this.keyA, (Window)new SessionWindow(0L, 0L)), "1".getBytes());
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerExceptionOnFindSessionsNullKey() {
        this.cachingStore.findSessions(null, 1L, 2L);
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerExceptionOnFindSessionsNullFromKey() {
        this.cachingStore.findSessions(null, this.keyA, 1L, 2L);
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerExceptionOnFindSessionsNullToKey() {
        this.cachingStore.findSessions(this.keyA, null, 1L, 2L);
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerExceptionOnFetchNullFromKey() {
        this.cachingStore.fetch(null, this.keyA);
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerExceptionOnFetchNullToKey() {
        this.cachingStore.fetch(this.keyA, null);
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerExceptionOnFetchNullKey() {
        this.cachingStore.fetch(null);
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerExceptionOnRemoveNullKey() {
        this.cachingStore.remove(null);
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerExceptionOnPutNullKey() {
        this.cachingStore.put(null, "1".getBytes());
    }

    private List<KeyValue<Windowed<Bytes>, byte[]>> addSessionsUntilOverflow(String ... sessionIds) {
        Random random = new Random();
        ArrayList<KeyValue<Windowed<Bytes>, byte[]>> results = new ArrayList<KeyValue<Windowed<Bytes>, byte[]>>();
        while (this.cache.size() == (long)results.size()) {
            String sessionId = sessionIds[random.nextInt(sessionIds.length)];
            this.addSingleSession(sessionId, results);
        }
        return results;
    }

    private void addSingleSession(String sessionId, List<KeyValue<Windowed<Bytes>, byte[]>> allSessions) {
        int timestamp = allSessions.size() * 10;
        Windowed key = new Windowed((Object)Bytes.wrap((byte[])sessionId.getBytes()), (Window)new SessionWindow((long)timestamp, (long)timestamp));
        byte[] value = "1".getBytes();
        this.cachingStore.put(key, value);
        allSessions.add((KeyValue<Windowed<Bytes>, byte[]>)KeyValue.pair((Object)key, (Object)value));
    }
}

