/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream;

import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.streams.internals.ApiUtils;
import org.apache.kafka.streams.kstream.Window;
import org.apache.kafka.streams.kstream.Windows;

public final class JoinWindows
extends Windows<Window> {
    private final long maintainDurationMs;
    public final long beforeMs;
    public final long afterMs;
    private final long graceMs;

    private JoinWindows(long beforeMs, long afterMs, long graceMs, long maintainDurationMs) {
        if (beforeMs + afterMs < 0L) {
            throw new IllegalArgumentException("Window interval (ie, beforeMs+afterMs) must not be negative.");
        }
        this.afterMs = afterMs;
        this.beforeMs = beforeMs;
        this.graceMs = graceMs;
        this.maintainDurationMs = maintainDurationMs;
    }

    private JoinWindows(long beforeMs, long afterMs, long graceMs, long maintainDurationMs, int segments) {
        super(segments);
        if (beforeMs + afterMs < 0L) {
            throw new IllegalArgumentException("Window interval (ie, beforeMs+afterMs) must not be negative.");
        }
        this.afterMs = afterMs;
        this.beforeMs = beforeMs;
        this.graceMs = graceMs;
        this.maintainDurationMs = maintainDurationMs;
    }

    @Deprecated
    public static JoinWindows of(long timeDifferenceMs) throws IllegalArgumentException {
        return new JoinWindows(timeDifferenceMs, timeDifferenceMs, -1L, 86400000L);
    }

    public static JoinWindows of(Duration timeDifference) throws IllegalArgumentException {
        String msgPrefix = ApiUtils.prepareMillisCheckFailMsgPrefix(timeDifference, "timeDifference");
        return JoinWindows.of(ApiUtils.validateMillisecondDuration(timeDifference, msgPrefix));
    }

    @Deprecated
    public JoinWindows before(long timeDifferenceMs) throws IllegalArgumentException {
        return new JoinWindows(timeDifferenceMs, this.afterMs, this.graceMs, this.maintainDurationMs, this.segments);
    }

    public JoinWindows before(Duration timeDifference) throws IllegalArgumentException {
        String msgPrefix = ApiUtils.prepareMillisCheckFailMsgPrefix(timeDifference, "timeDifference");
        return this.before(ApiUtils.validateMillisecondDuration(timeDifference, msgPrefix));
    }

    @Deprecated
    public JoinWindows after(long timeDifferenceMs) throws IllegalArgumentException {
        return new JoinWindows(this.beforeMs, timeDifferenceMs, this.graceMs, this.maintainDurationMs, this.segments);
    }

    public JoinWindows after(Duration timeDifference) throws IllegalArgumentException {
        String msgPrefix = ApiUtils.prepareMillisCheckFailMsgPrefix(timeDifference, "timeDifference");
        return this.after(ApiUtils.validateMillisecondDuration(timeDifference, msgPrefix));
    }

    @Override
    public Map<Long, Window> windowsFor(long timestamp) {
        throw new UnsupportedOperationException("windowsFor() is not supported by JoinWindows.");
    }

    @Override
    public long size() {
        return this.beforeMs + this.afterMs;
    }

    public JoinWindows grace(Duration afterWindowEnd) throws IllegalArgumentException {
        String msgPrefix = ApiUtils.prepareMillisCheckFailMsgPrefix(afterWindowEnd, "afterWindowEnd");
        long afterWindowEndMs = ApiUtils.validateMillisecondDuration(afterWindowEnd, msgPrefix);
        if (afterWindowEndMs < 0L) {
            throw new IllegalArgumentException("Grace period must not be negative.");
        }
        return new JoinWindows(this.beforeMs, this.afterMs, afterWindowEndMs, this.maintainDurationMs, this.segments);
    }

    @Override
    public long gracePeriodMs() {
        return this.graceMs != -1L ? this.graceMs : this.maintainMs() - this.size();
    }

    @Deprecated
    public JoinWindows until(long durationMs) throws IllegalArgumentException {
        if (durationMs < this.size()) {
            throw new IllegalArgumentException("Window retention time (durationMs) cannot be smaller than the window size.");
        }
        return new JoinWindows(this.beforeMs, this.afterMs, this.graceMs, durationMs, this.segments);
    }

    @Override
    @Deprecated
    public long maintainMs() {
        return Math.max(this.maintainDurationMs, this.size());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JoinWindows that = (JoinWindows)o;
        return this.beforeMs == that.beforeMs && this.afterMs == that.afterMs && this.maintainDurationMs == that.maintainDurationMs && this.segments == that.segments && this.graceMs == that.graceMs;
    }

    public int hashCode() {
        return Objects.hash(this.beforeMs, this.afterMs, this.graceMs, this.maintainDurationMs, this.segments);
    }

    public String toString() {
        return "JoinWindows{beforeMs=" + this.beforeMs + ", afterMs=" + this.afterMs + ", graceMs=" + this.graceMs + ", maintainDurationMs=" + this.maintainDurationMs + ", segments=" + this.segments + '}';
    }
}

