/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.integration;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import kafka.tools.StreamsResetter;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.ConsumerGroupDescription;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.serialization.LongDeserializer;
import org.apache.kafka.common.serialization.LongSerializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.streams.KafkaStreams;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.Topology;
import org.apache.kafka.streams.integration.utils.EmbeddedKafkaCluster;
import org.apache.kafka.streams.integration.utils.IntegrationTestUtils;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.Produced;
import org.apache.kafka.streams.kstream.TimeWindows;
import org.apache.kafka.streams.kstream.Windows;
import org.apache.kafka.test.IntegrationTest;
import org.apache.kafka.test.TestCondition;
import org.apache.kafka.test.TestUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.experimental.categories.Category;
import org.junit.rules.TemporaryFolder;

@Category(value={IntegrationTest.class})
public abstract class AbstractResetIntegrationTest {
    static String testId;
    static EmbeddedKafkaCluster cluster;
    private static MockTime mockTime;
    private static KafkaStreams streams;
    private static Admin adminClient;
    private String appID = "abstract-reset-integration-test";
    private Properties commonClientConfig;
    private Properties streamsConfig;
    private Properties producerConfig;
    private Properties resultConsumerConfig;
    @Rule
    public final TemporaryFolder testFolder = new TemporaryFolder(TestUtils.tempDirectory());
    private static final String INPUT_TOPIC = "inputTopic";
    private static final String OUTPUT_TOPIC = "outputTopic";
    private static final String OUTPUT_TOPIC_2 = "outputTopic2";
    private static final String OUTPUT_TOPIC_2_RERUN = "outputTopic2_rerun";
    private static final String INTERMEDIATE_USER_TOPIC = "userTopic";
    private static final String NON_EXISTING_TOPIC = "nonExistingTopic";
    private static final long STREAMS_CONSUMER_TIMEOUT = 2000L;
    private static final long CLEANUP_CONSUMER_TIMEOUT = 2000L;
    private static final int TIMEOUT_MULTIPLIER = 15;

    abstract Map<String, Object> getClientSslConfig();

    @AfterClass
    public static void afterClassCleanup() {
        if (adminClient != null) {
            adminClient.close(Duration.ofSeconds(10L));
            adminClient = null;
        }
    }

    private void prepareEnvironment() {
        if (adminClient == null) {
            adminClient = Admin.create((Properties)this.commonClientConfig);
        }
        boolean timeSet = false;
        while (!timeSet) {
            timeSet = this.setCurrentTime();
        }
    }

    private boolean setCurrentTime() {
        boolean currentTimeSet = false;
        try {
            mockTime = AbstractResetIntegrationTest.cluster.time;
            long alignedTime = (System.currentTimeMillis() / 1000L + 1L) * 1000L;
            mockTime.setCurrentTimeMs(alignedTime);
            currentTimeSet = true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return currentTimeSet;
    }

    private void prepareConfigs() {
        this.commonClientConfig = new Properties();
        this.commonClientConfig.put("bootstrap.servers", cluster.bootstrapServers());
        Map<String, Object> sslConfig = this.getClientSslConfig();
        if (sslConfig != null) {
            this.commonClientConfig.put("ssl.truststore.location", sslConfig.get("ssl.truststore.location"));
            this.commonClientConfig.put("ssl.truststore.password", ((Password)sslConfig.get("ssl.truststore.password")).value());
            this.commonClientConfig.put("security.protocol", "SSL");
        }
        this.producerConfig = new Properties();
        this.producerConfig.put("acks", "all");
        this.producerConfig.put("retries", (Object)0);
        this.producerConfig.put("key.serializer", LongSerializer.class);
        this.producerConfig.put("value.serializer", StringSerializer.class);
        this.producerConfig.putAll((Map<?, ?>)this.commonClientConfig);
        this.resultConsumerConfig = new Properties();
        this.resultConsumerConfig.put("group.id", testId + "-result-consumer");
        this.resultConsumerConfig.put("auto.offset.reset", "earliest");
        this.resultConsumerConfig.put("key.deserializer", LongDeserializer.class);
        this.resultConsumerConfig.put("value.deserializer", LongDeserializer.class);
        this.resultConsumerConfig.putAll((Map<?, ?>)this.commonClientConfig);
        this.streamsConfig = new Properties();
        this.streamsConfig.put("state.dir", this.testFolder.getRoot().getPath());
        this.streamsConfig.put("default.key.serde", Serdes.Long().getClass());
        this.streamsConfig.put("default.value.serde", Serdes.String().getClass());
        this.streamsConfig.put("cache.max.bytes.buffering", (Object)0);
        this.streamsConfig.put("commit.interval.ms", (Object)100);
        this.streamsConfig.put("heartbeat.interval.ms", (Object)100);
        this.streamsConfig.put("auto.offset.reset", "earliest");
        this.streamsConfig.put("session.timeout.ms", "2000");
        this.streamsConfig.putAll((Map<?, ?>)this.commonClientConfig);
    }

    void prepareTest() throws Exception {
        this.prepareConfigs();
        this.prepareEnvironment();
        TestUtils.waitForCondition((TestCondition)new ConsumerGroupInactiveCondition(), (long)30000L, (String)("Test consumer group " + this.appID + " still active even after waiting " + 30000L + " ms."));
        cluster.deleteAndRecreateTopics(INPUT_TOPIC, OUTPUT_TOPIC, OUTPUT_TOPIC_2, OUTPUT_TOPIC_2_RERUN);
        this.add10InputElements();
    }

    void cleanupTest() throws Exception {
        if (streams != null) {
            streams.close(Duration.ofSeconds(30L));
        }
        IntegrationTestUtils.purgeLocalStreamsState(this.streamsConfig);
    }

    private void add10InputElements() throws ExecutionException, InterruptedException {
        List<KeyValue> records = Arrays.asList(KeyValue.pair((Object)0L, (Object)"aaa"), KeyValue.pair((Object)1L, (Object)"bbb"), KeyValue.pair((Object)0L, (Object)"ccc"), KeyValue.pair((Object)1L, (Object)"ddd"), KeyValue.pair((Object)0L, (Object)"eee"), KeyValue.pair((Object)1L, (Object)"fff"), KeyValue.pair((Object)0L, (Object)"ggg"), KeyValue.pair((Object)1L, (Object)"hhh"), KeyValue.pair((Object)0L, (Object)"iii"), KeyValue.pair((Object)1L, (Object)"jjj"));
        for (KeyValue record : records) {
            mockTime.sleep(10L);
            IntegrationTestUtils.produceKeyValuesSynchronouslyWithTimestamp(INPUT_TOPIC, Collections.singleton(record), this.producerConfig, mockTime.milliseconds());
        }
    }

    void shouldNotAllowToResetWhileStreamsIsRunning() {
        this.appID = testId + "-not-reset-during-runtime";
        String[] parameters = new String[]{"--application-id", this.appID, "--bootstrap-servers", cluster.bootstrapServers(), "--input-topics", NON_EXISTING_TOPIC, "--execute"};
        Properties cleanUpConfig = new Properties();
        cleanUpConfig.put("heartbeat.interval.ms", (Object)100);
        cleanUpConfig.put("session.timeout.ms", "2000");
        this.streamsConfig.put("application.id", this.appID);
        streams = new KafkaStreams(this.setupTopologyWithoutIntermediateUserTopic(), this.streamsConfig);
        streams.start();
        int exitCode = new StreamsResetter().run(parameters, cleanUpConfig);
        Assert.assertEquals((long)1L, (long)exitCode);
        streams.close();
    }

    public void shouldNotAllowToResetWhenInputTopicAbsent() throws Exception {
        this.appID = testId + "-not-reset-without-input-topic";
        String[] parameters = new String[]{"--application-id", this.appID, "--bootstrap-servers", cluster.bootstrapServers(), "--input-topics", NON_EXISTING_TOPIC, "--execute"};
        Properties cleanUpConfig = new Properties();
        cleanUpConfig.put("heartbeat.interval.ms", (Object)100);
        cleanUpConfig.put("session.timeout.ms", "2000");
        int exitCode = new StreamsResetter().run(parameters, cleanUpConfig);
        Assert.assertEquals((long)1L, (long)exitCode);
    }

    public void shouldNotAllowToResetWhenIntermediateTopicAbsent() throws Exception {
        this.appID = testId + "-not-reset-without-intermediate-topic";
        String[] parameters = new String[]{"--application-id", this.appID, "--bootstrap-servers", cluster.bootstrapServers(), "--intermediate-topics", NON_EXISTING_TOPIC, "--execute"};
        Properties cleanUpConfig = new Properties();
        cleanUpConfig.put("heartbeat.interval.ms", (Object)100);
        cleanUpConfig.put("session.timeout.ms", "2000");
        int exitCode = new StreamsResetter().run(parameters, cleanUpConfig);
        Assert.assertEquals((long)1L, (long)exitCode);
    }

    void testReprocessingFromScratchAfterResetWithoutIntermediateUserTopic() throws Exception {
        this.appID = testId + "-from-scratch";
        this.streamsConfig.put("application.id", this.appID);
        streams = new KafkaStreams(this.setupTopologyWithoutIntermediateUserTopic(), this.streamsConfig);
        streams.start();
        List result = IntegrationTestUtils.waitUntilMinKeyValueRecordsReceived(this.resultConsumerConfig, OUTPUT_TOPIC, 10);
        streams.close();
        TestUtils.waitForCondition((TestCondition)new ConsumerGroupInactiveCondition(), (long)30000L, (String)("Streams Application consumer group " + this.appID + " did not time out after " + 30000L + " ms."));
        streams = new KafkaStreams(this.setupTopologyWithoutIntermediateUserTopic(), this.streamsConfig);
        streams.cleanUp();
        this.cleanGlobal(false, null, null);
        TestUtils.waitForCondition((TestCondition)new ConsumerGroupInactiveCondition(), (long)30000L, (String)("Reset Tool consumer group " + this.appID + " did not time out after " + 30000L + " ms."));
        this.assertInternalTopicsGotDeleted(null);
        streams.start();
        List resultRerun = IntegrationTestUtils.waitUntilMinKeyValueRecordsReceived(this.resultConsumerConfig, OUTPUT_TOPIC, 10);
        streams.close();
        MatcherAssert.assertThat(resultRerun, (Matcher)CoreMatchers.equalTo(result));
        TestUtils.waitForCondition((TestCondition)new ConsumerGroupInactiveCondition(), (long)30000L, (String)("Reset Tool consumer group " + this.appID + " did not time out after " + 30000L + " ms."));
        this.cleanGlobal(false, null, null);
    }

    void testReprocessingFromScratchAfterResetWithIntermediateUserTopic() throws Exception {
        cluster.createTopic(INTERMEDIATE_USER_TOPIC);
        this.appID = testId + "-from-scratch-with-intermediate-topic";
        this.streamsConfig.put("application.id", this.appID);
        streams = new KafkaStreams(this.setupTopologyWithIntermediateUserTopic(OUTPUT_TOPIC_2), this.streamsConfig);
        streams.start();
        List result = IntegrationTestUtils.waitUntilMinKeyValueRecordsReceived(this.resultConsumerConfig, OUTPUT_TOPIC, 10);
        List result2 = IntegrationTestUtils.waitUntilMinKeyValueRecordsReceived(this.resultConsumerConfig, OUTPUT_TOPIC_2, 40);
        streams.close();
        TestUtils.waitForCondition((TestCondition)new ConsumerGroupInactiveCondition(), (long)30000L, (String)("Streams Application consumer group " + this.appID + " did not time out after " + 30000L + " ms."));
        mockTime.sleep(1L);
        KeyValue badMessage = new KeyValue((Object)-1L, (Object)"badRecord-ShouldBeSkipped");
        IntegrationTestUtils.produceKeyValuesSynchronouslyWithTimestamp(INTERMEDIATE_USER_TOPIC, Collections.singleton(badMessage), this.producerConfig, mockTime.milliseconds());
        streams = new KafkaStreams(this.setupTopologyWithIntermediateUserTopic(OUTPUT_TOPIC_2_RERUN), this.streamsConfig);
        streams.cleanUp();
        this.cleanGlobal(true, null, null);
        TestUtils.waitForCondition((TestCondition)new ConsumerGroupInactiveCondition(), (long)30000L, (String)("Reset Tool consumer group " + this.appID + " did not time out after " + 30000L + " ms."));
        this.assertInternalTopicsGotDeleted(INTERMEDIATE_USER_TOPIC);
        streams.start();
        List resultRerun = IntegrationTestUtils.waitUntilMinKeyValueRecordsReceived(this.resultConsumerConfig, OUTPUT_TOPIC, 10);
        List resultRerun2 = IntegrationTestUtils.waitUntilMinKeyValueRecordsReceived(this.resultConsumerConfig, OUTPUT_TOPIC_2_RERUN, 40);
        streams.close();
        MatcherAssert.assertThat(resultRerun, (Matcher)CoreMatchers.equalTo(result));
        MatcherAssert.assertThat(resultRerun2, (Matcher)CoreMatchers.equalTo(result2));
        Properties props = TestUtils.consumerConfig((String)cluster.bootstrapServers(), (String)(testId + "-result-consumer"), LongDeserializer.class, StringDeserializer.class, (Properties)this.commonClientConfig);
        List resultIntermediate = IntegrationTestUtils.waitUntilMinKeyValueRecordsReceived(props, INTERMEDIATE_USER_TOPIC, 21);
        for (int i = 0; i < 10; ++i) {
            MatcherAssert.assertThat(resultIntermediate.get(i), (Matcher)CoreMatchers.equalTo(resultIntermediate.get(i + 11)));
        }
        MatcherAssert.assertThat(resultIntermediate.get(10), (Matcher)CoreMatchers.equalTo((Object)badMessage));
        TestUtils.waitForCondition((TestCondition)new ConsumerGroupInactiveCondition(), (long)30000L, (String)("Reset Tool consumer group " + this.appID + " did not time out after " + 30000L + " ms."));
        this.cleanGlobal(true, null, null);
        cluster.deleteTopicAndWait(INTERMEDIATE_USER_TOPIC);
    }

    void testReprocessingFromFileAfterResetWithoutIntermediateUserTopic() throws Exception {
        this.appID = testId + "-from-file";
        this.streamsConfig.put("application.id", this.appID);
        streams = new KafkaStreams(this.setupTopologyWithoutIntermediateUserTopic(), this.streamsConfig);
        streams.start();
        List result = IntegrationTestUtils.waitUntilMinKeyValueRecordsReceived(this.resultConsumerConfig, OUTPUT_TOPIC, 10);
        streams.close();
        TestUtils.waitForCondition((TestCondition)new ConsumerGroupInactiveCondition(), (long)30000L, (String)("Streams Application consumer group " + this.appID + " did not time out after " + 30000L + " ms."));
        File resetFile = File.createTempFile("reset", ".csv");
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(resetFile));){
            writer.write("inputTopic,0,1");
        }
        streams = new KafkaStreams(this.setupTopologyWithoutIntermediateUserTopic(), this.streamsConfig);
        streams.cleanUp();
        this.cleanGlobal(false, "--from-file", resetFile.getAbsolutePath());
        TestUtils.waitForCondition((TestCondition)new ConsumerGroupInactiveCondition(), (long)30000L, (String)("Reset Tool consumer group " + this.appID + " did not time out after " + 30000L + " ms."));
        this.assertInternalTopicsGotDeleted(null);
        resetFile.deleteOnExit();
        streams.start();
        List resultRerun = IntegrationTestUtils.waitUntilMinKeyValueRecordsReceived(this.resultConsumerConfig, OUTPUT_TOPIC, 5);
        streams.close();
        result.remove(0);
        MatcherAssert.assertThat(resultRerun, (Matcher)CoreMatchers.equalTo(result));
        TestUtils.waitForCondition((TestCondition)new ConsumerGroupInactiveCondition(), (long)30000L, (String)("Reset Tool consumer group " + this.appID + " did not time out after " + 30000L + " ms."));
        this.cleanGlobal(false, null, null);
    }

    void testReprocessingFromDateTimeAfterResetWithoutIntermediateUserTopic() throws Exception {
        this.appID = testId + "-from-datetime";
        this.streamsConfig.put("application.id", this.appID);
        streams = new KafkaStreams(this.setupTopologyWithoutIntermediateUserTopic(), this.streamsConfig);
        streams.start();
        List result = IntegrationTestUtils.waitUntilMinKeyValueRecordsReceived(this.resultConsumerConfig, OUTPUT_TOPIC, 10);
        streams.close();
        TestUtils.waitForCondition((TestCondition)new ConsumerGroupInactiveCondition(), (long)30000L, (String)("Streams Application consumer group " + this.appID + " did not time out after " + 30000L + " ms."));
        File resetFile = File.createTempFile("reset", ".csv");
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(resetFile));){
            writer.write("inputTopic,0,1");
        }
        streams = new KafkaStreams(this.setupTopologyWithoutIntermediateUserTopic(), this.streamsConfig);
        streams.cleanUp();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -1);
        this.cleanGlobal(false, "--to-datetime", format.format(calendar.getTime()));
        TestUtils.waitForCondition((TestCondition)new ConsumerGroupInactiveCondition(), (long)30000L, (String)("Reset Tool consumer group " + this.appID + " did not time out after " + 30000L + " ms."));
        this.assertInternalTopicsGotDeleted(null);
        resetFile.deleteOnExit();
        streams.start();
        List resultRerun = IntegrationTestUtils.waitUntilMinKeyValueRecordsReceived(this.resultConsumerConfig, OUTPUT_TOPIC, 10);
        streams.close();
        MatcherAssert.assertThat(resultRerun, (Matcher)CoreMatchers.equalTo(result));
        TestUtils.waitForCondition((TestCondition)new ConsumerGroupInactiveCondition(), (long)30000L, (String)("Reset Tool consumer group " + this.appID + " did not time out after " + 30000L + " ms."));
        this.cleanGlobal(false, null, null);
    }

    void testReprocessingByDurationAfterResetWithoutIntermediateUserTopic() throws Exception {
        this.appID = testId + "-from-duration";
        this.streamsConfig.put("application.id", this.appID);
        streams = new KafkaStreams(this.setupTopologyWithoutIntermediateUserTopic(), this.streamsConfig);
        streams.start();
        List result = IntegrationTestUtils.waitUntilMinKeyValueRecordsReceived(this.resultConsumerConfig, OUTPUT_TOPIC, 10);
        streams.close();
        TestUtils.waitForCondition((TestCondition)new ConsumerGroupInactiveCondition(), (long)30000L, (String)("Streams Application consumer group " + this.appID + "  did not time out after " + 30000L + " ms."));
        File resetFile = File.createTempFile("reset", ".csv");
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(resetFile));){
            writer.write("inputTopic,0,1");
        }
        streams = new KafkaStreams(this.setupTopologyWithoutIntermediateUserTopic(), this.streamsConfig);
        streams.cleanUp();
        this.cleanGlobal(false, "--by-duration", "PT1M");
        TestUtils.waitForCondition((TestCondition)new ConsumerGroupInactiveCondition(), (long)30000L, (String)("Reset Tool consumer group " + this.appID + " did not time out after " + 30000L + " ms."));
        this.assertInternalTopicsGotDeleted(null);
        resetFile.deleteOnExit();
        streams.start();
        List resultRerun = IntegrationTestUtils.waitUntilMinKeyValueRecordsReceived(this.resultConsumerConfig, OUTPUT_TOPIC, 10);
        streams.close();
        MatcherAssert.assertThat(resultRerun, (Matcher)CoreMatchers.equalTo(result));
        TestUtils.waitForCondition((TestCondition)new ConsumerGroupInactiveCondition(), (long)30000L, (String)("Reset Tool consumer group " + this.appID + " did not time out after " + 30000L + " ms."));
        this.cleanGlobal(false, null, null);
    }

    private Topology setupTopologyWithIntermediateUserTopic(String outputTopic2) {
        StreamsBuilder builder = new StreamsBuilder();
        KStream input = builder.stream(INPUT_TOPIC);
        input.map(KeyValue::new).groupByKey().count().toStream().to(OUTPUT_TOPIC, Produced.with((Serde)Serdes.Long(), (Serde)Serdes.Long()));
        input.through(INTERMEDIATE_USER_TOPIC).groupByKey().windowedBy((Windows)TimeWindows.of((Duration)Duration.ofMillis(35L)).advanceBy(Duration.ofMillis(10L))).count().toStream().map((key, value) -> new KeyValue((Object)(key.window().start() + key.window().end()), value)).to(outputTopic2, Produced.with((Serde)Serdes.Long(), (Serde)Serdes.Long()));
        return builder.build();
    }

    private Topology setupTopologyWithoutIntermediateUserTopic() {
        StreamsBuilder builder = new StreamsBuilder();
        KStream input = builder.stream(INPUT_TOPIC);
        input.map((key, value) -> new KeyValue(key, key)).to(OUTPUT_TOPIC, Produced.with((Serde)Serdes.Long(), (Serde)Serdes.Long()));
        return builder.build();
    }

    private void cleanGlobal(boolean withIntermediateTopics, String resetScenario, String resetScenarioArg) throws Exception {
        Map<String, Object> sslConfig;
        ArrayList<String> parameterList = new ArrayList<String>(Arrays.asList("--application-id", this.appID, "--bootstrap-servers", cluster.bootstrapServers(), "--input-topics", INPUT_TOPIC, "--execute"));
        if (withIntermediateTopics) {
            parameterList.add("--intermediate-topics");
            parameterList.add(INTERMEDIATE_USER_TOPIC);
        }
        if ((sslConfig = this.getClientSslConfig()) != null) {
            File configFile = TestUtils.tempFile();
            BufferedWriter writer = new BufferedWriter(new FileWriter(configFile));
            writer.write("security.protocol=SSL\n");
            writer.write("ssl.truststore.location=" + sslConfig.get("ssl.truststore.location") + "\n");
            writer.write("ssl.truststore.password=" + ((Password)sslConfig.get("ssl.truststore.password")).value() + "\n");
            writer.close();
            parameterList.add("--config-file");
            parameterList.add(configFile.getAbsolutePath());
        }
        if (resetScenario != null) {
            parameterList.add(resetScenario);
        }
        if (resetScenarioArg != null) {
            parameterList.add(resetScenarioArg);
        }
        String[] parameters = parameterList.toArray(new String[0]);
        Properties cleanUpConfig = new Properties();
        cleanUpConfig.put("heartbeat.interval.ms", (Object)100);
        cleanUpConfig.put("session.timeout.ms", "2000");
        int exitCode = new StreamsResetter().run(parameters, cleanUpConfig);
        Assert.assertEquals((long)0L, (long)exitCode);
    }

    private void assertInternalTopicsGotDeleted(String intermediateUserTopic) throws Exception {
        if (intermediateUserTopic != null) {
            cluster.waitForRemainingTopics(30000L, INPUT_TOPIC, OUTPUT_TOPIC, OUTPUT_TOPIC_2, OUTPUT_TOPIC_2_RERUN, "__consumer_offsets", intermediateUserTopic);
        } else {
            cluster.waitForRemainingTopics(30000L, INPUT_TOPIC, OUTPUT_TOPIC, OUTPUT_TOPIC_2, OUTPUT_TOPIC_2_RERUN, "__consumer_offsets");
        }
    }

    static {
        adminClient = null;
    }

    private class ConsumerGroupInactiveCondition
    implements TestCondition {
        private ConsumerGroupInactiveCondition() {
        }

        public boolean conditionMet() {
            try {
                ConsumerGroupDescription groupDescription = (ConsumerGroupDescription)((KafkaFuture)adminClient.describeConsumerGroups(Collections.singletonList(AbstractResetIntegrationTest.this.appID)).describedGroups().get(AbstractResetIntegrationTest.this.appID)).get();
                return groupDescription.members().isEmpty();
            }
            catch (InterruptedException | ExecutionException e) {
                return false;
            }
        }
    }
}

