/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.MockAdminClient;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.errors.StreamsException;
import org.apache.kafka.streams.processor.internals.InternalTopicManager;
import org.apache.kafka.streams.processor.internals.RepartitionTopicConfig;
import org.apache.kafka.streams.processor.internals.UnwindowedChangelogTopicConfig;
import org.apache.kafka.streams.processor.internals.WindowedChangelogTopicConfig;
import org.apache.kafka.streams.processor.internals.testutil.LogCaptureAppender;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class InternalTopicManagerTest {
    private final Node broker1 = new Node(0, "dummyHost-1", 1234);
    private final Node broker2 = new Node(1, "dummyHost-2", 1234);
    private final List<Node> cluster = new ArrayList<Node>(2){
        {
            this.add(InternalTopicManagerTest.this.broker1);
            this.add(InternalTopicManagerTest.this.broker2);
        }
    };
    private final String topic = "test_topic";
    private final String topic2 = "test_topic_2";
    private final String topic3 = "test_topic_3";
    private final List<Node> singleReplica = Collections.singletonList(this.broker1);
    private MockAdminClient mockAdminClient;
    private InternalTopicManager internalTopicManager;
    private final Map<String, Object> config = new HashMap<String, Object>(){
        {
            this.put("application.id", "app-id");
            this.put("bootstrap.servers", InternalTopicManagerTest.this.broker1.host() + ":" + InternalTopicManagerTest.this.broker1.port());
            this.put("replication.factor", 1);
            this.put(StreamsConfig.adminClientPrefix((String)"retries"), 1);
            this.put(StreamsConfig.producerPrefix((String)"batch.size"), 16384);
        }
    };

    @Before
    public void init() {
        this.mockAdminClient = new MockAdminClient(this.cluster, this.broker1);
        this.internalTopicManager = new InternalTopicManager((Admin)this.mockAdminClient, new StreamsConfig(this.config));
    }

    @After
    public void shutdown() {
        this.mockAdminClient.close();
    }

    @Test
    public void shouldReturnCorrectPartitionCounts() {
        this.mockAdminClient.addTopic(false, "test_topic", Collections.singletonList(new TopicPartitionInfo(0, this.broker1, this.singleReplica, Collections.emptyList())), null);
        Assert.assertEquals(Collections.singletonMap("test_topic", 1), (Object)this.internalTopicManager.getNumPartitions(Collections.singleton("test_topic")));
    }

    @Test
    public void shouldCreateRequiredTopics() throws Exception {
        RepartitionTopicConfig topicConfig = new RepartitionTopicConfig("test_topic", Collections.emptyMap());
        topicConfig.setNumberOfPartitions(1);
        UnwindowedChangelogTopicConfig topicConfig2 = new UnwindowedChangelogTopicConfig("test_topic_2", Collections.emptyMap());
        topicConfig2.setNumberOfPartitions(1);
        WindowedChangelogTopicConfig topicConfig3 = new WindowedChangelogTopicConfig("test_topic_3", Collections.emptyMap());
        topicConfig3.setNumberOfPartitions(1);
        this.internalTopicManager.makeReady(Collections.singletonMap("test_topic", topicConfig));
        this.internalTopicManager.makeReady(Collections.singletonMap("test_topic_2", topicConfig2));
        this.internalTopicManager.makeReady(Collections.singletonMap("test_topic_3", topicConfig3));
        Assert.assertEquals((Object)Utils.mkSet((Object[])new String[]{"test_topic", "test_topic_2", "test_topic_3"}), (Object)this.mockAdminClient.listTopics().names().get());
        Assert.assertEquals((Object)new TopicDescription("test_topic", false, (List)new ArrayList<TopicPartitionInfo>(){
            {
                this.add(new TopicPartitionInfo(0, InternalTopicManagerTest.this.broker1, InternalTopicManagerTest.this.singleReplica, Collections.emptyList()));
            }
        }), (Object)((KafkaFuture)this.mockAdminClient.describeTopics(Collections.singleton("test_topic")).values().get("test_topic")).get());
        Assert.assertEquals((Object)new TopicDescription("test_topic_2", false, (List)new ArrayList<TopicPartitionInfo>(){
            {
                this.add(new TopicPartitionInfo(0, InternalTopicManagerTest.this.broker1, InternalTopicManagerTest.this.singleReplica, Collections.emptyList()));
            }
        }), (Object)((KafkaFuture)this.mockAdminClient.describeTopics(Collections.singleton("test_topic_2")).values().get("test_topic_2")).get());
        Assert.assertEquals((Object)new TopicDescription("test_topic_3", false, (List)new ArrayList<TopicPartitionInfo>(){
            {
                this.add(new TopicPartitionInfo(0, InternalTopicManagerTest.this.broker1, InternalTopicManagerTest.this.singleReplica, Collections.emptyList()));
            }
        }), (Object)((KafkaFuture)this.mockAdminClient.describeTopics(Collections.singleton("test_topic_3")).values().get("test_topic_3")).get());
        ConfigResource resource = new ConfigResource(ConfigResource.Type.TOPIC, "test_topic");
        ConfigResource resource2 = new ConfigResource(ConfigResource.Type.TOPIC, "test_topic_2");
        ConfigResource resource3 = new ConfigResource(ConfigResource.Type.TOPIC, "test_topic_3");
        Assert.assertEquals((Object)new ConfigEntry("cleanup.policy", "delete"), (Object)((Config)((KafkaFuture)this.mockAdminClient.describeConfigs(Collections.singleton(resource)).values().get(resource)).get()).get("cleanup.policy"));
        Assert.assertEquals((Object)new ConfigEntry("cleanup.policy", "compact"), (Object)((Config)((KafkaFuture)this.mockAdminClient.describeConfigs(Collections.singleton(resource2)).values().get(resource2)).get()).get("cleanup.policy"));
        Assert.assertEquals((Object)new ConfigEntry("cleanup.policy", "compact,delete"), (Object)((Config)((KafkaFuture)this.mockAdminClient.describeConfigs(Collections.singleton(resource3)).values().get(resource3)).get()).get("cleanup.policy"));
    }

    @Test
    public void shouldNotCreateTopicIfExistsWithDifferentPartitions() {
        this.mockAdminClient.addTopic(false, "test_topic", (List)new ArrayList<TopicPartitionInfo>(){
            {
                this.add(new TopicPartitionInfo(0, InternalTopicManagerTest.this.broker1, InternalTopicManagerTest.this.singleReplica, Collections.emptyList()));
                this.add(new TopicPartitionInfo(1, InternalTopicManagerTest.this.broker1, InternalTopicManagerTest.this.singleReplica, Collections.emptyList()));
            }
        }, null);
        try {
            RepartitionTopicConfig internalTopicConfig = new RepartitionTopicConfig("test_topic", Collections.emptyMap());
            internalTopicConfig.setNumberOfPartitions(1);
            this.internalTopicManager.makeReady(Collections.singletonMap("test_topic", internalTopicConfig));
            Assert.fail((String)"Should have thrown StreamsException");
        }
        catch (StreamsException streamsException) {
            // empty catch block
        }
    }

    @Test
    public void shouldNotThrowExceptionIfExistsWithDifferentReplication() {
        this.mockAdminClient.addTopic(false, "test_topic", Collections.singletonList(new TopicPartitionInfo(0, this.broker1, this.cluster, Collections.emptyList())), null);
        InternalTopicManager internalTopicManager2 = new InternalTopicManager((Admin)this.mockAdminClient, new StreamsConfig(this.config));
        RepartitionTopicConfig internalTopicConfig = new RepartitionTopicConfig("test_topic", Collections.emptyMap());
        internalTopicConfig.setNumberOfPartitions(1);
        internalTopicManager2.makeReady(Collections.singletonMap("test_topic", internalTopicConfig));
    }

    @Test
    public void shouldNotThrowExceptionForEmptyTopicMap() {
        this.internalTopicManager.makeReady(Collections.emptyMap());
    }

    @Test
    public void shouldExhaustRetriesOnTimeoutExceptionForMakeReady() {
        this.mockAdminClient.timeoutNextRequest(1);
        RepartitionTopicConfig internalTopicConfig = new RepartitionTopicConfig("test_topic", Collections.emptyMap());
        internalTopicConfig.setNumberOfPartitions(1);
        try {
            this.internalTopicManager.makeReady(Collections.singletonMap("test_topic", internalTopicConfig));
            Assert.fail((String)"Should have thrown StreamsException.");
        }
        catch (StreamsException expected) {
            Assert.assertEquals(TimeoutException.class, expected.getCause().getClass());
        }
    }

    @Test
    public void shouldLogWhenTopicNotFoundAndNotThrowException() {
        LogCaptureAppender.setClassLoggerToDebug(InternalTopicManager.class);
        LogCaptureAppender appender = LogCaptureAppender.createAndRegister();
        this.mockAdminClient.addTopic(false, "test_topic", Collections.singletonList(new TopicPartitionInfo(0, this.broker1, this.cluster, Collections.emptyList())), null);
        RepartitionTopicConfig internalTopicConfig = new RepartitionTopicConfig("test_topic", Collections.emptyMap());
        internalTopicConfig.setNumberOfPartitions(1);
        RepartitionTopicConfig internalTopicConfigII = new RepartitionTopicConfig("internal-topic", Collections.emptyMap());
        internalTopicConfigII.setNumberOfPartitions(1);
        HashMap<String, RepartitionTopicConfig> topicConfigMap = new HashMap<String, RepartitionTopicConfig>();
        topicConfigMap.put("test_topic", internalTopicConfig);
        topicConfigMap.put("internal-topic", internalTopicConfigII);
        this.internalTopicManager.makeReady(topicConfigMap);
        boolean foundExpectedMessage = false;
        for (String message : appender.getMessages()) {
            foundExpectedMessage |= message.contains("Topic internal-topic is unknown or not found, hence not existed yet.");
        }
        Assert.assertTrue((boolean)foundExpectedMessage);
    }

    @Test
    public void shouldExhaustRetriesOnMarkedForDeletionTopic() {
        this.mockAdminClient.addTopic(false, "test_topic", Collections.singletonList(new TopicPartitionInfo(0, this.broker1, this.cluster, Collections.emptyList())), null);
        this.mockAdminClient.markTopicForDeletion("test_topic");
        RepartitionTopicConfig internalTopicConfig = new RepartitionTopicConfig("test_topic", Collections.emptyMap());
        internalTopicConfig.setNumberOfPartitions(1);
        try {
            this.internalTopicManager.makeReady(Collections.singletonMap("test_topic", internalTopicConfig));
            Assert.fail((String)"Should have thrown StreamsException.");
        }
        catch (StreamsException expected) {
            Assert.assertNull((Object)expected.getCause());
            Assert.assertTrue((boolean)expected.getMessage().startsWith("Could not create topics after 1 retries"));
        }
    }
}

