/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.lang.reflect.Field;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.Topology;
import org.apache.kafka.streams.errors.TopologyException;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.TimestampExtractor;
import org.apache.kafka.streams.processor.TopicNameExtractor;
import org.apache.kafka.streams.processor.internals.InternalTopicConfig;
import org.apache.kafka.streams.processor.internals.InternalTopologyBuilder;
import org.apache.kafka.streams.processor.internals.ProcessorNode;
import org.apache.kafka.streams.processor.internals.ProcessorStateManager;
import org.apache.kafka.streams.processor.internals.ProcessorTopology;
import org.apache.kafka.streams.processor.internals.RepartitionTopicConfig;
import org.apache.kafka.streams.processor.internals.UnwindowedChangelogTopicConfig;
import org.apache.kafka.streams.processor.internals.WindowedChangelogTopicConfig;
import org.apache.kafka.streams.state.SessionBytesStoreSupplier;
import org.apache.kafka.streams.state.StoreBuilder;
import org.apache.kafka.streams.state.Stores;
import org.apache.kafka.streams.state.WindowBytesStoreSupplier;
import org.apache.kafka.test.MockKeyValueStoreBuilder;
import org.apache.kafka.test.MockProcessorSupplier;
import org.apache.kafka.test.MockTimestampExtractor;
import org.apache.kafka.test.StreamsTestUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Assert;
import org.junit.Test;

public class InternalTopologyBuilderTest {
    private final Serde<String> stringSerde = Serdes.String();
    private final InternalTopologyBuilder builder = new InternalTopologyBuilder();
    private final StoreBuilder storeBuilder = new MockKeyValueStoreBuilder("store", false);

    @Test
    public void shouldAddSourceWithOffsetReset() {
        String earliestTopic = "earliestTopic";
        String latestTopic = "latestTopic";
        this.builder.addSource(Topology.AutoOffsetReset.EARLIEST, "source", null, null, null, new String[]{"earliestTopic"});
        this.builder.addSource(Topology.AutoOffsetReset.LATEST, "source2", null, null, null, new String[]{"latestTopic"});
        Assert.assertTrue((boolean)this.builder.earliestResetTopicsPattern().matcher("earliestTopic").matches());
        Assert.assertTrue((boolean)this.builder.latestResetTopicsPattern().matcher("latestTopic").matches());
    }

    @Test
    public void shouldAddSourcePatternWithOffsetReset() {
        String earliestTopicPattern = "earliest.*Topic";
        String latestTopicPattern = "latest.*Topic";
        this.builder.addSource(Topology.AutoOffsetReset.EARLIEST, "source", null, null, null, Pattern.compile("earliest.*Topic"));
        this.builder.addSource(Topology.AutoOffsetReset.LATEST, "source2", null, null, null, Pattern.compile("latest.*Topic"));
        Assert.assertTrue((boolean)this.builder.earliestResetTopicsPattern().matcher("earliestTestTopic").matches());
        Assert.assertTrue((boolean)this.builder.latestResetTopicsPattern().matcher("latestTestTopic").matches());
    }

    @Test
    public void shouldAddSourceWithoutOffsetReset() {
        Pattern expectedPattern = Pattern.compile("test-topic");
        this.builder.addSource(null, "source", null, this.stringSerde.deserializer(), this.stringSerde.deserializer(), new String[]{"test-topic"});
        Assert.assertEquals((Object)expectedPattern.pattern(), (Object)this.builder.sourceTopicPattern().pattern());
        Assert.assertEquals((Object)this.builder.earliestResetTopicsPattern().pattern(), (Object)"");
        Assert.assertEquals((Object)this.builder.latestResetTopicsPattern().pattern(), (Object)"");
    }

    @Test
    public void shouldAddPatternSourceWithoutOffsetReset() {
        Pattern expectedPattern = Pattern.compile("test-.*");
        this.builder.addSource(null, "source", null, this.stringSerde.deserializer(), this.stringSerde.deserializer(), Pattern.compile("test-.*"));
        Assert.assertEquals((Object)expectedPattern.pattern(), (Object)this.builder.sourceTopicPattern().pattern());
        Assert.assertEquals((Object)this.builder.earliestResetTopicsPattern().pattern(), (Object)"");
        Assert.assertEquals((Object)this.builder.latestResetTopicsPattern().pattern(), (Object)"");
    }

    @Test(expected=TopologyException.class)
    public void shouldNotAllowOffsetResetSourceWithoutTopics() {
        this.builder.addSource(Topology.AutoOffsetReset.EARLIEST, "source", null, this.stringSerde.deserializer(), this.stringSerde.deserializer(), new String[0]);
    }

    @Test
    public void shouldNotAllowOffsetResetSourceWithDuplicateSourceName() {
        this.builder.addSource(Topology.AutoOffsetReset.EARLIEST, "source", null, this.stringSerde.deserializer(), this.stringSerde.deserializer(), new String[]{"topic-1"});
        try {
            this.builder.addSource(Topology.AutoOffsetReset.LATEST, "source", null, this.stringSerde.deserializer(), this.stringSerde.deserializer(), new String[]{"topic-2"});
            Assert.fail((String)"Should throw TopologyException for duplicate source name");
        }
        catch (TopologyException topologyException) {
            // empty catch block
        }
    }

    @Test
    public void testAddSourceWithSameName() {
        this.builder.addSource(null, "source", null, null, null, new String[]{"topic-1"});
        try {
            this.builder.addSource(null, "source", null, null, null, new String[]{"topic-2"});
            Assert.fail((String)"Should throw TopologyException with source name conflict");
        }
        catch (TopologyException topologyException) {
            // empty catch block
        }
    }

    @Test
    public void testAddSourceWithSameTopic() {
        this.builder.addSource(null, "source", null, null, null, new String[]{"topic-1"});
        try {
            this.builder.addSource(null, "source-2", null, null, null, new String[]{"topic-1"});
            Assert.fail((String)"Should throw TopologyException with topic conflict");
        }
        catch (TopologyException topologyException) {
            // empty catch block
        }
    }

    @Test
    public void testAddProcessorWithSameName() {
        this.builder.addSource(null, "source", null, null, null, new String[]{"topic-1"});
        this.builder.addProcessor("processor", new MockProcessorSupplier(), new String[]{"source"});
        try {
            this.builder.addProcessor("processor", new MockProcessorSupplier(), new String[]{"source"});
            Assert.fail((String)"Should throw TopologyException with processor name conflict");
        }
        catch (TopologyException topologyException) {
            // empty catch block
        }
    }

    @Test(expected=TopologyException.class)
    public void testAddProcessorWithWrongParent() {
        this.builder.addProcessor("processor", new MockProcessorSupplier(), new String[]{"source"});
    }

    @Test(expected=TopologyException.class)
    public void testAddProcessorWithSelfParent() {
        this.builder.addProcessor("processor", new MockProcessorSupplier(), new String[]{"processor"});
    }

    @Test(expected=TopologyException.class)
    public void testAddProcessorWithEmptyParents() {
        this.builder.addProcessor("processor", new MockProcessorSupplier(), new String[0]);
    }

    @Test(expected=NullPointerException.class)
    public void testAddProcessorWithNullParents() {
        this.builder.addProcessor("processor", new MockProcessorSupplier(), new String[]{null});
    }

    @Test
    public void testAddSinkWithSameName() {
        this.builder.addSource(null, "source", null, null, null, new String[]{"topic-1"});
        this.builder.addSink("sink", "topic-2", null, null, null, new String[]{"source"});
        try {
            this.builder.addSink("sink", "topic-3", null, null, null, new String[]{"source"});
            Assert.fail((String)"Should throw TopologyException with sink name conflict");
        }
        catch (TopologyException topologyException) {
            // empty catch block
        }
    }

    @Test(expected=TopologyException.class)
    public void testAddSinkWithWrongParent() {
        this.builder.addSink("sink", "topic-2", null, null, null, new String[]{"source"});
    }

    @Test(expected=TopologyException.class)
    public void testAddSinkWithSelfParent() {
        this.builder.addSink("sink", "topic-2", null, null, null, new String[]{"sink"});
    }

    @Test(expected=TopologyException.class)
    public void testAddSinkWithEmptyParents() {
        this.builder.addSink("sink", "topic", null, null, null, new String[0]);
    }

    @Test(expected=NullPointerException.class)
    public void testAddSinkWithNullParents() {
        this.builder.addSink("sink", "topic", null, null, null, new String[]{null});
    }

    @Test
    public void testAddSinkConnectedWithParent() {
        this.builder.addSource(null, "source", null, null, null, new String[]{"source-topic"});
        this.builder.addSink("sink", "dest-topic", null, null, null, new String[]{"source"});
        Map nodeGroups = this.builder.nodeGroups();
        Set nodeGroup = (Set)nodeGroups.get(0);
        Assert.assertTrue((boolean)nodeGroup.contains("sink"));
        Assert.assertTrue((boolean)nodeGroup.contains("source"));
    }

    @Test
    public void testAddSinkConnectedWithMultipleParent() {
        this.builder.addSource(null, "source", null, null, null, new String[]{"source-topic"});
        this.builder.addSource(null, "sourceII", null, null, null, new String[]{"source-topicII"});
        this.builder.addSink("sink", "dest-topic", null, null, null, new String[]{"source", "sourceII"});
        Map nodeGroups = this.builder.nodeGroups();
        Set nodeGroup = (Set)nodeGroups.get(0);
        Assert.assertTrue((boolean)nodeGroup.contains("sink"));
        Assert.assertTrue((boolean)nodeGroup.contains("source"));
        Assert.assertTrue((boolean)nodeGroup.contains("sourceII"));
    }

    @Test
    public void testSourceTopics() {
        this.builder.setApplicationId("X");
        this.builder.addSource(null, "source-1", null, null, null, new String[]{"topic-1"});
        this.builder.addSource(null, "source-2", null, null, null, new String[]{"topic-2"});
        this.builder.addSource(null, "source-3", null, null, null, new String[]{"topic-3"});
        this.builder.addInternalTopic("topic-3");
        Pattern expectedPattern = Pattern.compile("X-topic-3|topic-1|topic-2");
        Assert.assertEquals((Object)expectedPattern.pattern(), (Object)this.builder.sourceTopicPattern().pattern());
    }

    @Test
    public void testSourceTopicsWithGlobalTopics() {
        this.builder.setApplicationId("X");
        this.builder.addSource(null, "source-1", null, null, null, new String[]{"topic-1"});
        this.builder.addSource(null, "source-2", null, null, null, new String[]{"topic-2"});
        this.builder.addGlobalStore(new MockKeyValueStoreBuilder("global-store", false).withLoggingDisabled(), "globalSource", null, null, null, "globalTopic", "global-processor", new MockProcessorSupplier());
        Pattern expectedPattern = Pattern.compile("topic-1|topic-2");
        MatcherAssert.assertThat((Object)this.builder.sourceTopicPattern().pattern(), (Matcher)CoreMatchers.equalTo((Object)expectedPattern.pattern()));
    }

    @Test
    public void testPatternSourceTopic() {
        Pattern expectedPattern = Pattern.compile("topic-\\d");
        this.builder.addSource(null, "source-1", null, null, null, expectedPattern);
        Assert.assertEquals((Object)expectedPattern.pattern(), (Object)this.builder.sourceTopicPattern().pattern());
    }

    @Test
    public void testAddMoreThanOnePatternSourceNode() {
        Pattern expectedPattern = Pattern.compile("topics[A-Z]|.*-\\d");
        this.builder.addSource(null, "source-1", null, null, null, Pattern.compile("topics[A-Z]"));
        this.builder.addSource(null, "source-2", null, null, null, Pattern.compile(".*-\\d"));
        Assert.assertEquals((Object)expectedPattern.pattern(), (Object)this.builder.sourceTopicPattern().pattern());
    }

    @Test
    public void testSubscribeTopicNameAndPattern() {
        Pattern expectedPattern = Pattern.compile("topic-bar|topic-foo|.*-\\d");
        this.builder.addSource(null, "source-1", null, null, null, new String[]{"topic-foo", "topic-bar"});
        this.builder.addSource(null, "source-2", null, null, null, Pattern.compile(".*-\\d"));
        Assert.assertEquals((Object)expectedPattern.pattern(), (Object)this.builder.sourceTopicPattern().pattern());
    }

    @Test
    public void testPatternMatchesAlreadyProvidedTopicSource() {
        this.builder.addSource(null, "source-1", null, null, null, new String[]{"foo"});
        try {
            this.builder.addSource(null, "source-2", null, null, null, Pattern.compile("f.*"));
            Assert.fail((String)"Should throw TopologyException with topic name/pattern conflict");
        }
        catch (TopologyException topologyException) {
            // empty catch block
        }
    }

    @Test
    public void testNamedTopicMatchesAlreadyProvidedPattern() {
        this.builder.addSource(null, "source-1", null, null, null, Pattern.compile("f.*"));
        try {
            this.builder.addSource(null, "source-2", null, null, null, new String[]{"foo"});
            Assert.fail((String)"Should throw TopologyException with topic name/pattern conflict");
        }
        catch (TopologyException topologyException) {
            // empty catch block
        }
    }

    @Test(expected=TopologyException.class)
    public void testAddStateStoreWithNonExistingProcessor() {
        this.builder.addStateStore(this.storeBuilder, new String[]{"no-such-processor"});
    }

    @Test
    public void testAddStateStoreWithSource() {
        this.builder.addSource(null, "source-1", null, null, null, new String[]{"topic-1"});
        try {
            this.builder.addStateStore(this.storeBuilder, new String[]{"source-1"});
            Assert.fail((String)"Should throw TopologyException with store cannot be added to source");
        }
        catch (TopologyException topologyException) {
            // empty catch block
        }
    }

    @Test
    public void testAddStateStoreWithSink() {
        this.builder.addSource(null, "source-1", null, null, null, new String[]{"topic-1"});
        this.builder.addSink("sink-1", "topic-1", null, null, null, new String[]{"source-1"});
        try {
            this.builder.addStateStore(this.storeBuilder, new String[]{"sink-1"});
            Assert.fail((String)"Should throw TopologyException with store cannot be added to sink");
        }
        catch (TopologyException topologyException) {
            // empty catch block
        }
    }

    @Test
    public void testAddStateStoreWithDuplicates() {
        this.builder.addStateStore(this.storeBuilder, new String[0]);
        try {
            this.builder.addStateStore(this.storeBuilder, new String[0]);
            Assert.fail((String)"Should throw TopologyException with store name conflict");
        }
        catch (TopologyException topologyException) {
            // empty catch block
        }
    }

    @Test
    public void testAddStateStore() {
        this.builder.addStateStore(this.storeBuilder, new String[0]);
        this.builder.setApplicationId("X");
        this.builder.addSource(null, "source-1", null, null, null, new String[]{"topic-1"});
        this.builder.addProcessor("processor-1", new MockProcessorSupplier(), new String[]{"source-1"});
        Assert.assertEquals((long)0L, (long)this.builder.build(null).stateStores().size());
        this.builder.connectProcessorAndStateStores("processor-1", new String[]{this.storeBuilder.name()});
        List suppliers = this.builder.build(null).stateStores();
        Assert.assertEquals((long)1L, (long)suppliers.size());
        Assert.assertEquals((Object)this.storeBuilder.name(), (Object)((StateStore)suppliers.get(0)).name());
    }

    @Test
    public void testTopicGroups() {
        this.builder.setApplicationId("X");
        this.builder.addInternalTopic("topic-1x");
        this.builder.addSource(null, "source-1", null, null, null, new String[]{"topic-1", "topic-1x"});
        this.builder.addSource(null, "source-2", null, null, null, new String[]{"topic-2"});
        this.builder.addSource(null, "source-3", null, null, null, new String[]{"topic-3"});
        this.builder.addSource(null, "source-4", null, null, null, new String[]{"topic-4"});
        this.builder.addSource(null, "source-5", null, null, null, new String[]{"topic-5"});
        this.builder.addProcessor("processor-1", new MockProcessorSupplier(), new String[]{"source-1"});
        this.builder.addProcessor("processor-2", new MockProcessorSupplier(), new String[]{"source-2", "processor-1"});
        this.builder.copartitionSources(Arrays.asList("source-1", "source-2"));
        this.builder.addProcessor("processor-3", new MockProcessorSupplier(), new String[]{"source-3", "source-4"});
        Map topicGroups = this.builder.topicGroups();
        HashMap<Integer, InternalTopologyBuilder.TopicsInfo> expectedTopicGroups = new HashMap<Integer, InternalTopologyBuilder.TopicsInfo>();
        expectedTopicGroups.put(0, new InternalTopologyBuilder.TopicsInfo(Collections.emptySet(), Utils.mkSet((Object[])new String[]{"topic-1", "X-topic-1x", "topic-2"}), Collections.emptyMap(), Collections.emptyMap()));
        expectedTopicGroups.put(1, new InternalTopologyBuilder.TopicsInfo(Collections.emptySet(), Utils.mkSet((Object[])new String[]{"topic-3", "topic-4"}), Collections.emptyMap(), Collections.emptyMap()));
        expectedTopicGroups.put(2, new InternalTopologyBuilder.TopicsInfo(Collections.emptySet(), Utils.mkSet((Object[])new String[]{"topic-5"}), Collections.emptyMap(), Collections.emptyMap()));
        Assert.assertEquals((long)3L, (long)topicGroups.size());
        Assert.assertEquals(expectedTopicGroups, (Object)topicGroups);
        Collection copartitionGroups = this.builder.copartitionGroups();
        Assert.assertEquals((Object)Utils.mkSet((Object[])new Set[]{Utils.mkSet((Object[])new String[]{"topic-1", "X-topic-1x", "topic-2"})}), new HashSet(copartitionGroups));
    }

    @Test
    public void testTopicGroupsByStateStore() {
        this.builder.setApplicationId("X");
        this.builder.addSource(null, "source-1", null, null, null, new String[]{"topic-1", "topic-1x"});
        this.builder.addSource(null, "source-2", null, null, null, new String[]{"topic-2"});
        this.builder.addSource(null, "source-3", null, null, null, new String[]{"topic-3"});
        this.builder.addSource(null, "source-4", null, null, null, new String[]{"topic-4"});
        this.builder.addSource(null, "source-5", null, null, null, new String[]{"topic-5"});
        this.builder.addProcessor("processor-1", new MockProcessorSupplier(), new String[]{"source-1"});
        this.builder.addProcessor("processor-2", new MockProcessorSupplier(), new String[]{"source-2"});
        this.builder.addStateStore((StoreBuilder)new MockKeyValueStoreBuilder("store-1", false), new String[]{"processor-1", "processor-2"});
        this.builder.addProcessor("processor-3", new MockProcessorSupplier(), new String[]{"source-3"});
        this.builder.addProcessor("processor-4", new MockProcessorSupplier(), new String[]{"source-4"});
        this.builder.addStateStore((StoreBuilder)new MockKeyValueStoreBuilder("store-2", false), new String[]{"processor-3", "processor-4"});
        this.builder.addProcessor("processor-5", new MockProcessorSupplier(), new String[]{"source-5"});
        this.builder.addStateStore((StoreBuilder)new MockKeyValueStoreBuilder("store-3", false), new String[0]);
        this.builder.connectProcessorAndStateStores("processor-5", new String[]{"store-3"});
        Map topicGroups = this.builder.topicGroups();
        HashMap<Integer, InternalTopologyBuilder.TopicsInfo> expectedTopicGroups = new HashMap<Integer, InternalTopologyBuilder.TopicsInfo>();
        String store1 = ProcessorStateManager.storeChangelogTopic((String)"X", (String)"store-1");
        String store2 = ProcessorStateManager.storeChangelogTopic((String)"X", (String)"store-2");
        String store3 = ProcessorStateManager.storeChangelogTopic((String)"X", (String)"store-3");
        expectedTopicGroups.put(0, new InternalTopologyBuilder.TopicsInfo(Collections.emptySet(), Utils.mkSet((Object[])new String[]{"topic-1", "topic-1x", "topic-2"}), Collections.emptyMap(), Collections.singletonMap(store1, new UnwindowedChangelogTopicConfig(store1, Collections.emptyMap()))));
        expectedTopicGroups.put(1, new InternalTopologyBuilder.TopicsInfo(Collections.emptySet(), Utils.mkSet((Object[])new String[]{"topic-3", "topic-4"}), Collections.emptyMap(), Collections.singletonMap(store2, new UnwindowedChangelogTopicConfig(store2, Collections.emptyMap()))));
        expectedTopicGroups.put(2, new InternalTopologyBuilder.TopicsInfo(Collections.emptySet(), Utils.mkSet((Object[])new String[]{"topic-5"}), Collections.emptyMap(), Collections.singletonMap(store3, new UnwindowedChangelogTopicConfig(store3, Collections.emptyMap()))));
        Assert.assertEquals((long)3L, (long)topicGroups.size());
        Assert.assertEquals(expectedTopicGroups, (Object)topicGroups);
    }

    @Test
    public void testBuild() {
        this.builder.addSource(null, "source-1", null, null, null, new String[]{"topic-1", "topic-1x"});
        this.builder.addSource(null, "source-2", null, null, null, new String[]{"topic-2"});
        this.builder.addSource(null, "source-3", null, null, null, new String[]{"topic-3"});
        this.builder.addSource(null, "source-4", null, null, null, new String[]{"topic-4"});
        this.builder.addSource(null, "source-5", null, null, null, new String[]{"topic-5"});
        this.builder.addProcessor("processor-1", new MockProcessorSupplier(), new String[]{"source-1"});
        this.builder.addProcessor("processor-2", new MockProcessorSupplier(), new String[]{"source-2", "processor-1"});
        this.builder.addProcessor("processor-3", new MockProcessorSupplier(), new String[]{"source-3", "source-4"});
        this.builder.setApplicationId("X");
        ProcessorTopology topology0 = this.builder.build(Integer.valueOf(0));
        ProcessorTopology topology1 = this.builder.build(Integer.valueOf(1));
        ProcessorTopology topology2 = this.builder.build(Integer.valueOf(2));
        Assert.assertEquals((Object)Utils.mkSet((Object[])new String[]{"source-1", "source-2", "processor-1", "processor-2"}), this.nodeNames(topology0.processors()));
        Assert.assertEquals((Object)Utils.mkSet((Object[])new String[]{"source-3", "source-4", "processor-3"}), this.nodeNames(topology1.processors()));
        Assert.assertEquals((Object)Utils.mkSet((Object[])new String[]{"source-5"}), this.nodeNames(topology2.processors()));
    }

    @Test
    public void shouldAllowIncrementalBuilds() {
        Map oldNodeGroups = this.builder.nodeGroups();
        this.builder.addSource(null, "source-1", null, null, null, new String[]{"topic-1"});
        this.builder.addSource(null, "source-2", null, null, null, new String[]{"topic-2"});
        Map newNodeGroups = this.builder.nodeGroups();
        Assert.assertNotEquals((Object)oldNodeGroups, (Object)newNodeGroups);
        oldNodeGroups = newNodeGroups;
        this.builder.addSource(null, "source-3", null, null, null, Pattern.compile(""));
        this.builder.addSource(null, "source-4", null, null, null, Pattern.compile(""));
        newNodeGroups = this.builder.nodeGroups();
        Assert.assertNotEquals((Object)oldNodeGroups, (Object)newNodeGroups);
        oldNodeGroups = newNodeGroups;
        this.builder.addProcessor("processor-1", new MockProcessorSupplier(), new String[]{"source-1"});
        this.builder.addProcessor("processor-2", new MockProcessorSupplier(), new String[]{"source-2"});
        this.builder.addProcessor("processor-3", new MockProcessorSupplier(), new String[]{"source-3"});
        newNodeGroups = this.builder.nodeGroups();
        Assert.assertNotEquals((Object)oldNodeGroups, (Object)newNodeGroups);
        oldNodeGroups = newNodeGroups;
        this.builder.addSink("sink-1", "sink-topic", null, null, null, new String[]{"processor-1"});
        newNodeGroups = this.builder.nodeGroups();
        Assert.assertNotEquals((Object)oldNodeGroups, (Object)newNodeGroups);
        oldNodeGroups = newNodeGroups;
        this.builder.addSink("sink-2", (k, v, ctx) -> "sink-topic", null, null, null, new String[]{"processor-2"});
        newNodeGroups = this.builder.nodeGroups();
        Assert.assertNotEquals((Object)oldNodeGroups, (Object)newNodeGroups);
        oldNodeGroups = newNodeGroups;
        this.builder.addStateStore((StoreBuilder)new MockKeyValueStoreBuilder("store-1", false), new String[]{"processor-1", "processor-2"});
        newNodeGroups = this.builder.nodeGroups();
        Assert.assertNotEquals((Object)oldNodeGroups, (Object)newNodeGroups);
        oldNodeGroups = newNodeGroups;
        this.builder.addStateStore((StoreBuilder)new MockKeyValueStoreBuilder("store-2", false), new String[0]);
        this.builder.connectProcessorAndStateStores("processor-2", new String[]{"store-2"});
        this.builder.connectProcessorAndStateStores("processor-3", new String[]{"store-2"});
        newNodeGroups = this.builder.nodeGroups();
        Assert.assertNotEquals((Object)oldNodeGroups, (Object)newNodeGroups);
        oldNodeGroups = newNodeGroups;
        this.builder.addGlobalStore(new MockKeyValueStoreBuilder("global-store", false).withLoggingDisabled(), "globalSource", null, null, null, "globalTopic", "global-processor", new MockProcessorSupplier());
        newNodeGroups = this.builder.nodeGroups();
        Assert.assertNotEquals((Object)oldNodeGroups, (Object)newNodeGroups);
    }

    @Test(expected=NullPointerException.class)
    public void shouldNotAllowNullNameWhenAddingSink() {
        this.builder.addSink(null, "topic", null, null, null, new String[0]);
    }

    @Test(expected=NullPointerException.class)
    public void shouldNotAllowNullTopicWhenAddingSink() {
        this.builder.addSink("name", (String)null, null, null, null, new String[0]);
    }

    @Test(expected=NullPointerException.class)
    public void shouldNotAllowNullTopicChooserWhenAddingSink() {
        this.builder.addSink("name", (TopicNameExtractor)null, null, null, null, new String[0]);
    }

    @Test(expected=NullPointerException.class)
    public void shouldNotAllowNullNameWhenAddingProcessor() {
        this.builder.addProcessor(null, () -> null, new String[0]);
    }

    @Test(expected=NullPointerException.class)
    public void shouldNotAllowNullProcessorSupplier() {
        this.builder.addProcessor("name", null, new String[0]);
    }

    @Test(expected=NullPointerException.class)
    public void shouldNotAllowNullNameWhenAddingSource() {
        this.builder.addSource(null, null, null, null, null, Pattern.compile(".*"));
    }

    @Test(expected=NullPointerException.class)
    public void shouldNotAllowNullProcessorNameWhenConnectingProcessorAndStateStores() {
        this.builder.connectProcessorAndStateStores(null, new String[]{"store"});
    }

    @Test(expected=NullPointerException.class)
    public void shouldNotAllowNullStateStoreNameWhenConnectingProcessorAndStateStores() {
        this.builder.connectProcessorAndStateStores("processor", new String[]{null});
    }

    @Test(expected=NullPointerException.class)
    public void shouldNotAddNullInternalTopic() {
        this.builder.addInternalTopic(null);
    }

    @Test(expected=NullPointerException.class)
    public void shouldNotSetApplicationIdToNull() {
        this.builder.setApplicationId(null);
    }

    @Test(expected=NullPointerException.class)
    public void shouldNotAddNullStateStoreSupplier() {
        this.builder.addStateStore(null, new String[0]);
    }

    private Set<String> nodeNames(Collection<ProcessorNode> nodes) {
        HashSet<String> nodeNames = new HashSet<String>();
        for (ProcessorNode node : nodes) {
            nodeNames.add(node.name());
        }
        return nodeNames;
    }

    @Test
    public void shouldAssociateStateStoreNameWhenStateStoreSupplierIsInternal() {
        this.builder.addSource(null, "source", null, null, null, new String[]{"topic"});
        this.builder.addProcessor("processor", new MockProcessorSupplier(), new String[]{"source"});
        this.builder.addStateStore(this.storeBuilder, new String[]{"processor"});
        Map stateStoreNameToSourceTopic = this.builder.stateStoreNameToSourceTopics();
        Assert.assertEquals((long)1L, (long)stateStoreNameToSourceTopic.size());
        Assert.assertEquals(Collections.singletonList("topic"), stateStoreNameToSourceTopic.get("store"));
    }

    @Test
    public void shouldAssociateStateStoreNameWhenStateStoreSupplierIsExternal() {
        this.builder.addSource(null, "source", null, null, null, new String[]{"topic"});
        this.builder.addProcessor("processor", new MockProcessorSupplier(), new String[]{"source"});
        this.builder.addStateStore(this.storeBuilder, new String[]{"processor"});
        Map stateStoreNameToSourceTopic = this.builder.stateStoreNameToSourceTopics();
        Assert.assertEquals((long)1L, (long)stateStoreNameToSourceTopic.size());
        Assert.assertEquals(Collections.singletonList("topic"), stateStoreNameToSourceTopic.get("store"));
    }

    @Test
    public void shouldCorrectlyMapStateStoreToInternalTopics() {
        this.builder.setApplicationId("appId");
        this.builder.addInternalTopic("internal-topic");
        this.builder.addSource(null, "source", null, null, null, new String[]{"internal-topic"});
        this.builder.addProcessor("processor", new MockProcessorSupplier(), new String[]{"source"});
        this.builder.addStateStore(this.storeBuilder, new String[]{"processor"});
        Map stateStoreNameToSourceTopic = this.builder.stateStoreNameToSourceTopics();
        Assert.assertEquals((long)1L, (long)stateStoreNameToSourceTopic.size());
        Assert.assertEquals(Collections.singletonList("appId-internal-topic"), stateStoreNameToSourceTopic.get("store"));
    }

    @Test
    public void shouldAddInternalTopicConfigForWindowStores() {
        this.builder.setApplicationId("appId");
        this.builder.addSource(null, "source", null, null, null, new String[]{"topic"});
        this.builder.addProcessor("processor", new MockProcessorSupplier(), new String[]{"source"});
        this.builder.addStateStore(Stores.windowStoreBuilder((WindowBytesStoreSupplier)Stores.persistentWindowStore((String)"store1", (Duration)Duration.ofSeconds(30L), (Duration)Duration.ofSeconds(10L), (boolean)false), (Serde)Serdes.String(), (Serde)Serdes.String()), new String[]{"processor"});
        this.builder.addStateStore(Stores.sessionStoreBuilder((SessionBytesStoreSupplier)Stores.persistentSessionStore((String)"store2", (Duration)Duration.ofSeconds(30L)), (Serde)Serdes.String(), (Serde)Serdes.String()), new String[]{"processor"});
        Map topicGroups = this.builder.topicGroups();
        InternalTopologyBuilder.TopicsInfo topicsInfo = (InternalTopologyBuilder.TopicsInfo)topicGroups.values().iterator().next();
        InternalTopicConfig topicConfig1 = (InternalTopicConfig)topicsInfo.stateChangelogTopics.get("appId-store1-changelog");
        Map properties1 = topicConfig1.getProperties(Collections.emptyMap(), 10000L);
        Assert.assertEquals((long)2L, (long)properties1.size());
        Assert.assertEquals((Object)"compact,delete", properties1.get("cleanup.policy"));
        Assert.assertEquals((Object)"40000", properties1.get("retention.ms"));
        Assert.assertEquals((Object)"appId-store1-changelog", (Object)topicConfig1.name());
        Assert.assertTrue((boolean)(topicConfig1 instanceof WindowedChangelogTopicConfig));
        InternalTopicConfig topicConfig2 = (InternalTopicConfig)topicsInfo.stateChangelogTopics.get("appId-store2-changelog");
        Map properties2 = topicConfig2.getProperties(Collections.emptyMap(), 10000L);
        Assert.assertEquals((long)2L, (long)properties2.size());
        Assert.assertEquals((Object)"compact,delete", properties2.get("cleanup.policy"));
        Assert.assertEquals((Object)"40000", properties2.get("retention.ms"));
        Assert.assertEquals((Object)"appId-store2-changelog", (Object)topicConfig2.name());
        Assert.assertTrue((boolean)(topicConfig2 instanceof WindowedChangelogTopicConfig));
    }

    @Test
    public void shouldAddInternalTopicConfigForNonWindowStores() {
        this.builder.setApplicationId("appId");
        this.builder.addSource(null, "source", null, null, null, new String[]{"topic"});
        this.builder.addProcessor("processor", new MockProcessorSupplier(), new String[]{"source"});
        this.builder.addStateStore(this.storeBuilder, new String[]{"processor"});
        Map topicGroups = this.builder.topicGroups();
        InternalTopologyBuilder.TopicsInfo topicsInfo = (InternalTopologyBuilder.TopicsInfo)topicGroups.values().iterator().next();
        InternalTopicConfig topicConfig = (InternalTopicConfig)topicsInfo.stateChangelogTopics.get("appId-store-changelog");
        Map properties = topicConfig.getProperties(Collections.emptyMap(), 10000L);
        Assert.assertEquals((long)1L, (long)properties.size());
        Assert.assertEquals((Object)"compact", properties.get("cleanup.policy"));
        Assert.assertEquals((Object)"appId-store-changelog", (Object)topicConfig.name());
        Assert.assertTrue((boolean)(topicConfig instanceof UnwindowedChangelogTopicConfig));
    }

    @Test
    public void shouldAddInternalTopicConfigForRepartitionTopics() {
        this.builder.setApplicationId("appId");
        this.builder.addInternalTopic("foo");
        this.builder.addSource(null, "source", null, null, null, new String[]{"foo"});
        InternalTopologyBuilder.TopicsInfo topicsInfo = (InternalTopologyBuilder.TopicsInfo)this.builder.topicGroups().values().iterator().next();
        InternalTopicConfig topicConfig = (InternalTopicConfig)topicsInfo.repartitionSourceTopics.get("appId-foo");
        Map properties = topicConfig.getProperties(Collections.emptyMap(), 10000L);
        Assert.assertEquals((long)3L, (long)properties.size());
        Assert.assertEquals((Object)String.valueOf(-1), properties.get("retention.ms"));
        Assert.assertEquals((Object)"delete", properties.get("cleanup.policy"));
        Assert.assertEquals((Object)"appId-foo", (Object)topicConfig.name());
        Assert.assertTrue((boolean)(topicConfig instanceof RepartitionTopicConfig));
    }

    @Test
    public void shouldSetCorrectSourceNodesWithRegexUpdatedTopics() throws Exception {
        this.builder.addSource(null, "source-1", null, null, null, new String[]{"topic-foo"});
        this.builder.addSource(null, "source-2", null, null, null, Pattern.compile("topic-[A-C]"));
        this.builder.addSource(null, "source-3", null, null, null, Pattern.compile("topic-\\d"));
        InternalTopologyBuilder.SubscriptionUpdates subscriptionUpdates = new InternalTopologyBuilder.SubscriptionUpdates();
        Field updatedTopicsField = subscriptionUpdates.getClass().getDeclaredField("updatedTopicSubscriptions");
        updatedTopicsField.setAccessible(true);
        Set updatedTopics = (Set)updatedTopicsField.get(subscriptionUpdates);
        updatedTopics.add("topic-B");
        updatedTopics.add("topic-3");
        updatedTopics.add("topic-A");
        this.builder.updateSubscriptions(subscriptionUpdates, null);
        this.builder.setApplicationId("test-id");
        Map topicGroups = this.builder.topicGroups();
        Assert.assertTrue((boolean)((InternalTopologyBuilder.TopicsInfo)topicGroups.get((Object)Integer.valueOf((int)0))).sourceTopics.contains("topic-foo"));
        Assert.assertTrue((boolean)((InternalTopologyBuilder.TopicsInfo)topicGroups.get((Object)Integer.valueOf((int)1))).sourceTopics.contains("topic-A"));
        Assert.assertTrue((boolean)((InternalTopologyBuilder.TopicsInfo)topicGroups.get((Object)Integer.valueOf((int)1))).sourceTopics.contains("topic-B"));
        Assert.assertTrue((boolean)((InternalTopologyBuilder.TopicsInfo)topicGroups.get((Object)Integer.valueOf((int)2))).sourceTopics.contains("topic-3"));
    }

    @Test
    public void shouldAddTimestampExtractorPerSource() {
        this.builder.addSource(null, "source", (TimestampExtractor)new MockTimestampExtractor(), null, null, new String[]{"topic"});
        ProcessorTopology processorTopology = this.builder.rewriteTopology(new StreamsConfig((Map)StreamsTestUtils.getStreamsConfig())).build(null);
        MatcherAssert.assertThat((Object)processorTopology.source("topic").getTimestampExtractor(), (Matcher)IsInstanceOf.instanceOf(MockTimestampExtractor.class));
    }

    @Test
    public void shouldAddTimestampExtractorWithPatternPerSource() {
        Pattern pattern = Pattern.compile("t.*");
        this.builder.addSource(null, "source", (TimestampExtractor)new MockTimestampExtractor(), null, null, pattern);
        ProcessorTopology processorTopology = this.builder.rewriteTopology(new StreamsConfig((Map)StreamsTestUtils.getStreamsConfig())).build(null);
        MatcherAssert.assertThat((Object)processorTopology.source(pattern.pattern()).getTimestampExtractor(), (Matcher)IsInstanceOf.instanceOf(MockTimestampExtractor.class));
    }

    @Test
    public void shouldSortProcessorNodesCorrectly() {
        this.builder.addSource(null, "source1", null, null, null, new String[]{"topic1"});
        this.builder.addSource(null, "source2", null, null, null, new String[]{"topic2"});
        this.builder.addProcessor("processor1", new MockProcessorSupplier(), new String[]{"source1"});
        this.builder.addProcessor("processor2", new MockProcessorSupplier(), new String[]{"source1", "source2"});
        this.builder.addProcessor("processor3", new MockProcessorSupplier(), new String[]{"processor2"});
        this.builder.addSink("sink1", "topic2", null, null, null, new String[]{"processor1", "processor3"});
        Assert.assertEquals((long)1L, (long)this.builder.describe().subtopologies().size());
        Iterator iterator = ((InternalTopologyBuilder.Subtopology)this.builder.describe().subtopologies().iterator().next()).nodesInOrder();
        Assert.assertTrue((boolean)iterator.hasNext());
        InternalTopologyBuilder.AbstractNode node = (InternalTopologyBuilder.AbstractNode)iterator.next();
        Assert.assertEquals((Object)"source1", (Object)node.name);
        Assert.assertEquals((long)6L, (long)node.size);
        Assert.assertTrue((boolean)iterator.hasNext());
        node = (InternalTopologyBuilder.AbstractNode)iterator.next();
        Assert.assertEquals((Object)"source2", (Object)node.name);
        Assert.assertEquals((long)4L, (long)node.size);
        Assert.assertTrue((boolean)iterator.hasNext());
        node = (InternalTopologyBuilder.AbstractNode)iterator.next();
        Assert.assertEquals((Object)"processor2", (Object)node.name);
        Assert.assertEquals((long)3L, (long)node.size);
        Assert.assertTrue((boolean)iterator.hasNext());
        node = (InternalTopologyBuilder.AbstractNode)iterator.next();
        Assert.assertEquals((Object)"processor1", (Object)node.name);
        Assert.assertEquals((long)2L, (long)node.size);
        Assert.assertTrue((boolean)iterator.hasNext());
        node = (InternalTopologyBuilder.AbstractNode)iterator.next();
        Assert.assertEquals((Object)"processor3", (Object)node.name);
        Assert.assertEquals((long)2L, (long)node.size);
        Assert.assertTrue((boolean)iterator.hasNext());
        node = (InternalTopologyBuilder.AbstractNode)iterator.next();
        Assert.assertEquals((Object)"sink1", (Object)node.name);
        Assert.assertEquals((long)1L, (long)node.size);
    }

    @Test
    public void shouldConnectRegexMatchedTopicsToStateStore() throws Exception {
        this.builder.addSource(null, "ingest", null, null, null, Pattern.compile("topic-\\d+"));
        this.builder.addProcessor("my-processor", new MockProcessorSupplier(), new String[]{"ingest"});
        this.builder.addStateStore(this.storeBuilder, new String[]{"my-processor"});
        InternalTopologyBuilder.SubscriptionUpdates subscriptionUpdates = new InternalTopologyBuilder.SubscriptionUpdates();
        Field updatedTopicsField = subscriptionUpdates.getClass().getDeclaredField("updatedTopicSubscriptions");
        updatedTopicsField.setAccessible(true);
        Set updatedTopics = (Set)updatedTopicsField.get(subscriptionUpdates);
        updatedTopics.add("topic-2");
        updatedTopics.add("topic-3");
        updatedTopics.add("topic-A");
        this.builder.updateSubscriptions(subscriptionUpdates, "test-thread");
        this.builder.setApplicationId("test-app");
        Map stateStoreAndTopics = this.builder.stateStoreNameToSourceTopics();
        List topics = (List)stateStoreAndTopics.get(this.storeBuilder.name());
        Assert.assertEquals((String)"Expected to contain two topics", (long)2L, (long)topics.size());
        Assert.assertTrue((boolean)topics.contains("topic-2"));
        Assert.assertTrue((boolean)topics.contains("topic-3"));
        Assert.assertFalse((boolean)topics.contains("topic-A"));
    }

    @Test(expected=TopologyException.class)
    public void shouldNotAllowToAddGlobalStoreWithSourceNameEqualsProcessorName() {
        String sameNameForSourceAndProcessor = "sameName";
        this.builder.addGlobalStore(this.storeBuilder, "sameName", null, null, null, "anyTopicName", "sameName", new MockProcessorSupplier());
    }

    @Test
    public void shouldThrowIfNameIsNull() {
        Exception e = (Exception)Assert.assertThrows(NullPointerException.class, () -> new InternalTopologyBuilder.Source(null, Collections.emptySet(), null));
        Assert.assertEquals((Object)"name cannot be null", (Object)e.getMessage());
    }

    @Test
    public void shouldThrowIfTopicAndPatternAreNull() {
        Exception e = (Exception)Assert.assertThrows(IllegalArgumentException.class, () -> new InternalTopologyBuilder.Source("name", null, null));
        Assert.assertEquals((Object)"Either topics or pattern must be not-null, but both are null.", (Object)e.getMessage());
    }

    @Test
    public void shouldThrowIfBothTopicAndPatternAreNotNull() {
        Exception e = (Exception)Assert.assertThrows(IllegalArgumentException.class, () -> new InternalTopologyBuilder.Source("name", Collections.emptySet(), Pattern.compile("")));
        Assert.assertEquals((Object)"Either topics or pattern must be null, but both are not null.", (Object)e.getMessage());
    }

    @Test
    public void sourceShouldBeEqualIfNameAndTopicListAreTheSame() {
        InternalTopologyBuilder.Source base = new InternalTopologyBuilder.Source("name", Collections.singleton("topic"), null);
        InternalTopologyBuilder.Source sameAsBase = new InternalTopologyBuilder.Source("name", Collections.singleton("topic"), null);
        MatcherAssert.assertThat((Object)base, (Matcher)CoreMatchers.equalTo((Object)sameAsBase));
    }

    @Test
    public void sourceShouldBeEqualIfNameAndPatternAreTheSame() {
        InternalTopologyBuilder.Source base = new InternalTopologyBuilder.Source("name", null, Pattern.compile("topic"));
        InternalTopologyBuilder.Source sameAsBase = new InternalTopologyBuilder.Source("name", null, Pattern.compile("topic"));
        MatcherAssert.assertThat((Object)base, (Matcher)CoreMatchers.equalTo((Object)sameAsBase));
    }

    @Test
    public void sourceShouldNotBeEqualForDifferentNamesWithSameTopicList() {
        InternalTopologyBuilder.Source base = new InternalTopologyBuilder.Source("name", Collections.singleton("topic"), null);
        InternalTopologyBuilder.Source differentName = new InternalTopologyBuilder.Source("name2", Collections.singleton("topic"), null);
        MatcherAssert.assertThat((Object)base, (Matcher)Matchers.not((Matcher)CoreMatchers.equalTo((Object)differentName)));
    }

    @Test
    public void sourceShouldNotBeEqualForDifferentNamesWithSamePattern() {
        InternalTopologyBuilder.Source base = new InternalTopologyBuilder.Source("name", null, Pattern.compile("topic"));
        InternalTopologyBuilder.Source differentName = new InternalTopologyBuilder.Source("name2", null, Pattern.compile("topic"));
        MatcherAssert.assertThat((Object)base, (Matcher)Matchers.not((Matcher)CoreMatchers.equalTo((Object)differentName)));
    }

    @Test
    public void sourceShouldNotBeEqualForDifferentTopicList() {
        InternalTopologyBuilder.Source base = new InternalTopologyBuilder.Source("name", Collections.singleton("topic"), null);
        InternalTopologyBuilder.Source differentTopicList = new InternalTopologyBuilder.Source("name", Collections.emptySet(), null);
        InternalTopologyBuilder.Source differentTopic = new InternalTopologyBuilder.Source("name", Collections.singleton("topic2"), null);
        MatcherAssert.assertThat((Object)base, (Matcher)Matchers.not((Matcher)CoreMatchers.equalTo((Object)differentTopicList)));
        MatcherAssert.assertThat((Object)base, (Matcher)Matchers.not((Matcher)CoreMatchers.equalTo((Object)differentTopic)));
    }

    @Test
    public void sourceShouldNotBeEqualForDifferentPattern() {
        InternalTopologyBuilder.Source base = new InternalTopologyBuilder.Source("name", null, Pattern.compile("topic"));
        InternalTopologyBuilder.Source differentPattern = new InternalTopologyBuilder.Source("name", null, Pattern.compile("topic2"));
        InternalTopologyBuilder.Source overlappingPattern = new InternalTopologyBuilder.Source("name", null, Pattern.compile("top*"));
        MatcherAssert.assertThat((Object)base, (Matcher)Matchers.not((Matcher)CoreMatchers.equalTo((Object)differentPattern)));
        MatcherAssert.assertThat((Object)base, (Matcher)Matchers.not((Matcher)CoreMatchers.equalTo((Object)overlappingPattern)));
    }
}

