/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.io.File;
import java.util.HashSet;
import java.util.Map;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.state.internals.TimestampedSegment;
import org.apache.kafka.streams.state.internals.metrics.RocksDBMetricsRecorder;
import org.apache.kafka.test.TestUtils;
import org.easymock.EasyMock;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class TimestampedSegmentTest {
    private final RocksDBMetricsRecorder metricsRecorder = new RocksDBMetricsRecorder("metrics-scope", "thread-id", "store-name");

    @Test
    public void shouldDeleteStateDirectoryOnDestroy() throws Exception {
        TimestampedSegment segment = new TimestampedSegment("segment", "window", 0L, this.metricsRecorder);
        String directoryPath = TestUtils.tempDirectory().getAbsolutePath();
        File directory = new File(directoryPath);
        ProcessorContext mockContext = (ProcessorContext)EasyMock.mock(ProcessorContext.class);
        EasyMock.expect((Object)mockContext.appConfigs()).andReturn((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"metrics.recording.level", (Object)"INFO")}));
        EasyMock.expect((Object)mockContext.stateDir()).andReturn((Object)directory);
        EasyMock.replay((Object[])new Object[]{mockContext});
        segment.openDB(mockContext);
        Assert.assertTrue((boolean)new File(directoryPath, "window").exists());
        Assert.assertTrue((boolean)new File(directoryPath + File.separator + "window", "segment").exists());
        Assert.assertTrue((new File(directoryPath + File.separator + "window", "segment").list().length > 0 ? 1 : 0) != 0);
        segment.destroy();
        Assert.assertFalse((boolean)new File(directoryPath + File.separator + "window", "segment").exists());
        Assert.assertTrue((boolean)new File(directoryPath, "window").exists());
    }

    @Test
    public void shouldBeEqualIfIdIsEqual() {
        TimestampedSegment segment = new TimestampedSegment("anyName", "anyName", 0L, this.metricsRecorder);
        TimestampedSegment segmentSameId = new TimestampedSegment("someOtherName", "someOtherName", 0L, this.metricsRecorder);
        TimestampedSegment segmentDifferentId = new TimestampedSegment("anyName", "anyName", 1L, this.metricsRecorder);
        MatcherAssert.assertThat((Object)segment, (Matcher)Matchers.equalTo((Object)segment));
        MatcherAssert.assertThat((Object)segment, (Matcher)Matchers.equalTo((Object)segmentSameId));
        MatcherAssert.assertThat((Object)segment, (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)segmentDifferentId)));
        MatcherAssert.assertThat((Object)segment, (Matcher)Matchers.not((Matcher)Matchers.equalTo(null)));
        MatcherAssert.assertThat((Object)segment, (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)"anyName")));
    }

    @Test
    public void shouldHashOnSegmentIdOnly() {
        TimestampedSegment segment = new TimestampedSegment("anyName", "anyName", 0L, this.metricsRecorder);
        TimestampedSegment segmentSameId = new TimestampedSegment("someOtherName", "someOtherName", 0L, this.metricsRecorder);
        TimestampedSegment segmentDifferentId = new TimestampedSegment("anyName", "anyName", 1L, this.metricsRecorder);
        HashSet<TimestampedSegment> set = new HashSet<TimestampedSegment>();
        Assert.assertTrue((boolean)set.add(segment));
        Assert.assertFalse((boolean)set.add(segmentSameId));
        Assert.assertTrue((boolean)set.add(segmentDifferentId));
    }

    @Test
    public void shouldCompareSegmentIdOnly() {
        TimestampedSegment segment1 = new TimestampedSegment("a", "C", 50L, this.metricsRecorder);
        TimestampedSegment segment2 = new TimestampedSegment("b", "B", 100L, this.metricsRecorder);
        TimestampedSegment segment3 = new TimestampedSegment("c", "A", 0L, this.metricsRecorder);
        MatcherAssert.assertThat((Object)segment1.compareTo(segment1), (Matcher)Matchers.equalTo((Object)0));
        MatcherAssert.assertThat((Object)segment1.compareTo(segment2), (Matcher)Matchers.equalTo((Object)-1));
        MatcherAssert.assertThat((Object)segment2.compareTo(segment1), (Matcher)Matchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)segment1.compareTo(segment3), (Matcher)Matchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)segment3.compareTo(segment1), (Matcher)Matchers.equalTo((Object)-1));
        MatcherAssert.assertThat((Object)segment2.compareTo(segment3), (Matcher)Matchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)segment3.compareTo(segment2), (Matcher)Matchers.equalTo((Object)-1));
    }
}

