/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals.metrics;

import java.util.Map;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.state.internals.metrics.NamedCacheMetrics;
import org.easymock.EasyMock;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={StreamsMetricsImpl.class, Sensor.class})
public class NamedCacheMetricsTest {
    private static final String THREAD_ID = "test-thread";
    private static final String TASK_ID = "test-task";
    private static final String STORE_NAME = "storeName";
    private static final String HIT_RATIO_AVG_DESCRIPTION = "The average cache hit ratio";
    private static final String HIT_RATIO_MIN_DESCRIPTION = "The minimum cache hit ratio";
    private static final String HIT_RATIO_MAX_DESCRIPTION = "The maximum cache hit ratio";
    private final StreamsMetricsImpl streamsMetrics = (StreamsMetricsImpl)PowerMock.createMock(StreamsMetricsImpl.class);
    private final Sensor expectedSensor = (Sensor)EasyMock.mock(Sensor.class);
    private final Map<String, String> tagMap = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"key", (Object)"value")});

    @Test
    public void shouldGetHitRatioSensorWithBuiltInMetricsVersionCurrent() {
        String hitRatio = "hit-ratio";
        PowerMock.mockStatic(StreamsMetricsImpl.class);
        this.setUpStreamsMetrics(StreamsMetricsImpl.Version.LATEST, "hit-ratio", new Sensor[0]);
        PowerMock.replay((Object[])new Object[]{this.streamsMetrics});
        PowerMock.replay((Object[])new Object[]{StreamsMetricsImpl.class});
        Sensor sensor = NamedCacheMetrics.hitRatioSensor((StreamsMetricsImpl)this.streamsMetrics, (String)THREAD_ID, (String)TASK_ID, (String)STORE_NAME);
        this.verifyResult(sensor);
    }

    @Test
    public void shouldGetHitRatioSensorWithBuiltInMetricsVersionBefore24() {
        Map parentTagMap = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"key", (Object)"all")});
        String hitRatio = "hitRatio";
        Sensor.RecordingLevel recordingLevel = Sensor.RecordingLevel.DEBUG;
        PowerMock.mockStatic(StreamsMetricsImpl.class);
        Sensor parentSensor = (Sensor)EasyMock.mock(Sensor.class);
        EasyMock.expect((Object)this.streamsMetrics.taskLevelSensor(THREAD_ID, TASK_ID, "hitRatio", recordingLevel, new Sensor[0])).andReturn((Object)parentSensor);
        EasyMock.expect((Object)this.streamsMetrics.cacheLevelTagMap(THREAD_ID, TASK_ID, "all")).andReturn((Object)parentTagMap);
        StreamsMetricsImpl.addAvgAndMinAndMaxToSensor((Sensor)parentSensor, (String)"stream-record-cache-metrics", (Map)parentTagMap, (String)"hitRatio", (String)HIT_RATIO_AVG_DESCRIPTION, (String)HIT_RATIO_MIN_DESCRIPTION, (String)HIT_RATIO_MAX_DESCRIPTION);
        this.setUpStreamsMetrics(StreamsMetricsImpl.Version.FROM_100_TO_23, "hitRatio", parentSensor);
        PowerMock.replay((Object[])new Object[]{this.streamsMetrics});
        PowerMock.replay((Object[])new Object[]{StreamsMetricsImpl.class});
        Sensor sensor = NamedCacheMetrics.hitRatioSensor((StreamsMetricsImpl)this.streamsMetrics, (String)THREAD_ID, (String)TASK_ID, (String)STORE_NAME);
        this.verifyResult(sensor);
    }

    private void setUpStreamsMetrics(StreamsMetricsImpl.Version builtInMetricsVersion, String hitRatio, Sensor ... parents) {
        EasyMock.expect((Object)this.streamsMetrics.version()).andReturn((Object)builtInMetricsVersion);
        EasyMock.expect((Object)this.streamsMetrics.cacheLevelSensor(THREAD_ID, TASK_ID, STORE_NAME, hitRatio, Sensor.RecordingLevel.DEBUG, parents)).andReturn((Object)this.expectedSensor);
        EasyMock.expect((Object)this.streamsMetrics.cacheLevelTagMap(THREAD_ID, TASK_ID, STORE_NAME)).andReturn(this.tagMap);
        StreamsMetricsImpl.addAvgAndMinAndMaxToSensor((Sensor)this.expectedSensor, (String)"stream-record-cache-metrics", this.tagMap, (String)hitRatio, (String)HIT_RATIO_AVG_DESCRIPTION, (String)HIT_RATIO_MIN_DESCRIPTION, (String)HIT_RATIO_MAX_DESCRIPTION);
    }

    private void verifyResult(Sensor sensor) {
        PowerMock.verify((Object[])new Object[]{this.streamsMetrics});
        PowerMock.verify((Object[])new Object[]{StreamsMetricsImpl.class});
        MatcherAssert.assertThat((Object)sensor, (Matcher)CoreMatchers.is((Object)this.expectedSensor));
    }
}

