/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.test;

import java.util.Collections;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.kafka.streams.processor.PunctuationType;
import org.apache.kafka.streams.processor.internals.InternalProcessorContext;
import org.apache.kafka.streams.processor.internals.ProcessorNode;
import org.apache.kafka.test.MockProcessor;

public class MockProcessorNode<K, V>
extends ProcessorNode<K, V> {
    private static final String NAME = "MOCK-PROCESS-";
    private static final AtomicInteger INDEX = new AtomicInteger(1);
    public final MockProcessor<K, V> mockProcessor;
    public boolean closed;
    public boolean initialized;

    public MockProcessorNode(long scheduleInterval) {
        this(scheduleInterval, PunctuationType.STREAM_TIME);
    }

    public MockProcessorNode(long scheduleInterval, PunctuationType punctuationType) {
        this(new MockProcessor(punctuationType, scheduleInterval));
    }

    public MockProcessorNode() {
        this(new MockProcessor());
    }

    private MockProcessorNode(MockProcessor<K, V> mockProcessor) {
        super(NAME + INDEX.getAndIncrement(), mockProcessor, Collections.emptySet());
        this.mockProcessor = mockProcessor;
    }

    public void init(InternalProcessorContext context) {
        super.init(context);
        this.initialized = true;
    }

    public void process(K key, V value) {
        this.processor().process(key, value);
    }

    public void close() {
        super.close();
        this.closed = true;
    }
}

