/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.util.Objects;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.streams.kstream.internals.Change;
import org.apache.kafka.streams.kstream.internals.TimestampedCacheFlushListener;
import org.apache.kafka.streams.kstream.internals.TimestampedTupleForwarder;
import org.apache.kafka.streams.processor.AbstractProcessor;
import org.apache.kafka.streams.processor.Processor;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.ProcessorSupplier;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.processor.internals.metrics.ThreadMetrics;
import org.apache.kafka.streams.state.TimestampedKeyValueStore;
import org.apache.kafka.streams.state.ValueAndTimestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KTableSource<K, V>
implements ProcessorSupplier<K, V> {
    private static final Logger LOG = LoggerFactory.getLogger(KTableSource.class);
    private final String storeName;
    private String queryableName;
    private boolean sendOldValues;

    public KTableSource(String storeName, String queryableName) {
        Objects.requireNonNull(storeName, "storeName can't be null");
        this.storeName = storeName;
        this.queryableName = queryableName;
        this.sendOldValues = false;
    }

    public String queryableName() {
        return this.queryableName;
    }

    @Override
    public Processor<K, V> get() {
        return new KTableSourceProcessor();
    }

    public void enableSendingOldValues() {
        this.sendOldValues = true;
        this.queryableName = this.storeName;
    }

    public void materialize() {
        this.queryableName = this.storeName;
    }

    private class KTableSourceProcessor
    extends AbstractProcessor<K, V> {
        private TimestampedKeyValueStore<K, V> store;
        private TimestampedTupleForwarder<K, V> tupleForwarder;
        private StreamsMetricsImpl metrics;
        private Sensor skippedRecordsSensor;

        private KTableSourceProcessor() {
        }

        @Override
        public void init(ProcessorContext context) {
            super.init(context);
            this.metrics = (StreamsMetricsImpl)context.metrics();
            this.skippedRecordsSensor = ThreadMetrics.skipRecordSensor(Thread.currentThread().getName(), this.metrics);
            if (KTableSource.this.queryableName != null) {
                this.store = (TimestampedKeyValueStore)context.getStateStore(KTableSource.this.queryableName);
                this.tupleForwarder = new TimestampedTupleForwarder(this.store, context, new TimestampedCacheFlushListener(context), KTableSource.this.sendOldValues);
            }
        }

        @Override
        public void process(K key, V value) {
            if (key == null) {
                LOG.warn("Skipping record due to null key. topic=[{}] partition=[{}] offset=[{}]", new Object[]{this.context().topic(), this.context().partition(), this.context().offset()});
                this.skippedRecordsSensor.record();
                return;
            }
            if (KTableSource.this.queryableName != null) {
                Object oldValue;
                ValueAndTimestamp oldValueAndTimestamp = (ValueAndTimestamp)this.store.get(key);
                if (oldValueAndTimestamp != null) {
                    oldValue = oldValueAndTimestamp.value();
                    if (this.context().timestamp() < oldValueAndTimestamp.timestamp()) {
                        LOG.warn("Detected out-of-order KTable update for {} at offset {}, partition {}.", new Object[]{this.store.name(), this.context().offset(), this.context().partition()});
                    }
                } else {
                    oldValue = null;
                }
                this.store.put(key, ValueAndTimestamp.make(value, this.context().timestamp()));
                this.tupleForwarder.maybeForward(key, value, oldValue);
            } else {
                this.context().forward(key, new Change<Object>(value, null));
            }
        }
    }
}

