/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Map;
import java.util.Objects;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.errors.ProcessorStateException;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.internals.ProcessorStateManager;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.SessionStore;
import org.apache.kafka.streams.state.StateSerdes;
import org.apache.kafka.streams.state.internals.CacheFlushListener;
import org.apache.kafka.streams.state.internals.CachedStateStore;
import org.apache.kafka.streams.state.internals.MeteredWindowedKeyValueIterator;
import org.apache.kafka.streams.state.internals.SessionKeySchema;
import org.apache.kafka.streams.state.internals.WrappedStateStore;
import org.apache.kafka.streams.state.internals.metrics.Sensors;

public class MeteredSessionStore<K, V>
extends WrappedStateStore<SessionStore<Bytes, byte[]>, Windowed<K>, V>
implements SessionStore<K, V> {
    private final String metricsScope;
    private final Serde<K> keySerde;
    private final Serde<V> valueSerde;
    private final Time time;
    private StateSerdes<K, V> serdes;
    private StreamsMetricsImpl metrics;
    private Sensor putTime;
    private Sensor fetchTime;
    private Sensor flushTime;
    private Sensor removeTime;
    private String taskName;
    private final String threadId = Thread.currentThread().getName();

    MeteredSessionStore(SessionStore<Bytes, byte[]> inner, String metricsScope, Serde<K> keySerde, Serde<V> valueSerde, Time time) {
        super(inner);
        this.metricsScope = metricsScope;
        this.keySerde = keySerde;
        this.valueSerde = valueSerde;
        this.time = time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(ProcessorContext context, StateStore root) {
        this.serdes = new StateSerdes(ProcessorStateManager.storeChangelogTopic(context.applicationId(), this.name()), (Serde<?>)(this.keySerde == null ? context.keySerde() : this.keySerde), (Serde<?>)(this.valueSerde == null ? context.valueSerde() : this.valueSerde));
        this.metrics = (StreamsMetricsImpl)context.metrics();
        this.taskName = context.taskId().toString();
        String metricsGroup = "stream-" + this.metricsScope + "-state-metrics";
        Map<String, String> taskTags = this.metrics.storeLevelTagMap(this.threadId, this.taskName, this.metricsScope, "all");
        Map<String, String> storeTags = this.metrics.storeLevelTagMap(this.threadId, this.taskName, this.metricsScope, this.name());
        this.putTime = Sensors.createTaskAndStoreLatencyAndThroughputSensors(Sensor.RecordingLevel.DEBUG, "put", this.metrics, metricsGroup, this.threadId, this.taskName, this.name(), taskTags, storeTags);
        this.fetchTime = Sensors.createTaskAndStoreLatencyAndThroughputSensors(Sensor.RecordingLevel.DEBUG, "fetch", this.metrics, metricsGroup, this.threadId, this.taskName, this.name(), taskTags, storeTags);
        this.flushTime = Sensors.createTaskAndStoreLatencyAndThroughputSensors(Sensor.RecordingLevel.DEBUG, "flush", this.metrics, metricsGroup, this.threadId, this.taskName, this.name(), taskTags, storeTags);
        this.removeTime = Sensors.createTaskAndStoreLatencyAndThroughputSensors(Sensor.RecordingLevel.DEBUG, "remove", this.metrics, metricsGroup, this.threadId, this.taskName, this.name(), taskTags, storeTags);
        Sensor restoreTime = Sensors.createTaskAndStoreLatencyAndThroughputSensors(Sensor.RecordingLevel.DEBUG, "restore", this.metrics, metricsGroup, this.threadId, this.taskName, this.name(), taskTags, storeTags);
        long startNs = this.time.nanoseconds();
        try {
            super.init(context, root);
        }
        finally {
            this.metrics.recordLatency(restoreTime, startNs, this.time.nanoseconds());
        }
    }

    @Override
    public boolean setFlushListener(CacheFlushListener<Windowed<K>, V> listener, boolean sendOldValues) {
        SessionStore wrapped = (SessionStore)this.wrapped();
        if (wrapped instanceof CachedStateStore) {
            return ((CachedStateStore)((Object)wrapped)).setFlushListener((K key, V newValue, V oldValue, long timestamp) -> listener.apply(SessionKeySchema.from(key, this.serdes.keyDeserializer(), this.serdes.topic()), newValue != null ? (Object)this.serdes.valueFrom((byte[])newValue) : null, oldValue != null ? (Object)this.serdes.valueFrom((byte[])oldValue) : null, timestamp), sendOldValues);
        }
        return false;
    }

    @Override
    public void put(Windowed<K> sessionKey, V aggregate) {
        Objects.requireNonNull(sessionKey, "sessionKey can't be null");
        long startNs = this.time.nanoseconds();
        try {
            Bytes key = this.keyBytes(sessionKey.key());
            ((SessionStore)this.wrapped()).put(new Windowed<Bytes>(key, sessionKey.window()), this.serdes.rawValue(aggregate));
        }
        catch (ProcessorStateException e) {
            String message = String.format(e.getMessage(), sessionKey.key(), aggregate);
            throw new ProcessorStateException(message, (Throwable)((Object)e));
        }
        finally {
            this.metrics.recordLatency(this.putTime, startNs, this.time.nanoseconds());
        }
    }

    @Override
    public void remove(Windowed<K> sessionKey) {
        Objects.requireNonNull(sessionKey, "sessionKey can't be null");
        long startNs = this.time.nanoseconds();
        try {
            Bytes key = this.keyBytes(sessionKey.key());
            ((SessionStore)this.wrapped()).remove(new Windowed<Bytes>(key, sessionKey.window()));
        }
        catch (ProcessorStateException e) {
            String message = String.format(e.getMessage(), sessionKey.key());
            throw new ProcessorStateException(message, (Throwable)((Object)e));
        }
        finally {
            this.metrics.recordLatency(this.removeTime, startNs, this.time.nanoseconds());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V fetchSession(K key, long startTime, long endTime) {
        Objects.requireNonNull(key, "key cannot be null");
        Bytes bytesKey = this.keyBytes(key);
        long startNs = this.time.nanoseconds();
        try {
            byte[] result = (byte[])((SessionStore)this.wrapped()).fetchSession(bytesKey, startTime, endTime);
            if (result == null) {
                V v = null;
                return v;
            }
            V v = this.serdes.valueFrom(result);
            return v;
        }
        finally {
            this.metrics.recordLatency(this.flushTime, startNs, this.time.nanoseconds());
        }
    }

    @Override
    public KeyValueIterator<Windowed<K>, V> fetch(K key) {
        Objects.requireNonNull(key, "key cannot be null");
        return new MeteredWindowedKeyValueIterator<K, V>(((SessionStore)this.wrapped()).fetch(this.keyBytes(key)), this.fetchTime, this.metrics, this.serdes, this.time);
    }

    @Override
    public KeyValueIterator<Windowed<K>, V> fetch(K from, K to) {
        Objects.requireNonNull(from, "from cannot be null");
        Objects.requireNonNull(to, "to cannot be null");
        return new MeteredWindowedKeyValueIterator<K, V>(((SessionStore)this.wrapped()).fetch(this.keyBytes(from), this.keyBytes(to)), this.fetchTime, this.metrics, this.serdes, this.time);
    }

    @Override
    public KeyValueIterator<Windowed<K>, V> findSessions(K key, long earliestSessionEndTime, long latestSessionStartTime) {
        Objects.requireNonNull(key, "key cannot be null");
        Bytes bytesKey = this.keyBytes(key);
        return new MeteredWindowedKeyValueIterator<K, V>(((SessionStore)this.wrapped()).findSessions(bytesKey, earliestSessionEndTime, latestSessionStartTime), this.fetchTime, this.metrics, this.serdes, this.time);
    }

    @Override
    public KeyValueIterator<Windowed<K>, V> findSessions(K keyFrom, K keyTo, long earliestSessionEndTime, long latestSessionStartTime) {
        Objects.requireNonNull(keyFrom, "keyFrom cannot be null");
        Objects.requireNonNull(keyTo, "keyTo cannot be null");
        Bytes bytesKeyFrom = this.keyBytes(keyFrom);
        Bytes bytesKeyTo = this.keyBytes(keyTo);
        return new MeteredWindowedKeyValueIterator<K, V>(((SessionStore)this.wrapped()).findSessions(bytesKeyFrom, bytesKeyTo, earliestSessionEndTime, latestSessionStartTime), this.fetchTime, this.metrics, this.serdes, this.time);
    }

    @Override
    public void flush() {
        long startNs = this.time.nanoseconds();
        try {
            super.flush();
        }
        finally {
            this.metrics.recordLatency(this.flushTime, startNs, this.time.nanoseconds());
        }
    }

    @Override
    public void close() {
        super.close();
        this.metrics.removeAllStoreLevelSensors(this.threadId, this.taskName, this.name());
    }

    private Bytes keyBytes(K key) {
        return Bytes.wrap((byte[])this.serdes.rawKey(key));
    }
}

