/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import org.apache.kafka.streams.kstream.internals.Change;
import org.apache.kafka.streams.kstream.internals.TimestampedCacheFlushListener;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.To;
import org.apache.kafka.streams.state.internals.WrappedStateStore;

class TimestampedTupleForwarder<K, V> {
    private final ProcessorContext context;
    private final boolean sendOldValues;
    private final boolean cachingEnabled;

    TimestampedTupleForwarder(StateStore store, ProcessorContext context, TimestampedCacheFlushListener<K, V> flushListener, boolean sendOldValues) {
        this.context = context;
        this.sendOldValues = sendOldValues;
        this.cachingEnabled = ((WrappedStateStore)store).setFlushListener(flushListener, sendOldValues);
    }

    public void maybeForward(K key, V newValue, V oldValue) {
        if (!this.cachingEnabled) {
            this.context.forward(key, new Change<V>(newValue, this.sendOldValues ? oldValue : null));
        }
    }

    public void maybeForward(K key, V newValue, V oldValue, long timestamp) {
        if (!this.cachingEnabled) {
            this.context.forward(key, new Change<V>(newValue, this.sendOldValues ? oldValue : null), To.all().withTimestamp(timestamp));
        }
    }
}

