/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.common.serialization.LongSerializer;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.streams.kstream.internals.WrappingNullableSerializer;
import org.apache.kafka.streams.kstream.internals.WrappingNullableUtils;
import org.apache.kafka.streams.state.ValueAndTimestamp;

public class ValueAndTimestampSerializer<V>
implements WrappingNullableSerializer<ValueAndTimestamp<V>, Void, V> {
    public final Serializer<V> valueSerializer;
    private final Serializer<Long> timestampSerializer;

    ValueAndTimestampSerializer(Serializer<V> valueSerializer) {
        Objects.requireNonNull(valueSerializer);
        this.valueSerializer = valueSerializer;
        this.timestampSerializer = new LongSerializer();
    }

    private static boolean skipTimestampAndCompareValues(byte[] left, byte[] right) {
        for (int i = 8; i < left.length; ++i) {
            if (left[i] == right[i]) continue;
            return false;
        }
        return true;
    }

    private static boolean timeIsDecreasing(byte[] oldRecord, byte[] newRecord) {
        return ValueAndTimestampSerializer.extractTimestamp(newRecord) <= ValueAndTimestampSerializer.extractTimestamp(oldRecord);
    }

    private static long extractTimestamp(byte[] bytes) {
        byte[] timestampBytes = new byte[8];
        for (int i = 0; i < 8; ++i) {
            timestampBytes[i] = bytes[i];
        }
        return ByteBuffer.wrap(timestampBytes).getLong();
    }

    public static boolean compareValuesAndCheckForIncreasingTimestamp(byte[] oldRecord, byte[] newRecord) {
        if (oldRecord == newRecord) {
            return true;
        }
        if (oldRecord == null || newRecord == null) {
            return false;
        }
        if (newRecord.length != oldRecord.length) {
            return false;
        }
        if (ValueAndTimestampSerializer.timeIsDecreasing(oldRecord, newRecord)) {
            return false;
        }
        return ValueAndTimestampSerializer.skipTimestampAndCompareValues(oldRecord, newRecord);
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
        this.valueSerializer.configure(configs, isKey);
        this.timestampSerializer.configure(configs, isKey);
    }

    public byte[] serialize(String topic, ValueAndTimestamp<V> data) {
        if (data == null) {
            return null;
        }
        return this.serialize(topic, data.value(), data.timestamp());
    }

    public byte[] serialize(String topic, V data, long timestamp) {
        if (data == null) {
            return null;
        }
        byte[] rawValue = this.valueSerializer.serialize(topic, data);
        if (rawValue == null) {
            return null;
        }
        byte[] rawTimestamp = this.timestampSerializer.serialize(topic, (Object)timestamp);
        return ByteBuffer.allocate(rawTimestamp.length + rawValue.length).put(rawTimestamp).put(rawValue).array();
    }

    public void close() {
        this.valueSerializer.close();
        this.timestampSerializer.close();
    }

    @Override
    public void setIfUnset(Serializer<Void> defaultKeySerializer, Serializer<V> defaultValueSerializer) {
        WrappingNullableUtils.initNullableSerializer(this.valueSerializer, defaultKeySerializer, defaultValueSerializer);
    }
}

