/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.NamedOperation;

public class Branched<K, V>
implements NamedOperation<Branched<K, V>> {
    protected final String name;
    protected final Function<? super KStream<K, V>, ? extends KStream<K, V>> chainFunction;
    protected final Consumer<? super KStream<K, V>> chainConsumer;

    protected Branched(String name, Function<? super KStream<K, V>, ? extends KStream<K, V>> chainFunction, Consumer<? super KStream<K, V>> chainConsumer) {
        this.name = name;
        this.chainFunction = chainFunction;
        this.chainConsumer = chainConsumer;
    }

    public static <K, V> Branched<K, V> as(String name) {
        Objects.requireNonNull(name, "name cannot be null");
        return new Branched<K, V>(name, null, null);
    }

    public static <K, V> Branched<K, V> withFunction(Function<? super KStream<K, V>, ? extends KStream<K, V>> chain) {
        Objects.requireNonNull(chain, "chain function cannot be null");
        return new Branched<K, V>(null, chain, null);
    }

    public static <K, V> Branched<K, V> withConsumer(Consumer<KStream<K, V>> chain) {
        Objects.requireNonNull(chain, "chain consumer cannot be null");
        return new Branched<K, V>(null, null, chain);
    }

    public static <K, V> Branched<K, V> withFunction(Function<? super KStream<K, V>, ? extends KStream<K, V>> chain, String name) {
        Objects.requireNonNull(chain, "chain function cannot be null");
        return new Branched<K, V>(name, chain, null);
    }

    public static <K, V> Branched<K, V> withConsumer(Consumer<? super KStream<K, V>> chain, String name) {
        Objects.requireNonNull(chain, "chain consumer cannot be null");
        return new Branched<K, V>(name, null, chain);
    }

    protected Branched(Branched<K, V> branched) {
        this(branched.name, branched.chainFunction, branched.chainConsumer);
    }

    @Override
    public Branched<K, V> withName(String name) {
        return new Branched<K, V>(name, this.chainFunction, this.chainConsumer);
    }
}

