/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.query.internals;

import org.apache.kafka.streams.query.FailureReason;
import org.apache.kafka.streams.query.QueryResult;
import org.apache.kafka.streams.query.internals.AbstractQueryResult;

public final class FailedQueryResult<R>
extends AbstractQueryResult<R>
implements QueryResult<R> {
    private final FailureReason failureReason;
    private final String failure;

    public FailedQueryResult(FailureReason failureReason, String failure) {
        this.failureReason = failureReason;
        this.failure = failure;
    }

    @Override
    public boolean isSuccess() {
        return false;
    }

    @Override
    public boolean isFailure() {
        return true;
    }

    @Override
    public FailureReason getFailureReason() {
        return this.failureReason;
    }

    @Override
    public String getFailureMessage() {
        return this.failure;
    }

    @Override
    public R getResult() {
        throw new IllegalArgumentException("Cannot get result for failed query. Failure is " + this.failureReason.name() + ": " + this.failure);
    }

    public String toString() {
        return "FailedQueryResult{failureReason=" + (Object)((Object)this.failureReason) + ", failure='" + this.failure + '\'' + ", executionInfo=" + this.getExecutionInfo() + ", position=" + this.getPosition() + '}';
    }
}

