/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.main;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Properties;
import org.apache.karaf.main.PropertiesLoader;
import org.apache.karaf.main.lock.SimpleFileLock;
import org.apache.karaf.main.util.Utils;

public class ConfigProperties {
    public static final String PROP_KARAF_HOME = "karaf.home";
    public static final String ENV_KARAF_HOME = "KARAF_HOME";
    public static final String PROP_KARAF_BASE = "karaf.base";
    public static final String ENV_KARAF_BASE = "KARAF_BASE";
    public static final String PROP_KARAF_DATA = "karaf.data";
    public static final String ENV_KARAF_DATA = "KARAF_DATA";
    public static final String PROP_KARAF_INSTANCES = "karaf.instances";
    public static final String ENV_KARAF_INSTANCES = "KARAF_INSTANCES";
    public static final String PROP_KARAF_VERSION = "karaf.version";
    private static final String CONFIG_PROPERTIES_FILE_NAME = "config.properties";
    public static final String SYSTEM_PROPERTIES_FILE_NAME = "system.properties";
    private static final String BUNDLE_LOCATIONS = "bundle.locations";
    private static final String PROPERTY_LOCK_CLASS = "karaf.lock.class";
    private static final String PROPERTY_LOCK_DELAY = "karaf.lock.delay";
    private static final String PROPERTY_LOCK_LEVEL = "karaf.lock.level";
    private static final String DEFAULT_REPO = "karaf.default.repository";
    private static final String KARAF_FRAMEWORK = "karaf.framework";
    private static final String KARAF_FRAMEWORK_FACTORY = "karaf.framework.factory";
    private static final String KARAF_SHUTDOWN_TIMEOUT = "karaf.shutdown.timeout";
    private static final String KARAF_SHUTDOWN_PORT = "karaf.shutdown.port";
    private static final String KARAF_SHUTDOWN_HOST = "karaf.shutdown.host";
    private static final String KARAF_SHUTDOWN_PORT_FILE = "karaf.shutdown.port.file";
    private static final String KARAF_SHUTDOWN_COMMAND = "karaf.shutdown.command";
    private static final String KARAF_SHUTDOWN_PID_FILE = "karaf.shutdown.pid.file";
    private static final String KARAF_STARTUP_MESSAGE = "karaf.startup.message";
    private static final String KARAF_DELAY_CONSOLE = "karaf.delay.console";
    private static final String DEFAULT_SHUTDOWN_COMMAND = "SHUTDOWN";
    private static final String PROPERTY_LOCK_CLASS_DEFAULT = SimpleFileLock.class.getName();
    private static final String SECURITY_PROVIDERS = "org.apache.karaf.security.providers";
    private static final String PROPERTY_USE_LOCK = "karaf.lock";
    File karafHome = Utils.getKarafHome(ConfigProperties.class, "karaf.home", "KARAF_HOME");
    File karafBase = Utils.getKarafDirectory("karaf.base", "KARAF_BASE", this.karafHome, false, true);
    File karafData = Utils.getKarafDirectory("karaf.data", "KARAF_DATA", new File(this.karafBase, "data"), true, true);
    File karafInstances = Utils.getKarafDirectory("karaf.instances", "KARAF_INSTANCES", new File(this.karafHome, "instances"), false, false);
    Properties props;
    String[] securityProviders;
    int defaultStartLevel = 100;
    int lockStartLevel = 1;
    int lockDelay = 1000;
    int shutdownTimeout = 300000;
    boolean useLock;
    String lockClass;
    String frameworkFactoryClass;
    URI frameworkBundle;
    String defaultRepo;
    String bundleLocations;
    int defaultBundleStartlevel;
    String pidFile;
    int shutdownPort;
    String shutdownHost;
    String portFile;
    String shutdownCommand;
    String includes;
    String optionals;
    File etcFolder;
    String startupMessage;
    boolean delayConsoleStart;

    public ConfigProperties() throws Exception {
        Package p = Package.getPackage("org.apache.karaf.main");
        if (p != null && p.getImplementationVersion() != null) {
            System.setProperty(PROP_KARAF_VERSION, p.getImplementationVersion());
        }
        System.setProperty(PROP_KARAF_HOME, this.karafHome.getPath());
        System.setProperty(PROP_KARAF_BASE, this.karafBase.getPath());
        System.setProperty(PROP_KARAF_DATA, this.karafData.getPath());
        System.setProperty(PROP_KARAF_INSTANCES, this.karafInstances.getPath());
        this.etcFolder = new File(this.karafBase, "etc");
        if (!this.etcFolder.exists()) {
            throw new FileNotFoundException("etc folder not found: " + this.etcFolder.getAbsolutePath());
        }
        PropertiesLoader.loadSystemProperties(new File(this.etcFolder, SYSTEM_PROPERTIES_FILE_NAME));
        File cleanAllIndicatorFile = new File(this.karafData, "clean_all");
        File cleanCacheIndicatorFile = new File(this.karafData, "clean_cache");
        if (Boolean.getBoolean("karaf.clean.all") || cleanAllIndicatorFile.exists()) {
            if (cleanAllIndicatorFile.exists()) {
                cleanAllIndicatorFile.delete();
            }
            Utils.deleteDirectory(this.karafData);
            this.karafData = Utils.getKarafDirectory(PROP_KARAF_DATA, ENV_KARAF_DATA, new File(this.karafBase, "data"), true, true);
        } else if (Boolean.getBoolean("karaf.clean.cache") || cleanCacheIndicatorFile.exists()) {
            if (cleanCacheIndicatorFile.exists()) {
                cleanCacheIndicatorFile.delete();
            }
            File karafCache = Utils.getKarafDirectory(PROP_KARAF_DATA, ENV_KARAF_DATA, new File(this.karafData, "cache"), true, true);
            Utils.deleteDirectory(karafCache);
        }
        File file = new File(this.etcFolder, CONFIG_PROPERTIES_FILE_NAME);
        this.props = PropertiesLoader.loadConfigProperties(file);
        String prop = this.props.getProperty(SECURITY_PROVIDERS);
        this.securityProviders = prop != null ? prop.split(",") : new String[]{};
        this.defaultStartLevel = Integer.parseInt(this.props.getProperty("org.osgi.framework.startlevel.beginning"));
        System.setProperty("org.osgi.framework.startlevel.beginning", Integer.toString(this.defaultStartLevel));
        this.lockStartLevel = Integer.parseInt(this.props.getProperty(PROPERTY_LOCK_LEVEL, Integer.toString(this.lockStartLevel)));
        this.lockDelay = Integer.parseInt(this.props.getProperty(PROPERTY_LOCK_DELAY, Integer.toString(this.lockDelay)));
        this.props.setProperty("org.osgi.framework.startlevel.beginning", Integer.toString(this.lockStartLevel));
        this.shutdownTimeout = Integer.parseInt(this.props.getProperty(KARAF_SHUTDOWN_TIMEOUT, Integer.toString(this.shutdownTimeout)));
        this.useLock = Boolean.parseBoolean(this.props.getProperty(PROPERTY_USE_LOCK, "true"));
        this.lockClass = this.props.getProperty(PROPERTY_LOCK_CLASS, PROPERTY_LOCK_CLASS_DEFAULT);
        this.initFrameworkStorage(this.karafData);
        this.frameworkFactoryClass = this.props.getProperty(KARAF_FRAMEWORK_FACTORY);
        this.frameworkBundle = this.getFramework();
        this.defaultRepo = System.getProperty(DEFAULT_REPO, "system");
        this.bundleLocations = this.props.getProperty(BUNDLE_LOCATIONS);
        this.defaultBundleStartlevel = this.getDefaultBundleStartLevel(60);
        this.pidFile = this.props.getProperty(KARAF_SHUTDOWN_PID_FILE);
        this.shutdownPort = Integer.parseInt(this.props.getProperty(KARAF_SHUTDOWN_PORT, "0"));
        this.shutdownHost = this.props.getProperty(KARAF_SHUTDOWN_HOST, "localhost");
        this.portFile = this.props.getProperty(KARAF_SHUTDOWN_PORT_FILE);
        this.shutdownCommand = this.props.getProperty(KARAF_SHUTDOWN_COMMAND, DEFAULT_SHUTDOWN_COMMAND);
        this.startupMessage = this.props.getProperty(KARAF_STARTUP_MESSAGE, "Apache Karaf starting up. Press Enter to open the shell now...");
        this.delayConsoleStart = Boolean.parseBoolean(this.props.getProperty(KARAF_DELAY_CONSOLE, "false"));
        System.setProperty(KARAF_DELAY_CONSOLE, new Boolean(this.delayConsoleStart).toString());
    }

    private String getProperyOrFail(String propertyName) {
        String value = this.props.getProperty(propertyName);
        if (value == null) {
            throw new IllegalArgumentException("Property " + propertyName + " must be set in the etc/" + CONFIG_PROPERTIES_FILE_NAME + " configuration file");
        }
        return value;
    }

    private URI getFramework() throws URISyntaxException {
        String framework = this.getProperyOrFail(KARAF_FRAMEWORK);
        String frameworkBundleUri = this.getProperyOrFail("karaf.framework." + framework);
        return new URI(frameworkBundleUri);
    }

    private void initFrameworkStorage(File karafData) throws Exception {
        String frameworkStoragePath = this.props.getProperty("org.osgi.framework.storage");
        if (frameworkStoragePath == null) {
            File storage = new File(karafData.getPath(), "cache");
            try {
                storage.mkdirs();
            }
            catch (SecurityException se) {
                throw new Exception(se.getMessage());
            }
            this.props.setProperty("org.osgi.framework.storage", storage.getAbsolutePath());
        }
    }

    private int getDefaultBundleStartLevel(int ibsl) {
        try {
            String str = this.props.getProperty("karaf.startlevel.bundle");
            if (str != null) {
                ibsl = Integer.parseInt(str);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return ibsl;
    }
}

