/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.karaf.util.StringEscapeUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Properties
extends AbstractMap<String, String> {
    private static final String COMMENT_CHARS = "#!";
    private static final char[] SEPARATORS = new char[]{'=', ':'};
    private static final char[] WHITE_SPACE = new char[]{' ', '\t', '\f'};
    private static final String DEFAULT_ENCODING = "ISO-8859-1";
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private Map<String, String> storage = new LinkedHashMap<String, String>();
    private Map<String, Layout> layout = new LinkedHashMap<String, Layout>();
    private List<String> header;
    private List<String> footer;
    private File location;
    private static final char ESCAPE_CHAR = '\\';
    private static final String DELIM_START = "${";
    private static final String DELIM_STOP = "}";
    private static final String CHECKSUM_SUFFIX = ".checksum";

    public Properties() {
    }

    public Properties(File location) throws IOException {
        this.location = location;
        if (location.exists()) {
            this.load(location);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(File location) throws IOException {
        FileInputStream is = new FileInputStream(location);
        try {
            this.load(is);
        }
        finally {
            ((InputStream)is).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(URL location) throws IOException {
        InputStream is = location.openStream();
        try {
            this.load(is);
        }
        finally {
            is.close();
        }
    }

    public void load(InputStream is) throws IOException {
        this.load(new InputStreamReader(is, DEFAULT_ENCODING));
    }

    public void load(Reader reader) throws IOException {
        this.loadLayout(reader);
    }

    public void save() throws IOException {
        this.save(this.location);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(File location) throws IOException {
        FileOutputStream os = new FileOutputStream(location);
        try {
            this.save(os);
        }
        finally {
            ((OutputStream)os).close();
        }
    }

    public void save(OutputStream os) throws IOException {
        this.save(new OutputStreamWriter(os, DEFAULT_ENCODING));
    }

    public void save(Writer writer) throws IOException {
        this.saveLayout(writer);
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        return this.storage.entrySet();
    }

    @Override
    public String put(String key, String value) {
        Layout l;
        String old = this.storage.put(key, value);
        if (!(old != null && old.equals(value) || (l = this.layout.get(key)) == null)) {
            l.clearValue();
        }
        return old;
    }

    @Override
    public String remove(Object key) {
        Layout l = this.layout.get(key);
        if (l != null) {
            l.clearValue();
        }
        return this.storage.remove(key);
    }

    @Override
    public void clear() {
        for (Layout l : this.layout.values()) {
            l.clearValue();
        }
        this.storage.clear();
    }

    public List<String> getHeader() {
        return this.header;
    }

    public void setHeader(List<String> header) {
        this.header = header;
    }

    public List<String> getFooter() {
        return this.footer;
    }

    public void setFooter(List<String> footer) {
        this.footer = footer;
    }

    protected void loadLayout(Reader in) throws IOException {
        PropertiesReader reader = new PropertiesReader(in);
        while (reader.nextProperty()) {
            this.storage.put(reader.getPropertyName(), reader.getPropertyValue());
            int idx = this.checkHeaderComment(reader.getCommentLines());
            this.layout.put(reader.getPropertyName(), new Layout((List<String>)(idx < reader.getCommentLines().size() ? new ArrayList<String>(reader.getCommentLines().subList(idx, reader.getCommentLines().size())) : null), new ArrayList<String>(reader.getValueLines())));
        }
        this.footer = new ArrayList<String>(reader.getCommentLines());
        Properties.performSubstitution(this.storage);
    }

    protected void saveLayout(Writer out) throws IOException {
        PropertiesWriter writer = new PropertiesWriter(out);
        if (this.header != null) {
            for (String s : this.header) {
                writer.writeln(s);
            }
        }
        for (String key : this.storage.keySet()) {
            Layout l = this.layout.get(key);
            if (l != null && l.getCommentLines() != null) {
                for (String s : l.getCommentLines()) {
                    writer.writeln(s);
                }
            }
            if (l != null && l.getValueLines() != null) {
                for (String s : l.getValueLines()) {
                    writer.writeln(s);
                }
                continue;
            }
            writer.writeProperty(key, this.storage.get(key));
        }
        if (this.footer != null) {
            for (String s : this.footer) {
                writer.writeln(s);
            }
        }
        writer.flush();
    }

    private int checkHeaderComment(List<String> commentLines) {
        if (this.getHeader() == null && this.layout.isEmpty()) {
            int index;
            for (index = commentLines.size() - 1; index >= 0 && commentLines.get(index).length() > 0; --index) {
            }
            this.setHeader(new ArrayList<String>(commentLines.subList(0, index + 1)));
            return index + 1;
        }
        return 0;
    }

    static boolean isCommentLine(String line) {
        String s = line.trim();
        return s.length() < 1 || COMMENT_CHARS.indexOf(s.charAt(0)) >= 0;
    }

    public static boolean contains(char[] array, char valueToFind) {
        if (array == null) {
            return false;
        }
        for (int i = 0; i < array.length; ++i) {
            if (valueToFind != array[i]) continue;
            return true;
        }
        return false;
    }

    public static void performSubstitution(Map<String, String> properties) {
        for (String name : properties.keySet()) {
            String value = properties.get(name);
            properties.put(name, Properties.substVars(value, name, null, properties));
        }
    }

    public static String substVars(String val, String currentKey, Map<String, String> cycleMap, Map<String, String> configProps) throws IllegalArgumentException {
        String substValue;
        int idx;
        if (cycleMap == null) {
            cycleMap = new HashMap<String, String>();
        }
        cycleMap.put(currentKey, currentKey);
        int stopDelim = val.indexOf(DELIM_STOP);
        while (stopDelim > 0 && val.charAt(stopDelim - 1) == '\\') {
            stopDelim = val.indexOf(DELIM_STOP, stopDelim + 1);
        }
        int startDelim = val.indexOf(DELIM_START);
        while (stopDelim >= 0 && (idx = val.indexOf(DELIM_START, startDelim + DELIM_START.length())) >= 0 && idx <= stopDelim) {
            if (idx >= stopDelim) continue;
            startDelim = idx;
        }
        if (startDelim < 0 || stopDelim < 0) {
            return Properties.unescape(val);
        }
        String variable = val.substring(startDelim + DELIM_START.length(), stopDelim);
        if (cycleMap.get(variable) != null) {
            throw new IllegalArgumentException("recursive variable reference: " + variable);
        }
        String string = substValue = configProps != null ? configProps.get(variable) : null;
        if (substValue == null) {
            substValue = variable.length() > 0 ? System.getProperty(variable, "") : "";
        }
        cycleMap.remove(variable);
        val = val.substring(0, startDelim) + substValue + val.substring(stopDelim + DELIM_STOP.length(), val.length());
        val = Properties.substVars(val, currentKey, cycleMap, configProps);
        val = Properties.unescape(val);
        return val;
    }

    private static String unescape(String val) {
        int escape = val.indexOf(92);
        while (escape >= 0 && escape < val.length() - 1) {
            char c = val.charAt(escape + 1);
            if (c == '{' || c == '}' || c == '\\') {
                val = val.substring(0, escape) + val.substring(escape + 1);
            }
            escape = val.indexOf(92, escape + 1);
        }
        return val;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class Layout {
        private List<String> commentLines;
        private List<String> valueLines;

        public Layout() {
        }

        public Layout(List<String> commentLines, List<String> valueLines) {
            this.commentLines = commentLines;
            this.valueLines = valueLines;
        }

        public List<String> getCommentLines() {
            return this.commentLines;
        }

        public void setCommentLines(List<String> commentLines) {
            this.commentLines = commentLines;
        }

        public List<String> getValueLines() {
            return this.valueLines;
        }

        public void setValueLines(List<String> valueLines) {
            this.valueLines = valueLines;
        }

        public void clearValue() {
            this.valueLines = null;
        }
    }

    public static class PropertiesWriter
    extends FilterWriter {
        public PropertiesWriter(Writer writer) {
            super(writer);
        }

        public void writeProperty(String key, String value) throws IOException {
            this.write(this.escapeKey(key));
            this.write(" = ");
            this.write(StringEscapeUtils.escapeJava(value));
            this.writeln(null);
        }

        private String escapeKey(String key) {
            StringBuffer newkey = new StringBuffer();
            for (int i = 0; i < key.length(); ++i) {
                char c = key.charAt(i);
                if (Properties.contains(SEPARATORS, c) || Properties.contains(WHITE_SPACE, c)) {
                    newkey.append('\\');
                    newkey.append(c);
                    continue;
                }
                newkey.append(c);
            }
            return newkey.toString();
        }

        public void writeln(String s) throws IOException {
            if (s != null) {
                this.write(s);
            }
            this.write(LINE_SEPARATOR);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PropertiesReader
    extends LineNumberReader {
        private List<String> commentLines = new ArrayList<String>();
        private List<String> valueLines = new ArrayList<String>();
        private String propertyName;
        private String propertyValue;

        public PropertiesReader(Reader reader) {
            super(reader);
        }

        public String readProperty() throws IOException {
            String line;
            this.commentLines.clear();
            this.valueLines.clear();
            StringBuffer buffer = new StringBuffer();
            while (true) {
                if ((line = this.readLine()) == null) {
                    return null;
                }
                if (Properties.isCommentLine(line)) {
                    this.commentLines.add(line);
                    continue;
                }
                this.valueLines.add(line);
                line = line.trim();
                if (!PropertiesReader.checkCombineLines(line)) break;
                line = line.substring(0, line.length() - 1);
                buffer.append(line);
            }
            buffer.append(line);
            return buffer.toString();
        }

        public boolean nextProperty() throws IOException {
            String line = this.readProperty();
            if (line == null) {
                return false;
            }
            String[] property = PropertiesReader.parseProperty(line);
            this.propertyName = StringEscapeUtils.unescapeJava(property[0]);
            this.propertyValue = StringEscapeUtils.unescapeJava(property[1]);
            return true;
        }

        public List<String> getCommentLines() {
            return this.commentLines;
        }

        public List<String> getValueLines() {
            return this.valueLines;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public String getPropertyValue() {
            return this.propertyValue;
        }

        private static boolean checkCombineLines(String line) {
            int bsCount = 0;
            for (int idx = line.length() - 1; idx >= 0 && line.charAt(idx) == '\\'; --idx) {
                ++bsCount;
            }
            return bsCount % 2 != 0;
        }

        private static String[] parseProperty(String line) {
            String[] result = new String[2];
            StringBuffer key = new StringBuffer();
            StringBuffer value = new StringBuffer();
            int state = 0;
            block6: for (int pos = 0; pos < line.length(); ++pos) {
                char c = line.charAt(pos);
                switch (state) {
                    case 0: {
                        if (c == '\\') {
                            state = 1;
                            continue block6;
                        }
                        if (Properties.contains(WHITE_SPACE, c)) {
                            state = 2;
                            continue block6;
                        }
                        if (Properties.contains(SEPARATORS, c)) {
                            state = 3;
                            continue block6;
                        }
                        key.append(c);
                        continue block6;
                    }
                    case 1: {
                        if (Properties.contains(SEPARATORS, c) || Properties.contains(WHITE_SPACE, c)) {
                            key.append(c);
                        } else {
                            key.append('\\');
                            key.append(c);
                        }
                        state = 0;
                        continue block6;
                    }
                    case 2: {
                        if (Properties.contains(WHITE_SPACE, c)) {
                            state = 2;
                            continue block6;
                        }
                        if (Properties.contains(SEPARATORS, c)) {
                            state = 3;
                            continue block6;
                        }
                        value.append(c);
                        state = 3;
                        continue block6;
                    }
                    case 3: {
                        value.append(c);
                    }
                }
            }
            result[0] = key.toString().trim();
            result[1] = value.toString().trim();
            return result;
        }
    }
}

