/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.util.properties;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import org.apache.felix.utils.properties.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FileLockUtils {
    private FileLockUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(File file, Runnable callback) throws IOException {
        RandomAccessFile raf = new RandomAccessFile(file, "rw");
        try {
            FileLock lock = raf.getChannel().lock();
            try {
                callback.run(raf);
            }
            finally {
                lock.release();
            }
        }
        finally {
            raf.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T execute(File file, Callable<T> callback) throws IOException {
        RandomAccessFile raf = new RandomAccessFile(file, "rw");
        try {
            T t;
            FileLock lock = raf.getChannel().lock();
            try {
                t = callback.call(raf);
            }
            catch (Throwable throwable) {
                lock.release();
                throw throwable;
            }
            lock.release();
            return t;
        }
        finally {
            raf.close();
        }
    }

    public static void execute(File file, final RunnableWithProperties callback) throws IOException {
        FileLockUtils.execute(file, new Runnable(){

            public void run(RandomAccessFile file) throws IOException {
                byte[] buffer = new byte[(int)file.length()];
                file.readFully(buffer);
                Properties props = new Properties();
                props.load((InputStream)new ByteArrayInputStream(buffer));
                callback.run(props);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                props.store((OutputStream)baos, null);
                file.setLength(0L);
                file.write(baos.toByteArray());
            }
        });
    }

    public static <T> T execute(File file, final CallableWithProperties<T> callback) throws IOException {
        return FileLockUtils.execute(file, new Callable<T>(){

            @Override
            public T call(RandomAccessFile file) throws IOException {
                byte[] buffer = new byte[(int)file.length()];
                file.readFully(buffer);
                Properties props = new Properties();
                props.load((InputStream)new ByteArrayInputStream(buffer));
                Object result = callback.call(props);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                props.store((OutputStream)baos, null);
                file.setLength(0L);
                file.write(baos.toByteArray());
                return result;
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface CallableWithProperties<T> {
        public T call(Properties var1) throws IOException;
    }

    public static interface RunnableWithProperties {
        public void run(Properties var1) throws IOException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Callable<T> {
        public T call(RandomAccessFile var1) throws IOException;
    }

    public static interface Runnable {
        public void run(RandomAccessFile var1) throws IOException;
    }
}

