/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.tooling.features;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import org.apache.karaf.deployer.blueprint.BlueprintTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlueprintURLHandler
extends URLStreamHandler {
    private final Logger logger = LoggerFactory.getLogger(BlueprintURLHandler.class);
    private static String SYNTAX = "blueprint: bp-xml-uri";
    private URL blueprintXmlURL;

    public URLConnection openConnection(URL url) throws IOException {
        if (url.getPath() == null || url.getPath().trim().length() == 0) {
            throw new MalformedURLException("Path cannot be null or empty. Syntax: " + SYNTAX);
        }
        this.blueprintXmlURL = new URL(url.getPath());
        this.logger.debug("Blueprint xml URL is: [" + this.blueprintXmlURL + "]");
        return new Connection(url);
    }

    public URL getBlueprintXmlURL() {
        return this.blueprintXmlURL;
    }

    public class Connection
    extends URLConnection {
        public Connection(URL url) {
            super(url);
        }

        public void connect() throws IOException {
        }

        public InputStream getInputStream() throws IOException {
            try {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                BlueprintTransformer.transform((URL)BlueprintURLHandler.this.blueprintXmlURL, (OutputStream)os);
                os.close();
                return new ByteArrayInputStream(os.toByteArray());
            }
            catch (Exception e) {
                BlueprintURLHandler.this.logger.error("Error opening blueprint xml url", (Throwable)e);
                throw (IOException)new IOException("Error opening blueprint xml url").initCause(e);
            }
        }
    }
}

