/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.tooling.features;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.karaf.tooling.features.GraphArtifactCollector;
import org.apache.karaf.tooling.features.Node;
import org.apache.karaf.tooling.features.ResolutionListenerImpl;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.DefaultArtifactRepository;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.artifact.repository.layout.DefaultRepositoryLayout;
import org.apache.maven.artifact.resolver.ArtifactCollector;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.repository.Proxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MojoSupport
extends AbstractMojo {
    protected MavenProjectHelper projectHelper;
    protected MavenProject project;
    protected File workDirectory;
    protected MavenProjectBuilder projectBuilder;
    protected ArtifactRepository localRepo;
    protected List<ArtifactRepository> remoteRepos;
    protected ArtifactMetadataSource artifactMetadataSource;
    protected ArtifactResolver resolver;
    protected ArtifactCollector collector = new GraphArtifactCollector();
    protected ArtifactFactory factory;
    private String featureArtifactType = "xml";
    protected MavenSession mavenSession;

    protected MavenProject getProject() {
        return this.project;
    }

    protected File getWorkDirectory() {
        return this.workDirectory;
    }

    public MavenProjectHelper getProjectHelper() {
        return this.projectHelper;
    }

    protected void removeBranch(ResolutionListenerImpl listener, Artifact artifact) {
        Node n = listener.getNode(artifact);
        if (n != null) {
            for (Node parent : n.getParents()) {
                parent.getChildren().remove(n);
            }
        }
    }

    protected void removeChildren(ResolutionListenerImpl listener, Artifact artifact) {
        Node n = listener.getNode(artifact);
        n.getChildren().clear();
    }

    protected Set getArtifacts(Node n, Set s) {
        if (!s.contains(n.getArtifact())) {
            s.add(n.getArtifact());
            for (Node c : n.getChildren()) {
                this.getArtifacts(c, s);
            }
        }
        return s;
    }

    protected void excludeBranch(Node n, Set excludes) {
        excludes.add(n);
        for (Node c : n.getChildren()) {
            this.excludeBranch(c, excludes);
        }
    }

    protected void print(Node rootNode) {
        for (Artifact a : this.getArtifacts(rootNode, new HashSet())) {
            this.getLog().info((CharSequence)(" " + a));
        }
    }

    protected Set retainArtifacts(Set includes, ResolutionListenerImpl listener) {
        HashSet<Artifact> finalIncludes = new HashSet<Artifact>();
        Set filteredArtifacts = this.getArtifacts(listener.getRootNode(), new HashSet());
        for (Artifact artifact : includes) {
            for (Artifact filteredArtifact : filteredArtifacts) {
                if (!filteredArtifact.getArtifactId().equals(artifact.getArtifactId()) || !filteredArtifact.getType().equals(artifact.getType()) || !filteredArtifact.getGroupId().equals(artifact.getGroupId())) continue;
                if (!filteredArtifact.getVersion().equals(artifact.getVersion())) {
                    this.getLog().warn((CharSequence)("Resolved artifact " + artifact + " has a different version from that in dependency management " + filteredArtifact + ", overriding dependency management"));
                }
                finalIncludes.add(artifact);
            }
        }
        return finalIncludes;
    }

    protected ResolutionListenerImpl resolveProject() {
        Map managedVersions = null;
        try {
            managedVersions = this.createManagedVersionMap(this.project.getId(), this.project.getDependencyManagement());
        }
        catch (ProjectBuildingException e) {
            this.getLog().error((CharSequence)"An error occurred while resolving project dependencies.", (Throwable)e);
        }
        ResolutionListenerImpl listener = new ResolutionListenerImpl();
        listener.setLog(this.getLog());
        try {
            this.collector.collect(this.project.getDependencyArtifacts(), this.project.getArtifact(), managedVersions, this.localRepo, this.remoteRepos, this.artifactMetadataSource, null, Collections.singletonList(listener));
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)"An error occurred while resolving project dependencies.", (Throwable)e);
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)"Dependency graph");
            this.getLog().debug((CharSequence)"================");
            this.print(listener.getRootNode());
            this.getLog().debug((CharSequence)"================");
        }
        return listener;
    }

    protected Map createManagedVersionMap(String projectId, DependencyManagement dependencyManagement) throws ProjectBuildingException {
        HashMap<String, Artifact> map;
        if (dependencyManagement != null && dependencyManagement.getDependencies() != null) {
            map = new HashMap<String, Artifact>();
            for (Dependency d : dependencyManagement.getDependencies()) {
                try {
                    VersionRange versionRange = VersionRange.createFromVersionSpec((String)d.getVersion());
                    Artifact artifact = this.factory.createDependencyArtifact(d.getGroupId(), d.getArtifactId(), versionRange, d.getType(), d.getClassifier(), d.getScope());
                    map.put(d.getManagementKey(), artifact);
                }
                catch (InvalidVersionSpecificationException e) {
                    throw new ProjectBuildingException(projectId, "Unable to parse version '" + d.getVersion() + "' for dependency '" + d.getManagementKey() + "': " + e.getMessage());
                }
            }
        } else {
            map = Collections.EMPTY_MAP;
        }
        return map;
    }

    protected URLClassLoader getClassLoader() throws MojoExecutionException {
        try {
            HashSet<URL> urls = new HashSet<URL>();
            URL mainClasses = new File(this.project.getBuild().getOutputDirectory()).toURL();
            this.getLog().debug((CharSequence)("Adding to classpath : " + mainClasses));
            urls.add(mainClasses);
            URL testClasses = new File(this.project.getBuild().getTestOutputDirectory()).toURL();
            this.getLog().debug((CharSequence)("Adding to classpath : " + testClasses));
            urls.add(testClasses);
            Set dependencies = this.project.getArtifacts();
            for (Artifact classPathElement : dependencies) {
                this.getLog().debug((CharSequence)("Adding artifact: " + classPathElement.getFile() + " to classpath"));
                urls.add(classPathElement.getFile().toURL());
            }
            URLClassLoader appClassloader = new URLClassLoader(urls.toArray(new URL[urls.size()]), ((Object)((Object)this)).getClass().getClassLoader());
            return appClassloader;
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("Error during setting up classpath", (Exception)e);
        }
    }

    protected String translateFromMaven(String uri) {
        if (uri.startsWith("mvn:")) {
            String[] parts = uri.substring("mvn:".length()).split("/");
            String groupId = parts[0];
            String artifactId = parts[1];
            String version = null;
            String classifier = null;
            String type = "jar";
            if (parts.length > 2) {
                version = parts[2];
                if (parts.length > 3) {
                    type = parts[3];
                    if (parts.length > 4) {
                        classifier = parts[4];
                    }
                }
            }
            String dir = groupId.replace('.', '/') + "/" + artifactId + "/" + version + "/";
            String name = artifactId + "-" + version + (classifier != null ? "-" + classifier : "") + "." + type;
            return this.getLocalRepoUrl() + "/" + dir + name;
        }
        if (System.getProperty("os.name").startsWith("Windows") && uri.startsWith("file:")) {
            String baseDir;
            String result = baseDir = uri.substring(5).replace('\\', '/').replaceAll(" ", "%20");
            if (baseDir.indexOf(":") > 0) {
                result = "file:///" + baseDir;
            }
            return result;
        }
        return uri;
    }

    protected String getLocalRepoUrl() {
        if (System.getProperty("os.name").startsWith("Windows")) {
            String baseDir = this.localRepo.getBasedir().replace('\\', '/').replaceAll(" ", "%20");
            return this.extractProtocolFromLocalMavenRepo() + ":///" + baseDir;
        }
        return this.localRepo.getUrl();
    }

    private String extractProtocolFromLocalMavenRepo() {
        try {
            return new URL(this.localRepo.getUrl()).getProtocol();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Repository URL is not valid", e);
        }
    }

    private Dependency findDependency(List<Dependency> dependencies, String artifactId, String groupId) {
        for (Dependency dep : dependencies) {
            if (!artifactId.equals(dep.getArtifactId()) || !groupId.equals(dep.getGroupId()) || !this.featureArtifactType.equals(dep.getType()) || dep.getVersion() == null) continue;
            return dep;
        }
        return null;
    }

    protected Artifact resourceToArtifact(String resourceLocation, boolean skipNonMavenProtocols) throws MojoExecutionException {
        int index3;
        int index = (resourceLocation = resourceLocation.replace("\r\n", "").replace("\n", "").replace(" ", "").replace("\t", "")).indexOf("mvn:");
        if (index < 0) {
            if (skipNonMavenProtocols) {
                return null;
            }
            throw new MojoExecutionException("Resource URL is not a maven URL: " + resourceLocation);
        }
        resourceLocation = resourceLocation.substring(index + "mvn:".length());
        int index1 = resourceLocation.indexOf(63);
        int index2 = resourceLocation.indexOf(35);
        int endIndex = -1;
        if (index1 > 0) {
            endIndex = index2 > 0 ? Math.min(index1, index2) : index1;
        } else if (index2 > 0) {
            endIndex = index2;
        }
        if (endIndex >= 0) {
            resourceLocation = resourceLocation.substring(0, endIndex);
        }
        if ((index3 = resourceLocation.indexOf(36)) > 0) {
            resourceLocation = resourceLocation.substring(0, index3);
        }
        DefaultArtifactRepository repo = null;
        if (resourceLocation.startsWith("http://")) {
            int repoDelimIntex = resourceLocation.indexOf(33);
            String repoUrl = resourceLocation.substring(0, repoDelimIntex);
            repo = new DefaultArtifactRepository(repoUrl, repoUrl, (ArtifactRepositoryLayout)new DefaultRepositoryLayout());
            Proxy mavenProxy = this.configureProxyToInlineRepo();
            if (mavenProxy != null) {
                repo.setProxy(mavenProxy);
            }
            resourceLocation = resourceLocation.substring(repoDelimIntex + 1);
        }
        String[] parts = resourceLocation.split("/");
        String groupId = parts[0];
        String artifactId = parts[1];
        String version = null;
        String classifier = null;
        String type = "jar";
        if (parts.length > 2) {
            version = parts[2];
            if (parts.length > 3) {
                type = parts[3];
                if (parts.length > 4) {
                    classifier = parts[4];
                }
            }
        } else {
            Dependency dep = this.findDependency(this.project.getDependencies(), artifactId, groupId);
            if (dep == null && this.project.getDependencyManagement() != null) {
                dep = this.findDependency(this.project.getDependencyManagement().getDependencies(), artifactId, groupId);
            }
            if (dep != null) {
                version = dep.getVersion();
                classifier = dep.getClassifier();
                type = dep.getType();
            }
        }
        if (version == null || version.length() == 0) {
            throw new MojoExecutionException("Cannot find version for: " + resourceLocation);
        }
        Artifact artifact = this.factory.createArtifactWithClassifier(groupId, artifactId, version, type, classifier);
        artifact.setRepository((ArtifactRepository)repo);
        return artifact;
    }

    private Proxy configureProxyToInlineRepo() {
        if (this.mavenSession != null && this.mavenSession.getSettings() != null) {
            org.apache.maven.settings.Proxy proxy = this.mavenSession.getSettings().getActiveProxy();
            Proxy mavenProxy = new Proxy();
            if (proxy != null) {
                mavenProxy.setProtocol(proxy.getProtocol());
                mavenProxy.setHost(proxy.getHost());
                mavenProxy.setPort(proxy.getPort());
                mavenProxy.setNonProxyHosts(proxy.getNonProxyHosts());
                mavenProxy.setUserName(proxy.getUsername());
                mavenProxy.setPassword(proxy.getPassword());
                return mavenProxy;
            }
            return null;
        }
        return null;
    }
}

