/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.tooling.commands;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.karaf.shell.commands.Action;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.HelpOption;
import org.apache.karaf.shell.commands.Option;
import org.apache.karaf.shell.commands.meta.ActionMetaData;
import org.apache.karaf.tooling.commands.CommandHelpPrinter;

public class DocBookCommandHelpPrinter
implements CommandHelpPrinter {
    @Override
    public void printHelp(Action action, ActionMetaData actionMeta, PrintStream out, boolean includeHelpOption) {
        String desc;
        Map optionsMap = actionMeta.getOptions();
        Map argsMap = actionMeta.getArguments();
        Command command = action.getClass().getAnnotation(Command.class);
        ArrayList arguments = new ArrayList(argsMap.keySet());
        Collections.sort(arguments, new Comparator<Argument>(){

            @Override
            public int compare(Argument o1, Argument o2) {
                return Integer.valueOf(o1.index()).compareTo(o2.index());
            }
        });
        HashSet options = new HashSet(optionsMap.keySet());
        if (includeHelpOption) {
            options.add(HelpOption.HELP);
        }
        out.println("<section>");
        out.println("  <title>" + command.scope() + ":" + command.name() + "</title>");
        out.println("  <section>");
        out.println("    <title>Description</title>");
        out.println("    <para>");
        out.println(command.description());
        out.println("    </para>");
        out.println("  </section>");
        StringBuffer syntax = new StringBuffer();
        syntax.append(String.format("%s:%s", command.scope(), command.name()));
        if (options.size() > 0) {
            syntax.append(" [options]");
        }
        if (arguments.size() > 0) {
            syntax.append(' ');
            for (Argument argument : arguments) {
                syntax.append(String.format(argument.required() ? "%s " : "[%s] ", argument.name()));
            }
        }
        out.println("  <section>");
        out.println("    <title>Syntax</title>");
        out.println("    <para>");
        out.println(syntax.toString());
        out.println("    </para>");
        out.println("  </section>");
        if (arguments.size() > 0) {
            out.println("  <section>");
            out.println("    <title>Arguments</title>");
            out.println("    <informaltable>");
            for (Argument argument : arguments) {
                Object o;
                String defaultValue;
                out.println("    <tr>");
                out.println("      <td>" + argument.name() + "</td>");
                String description = argument.description();
                if (!argument.required() && (defaultValue = actionMeta.getDefaultValueString(o = actionMeta.getDefaultValue((org.apache.felix.gogo.commands.Action)action, argument))) != null) {
                    description = description + " (defaults to " + o.toString() + ")";
                }
                out.println("      <td>" + description + "</td>");
                out.println("    </tr>");
            }
            out.println("    </informaltable>");
            out.println("  </section>");
        }
        if (options.size() > 0) {
            out.println("  <section>");
            out.println("    <title>Options</title>");
            out.println("    <informaltable>");
            for (Option option : options) {
                String opt = option.name();
                String description = option.description();
                for (String alias : option.aliases()) {
                    opt = opt + ", " + alias;
                }
                Object o = actionMeta.getDefaultValue((org.apache.felix.gogo.commands.Action)action, option);
                String defaultValue = actionMeta.getDefaultValueString(o);
                if (defaultValue != null) {
                    description = description + " (defaults to " + o.toString() + ")";
                }
                out.println("    <tr>");
                out.println("      <td>" + opt + "</td>");
                out.println("      <td>" + description + "</td>");
                out.println("    </tr>");
            }
            out.println("    </informaltable>");
            out.println("  </section>");
        }
        if ((desc = actionMeta.getDetailedDescription()) != null) {
            out.println("  <section>");
            out.println("    <title>Details</title>");
            out.println("    <para>");
            out.println(desc);
            out.println("    </para>");
            out.println("  </section>");
        }
        out.println("</section>");
    }

    @Override
    public void printOverview(Map<String, Set<String>> commands, PrintStream writer) {
        writer.println("<chapter id='commands' xmlns:xi=\"http://www.w3.org/2001/XInclude\">");
        writer.println("  <title>Commands</title>");
        writer.println("  <toc></toc>");
        for (String key : commands.keySet()) {
            writer.println("  <section id='commands-" + key + "'>");
            writer.println("    <title>" + key + "</title>");
            for (String cmd : commands.get(key)) {
                writer.println("    <xi:include href='" + key + "-" + cmd + ".xml' parse='xml'/>");
            }
            writer.println("  </section>");
        }
        writer.println("</chapter>");
    }
}

