/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.tooling.features;

import java.io.File;
import java.util.List;
import java.util.Set;
import org.apache.karaf.tooling.features.AbstractFeatureMojo;
import org.apache.karaf.tooling.features.CopyFileBasedDescriptor;
import org.apache.karaf.tooling.features.MavenUtil;
import org.apache.karaf.tooling.features.model.ArtifactRef;
import org.apache.karaf.tooling.features.model.Feature;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public class AddToRepositoryMojo
extends AbstractFeatureMojo {
    protected File repository;
    private boolean flatRepoLayout;
    protected List<CopyFileBasedDescriptor> copyFileBasedDescriptors;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Set<Feature> featuresSet = this.resolveFeatures();
        for (Artifact descriptor : this.descriptorArtifacts) {
            this.copy(descriptor, this.repository);
        }
        for (Feature feature : featuresSet) {
            this.copyArtifactsToDestRepository(feature.getBundles());
            this.copyArtifactsToDestRepository(feature.getConfigFiles());
        }
        this.copyFileBasedDescriptorsToDestRepository();
    }

    private void copyArtifactsToDestRepository(List<? extends ArtifactRef> artifactRefs) throws MojoExecutionException {
        for (ArtifactRef artifactRef : artifactRefs) {
            Artifact artifact = artifactRef.getArtifact();
            if (artifact == null) continue;
            this.copy(artifact, this.repository);
        }
    }

    protected void copy(Artifact artifact, File destRepository) {
        try {
            this.getLog().info((CharSequence)("Copying artifact: " + artifact));
            File destFile = new File(destRepository, this.getRelativePath(artifact));
            this.copy(artifact.getFile(), destFile);
        }
        catch (Exception e) {
            this.getLog().warn((CharSequence)("Error copying artifact " + artifact), (Throwable)e);
        }
    }

    private String getRelativePath(Artifact artifact) {
        String dir = this.flatRepoLayout ? "" : MavenUtil.getDir(artifact);
        String name = MavenUtil.getFileName(artifact);
        return dir + name;
    }

    private void copyFileBasedDescriptorsToDestRepository() {
        if (this.copyFileBasedDescriptors != null) {
            for (CopyFileBasedDescriptor fileBasedDescriptor : this.copyFileBasedDescriptors) {
                File destDir = new File(this.repository, fileBasedDescriptor.getTargetDirectory());
                File destFile = new File(destDir, fileBasedDescriptor.getTargetFileName());
                this.copy(fileBasedDescriptor.getSourceFile(), destFile);
            }
        }
    }
}

