/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.tooling.features;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLStreamException;
import org.apache.felix.utils.properties.Properties;
import org.apache.karaf.features.BundleInfo;
import org.apache.karaf.features.Dependency;
import org.apache.karaf.features.Feature;
import org.apache.karaf.features.FeaturesService;
import org.apache.karaf.features.Repository;
import org.apache.karaf.features.internal.model.Bundle;
import org.apache.karaf.features.internal.model.Features;
import org.apache.karaf.features.internal.model.JaxbUtil;
import org.apache.karaf.kar.internal.Kar;
import org.apache.karaf.tooling.features.DependencyHelper;
import org.apache.karaf.tooling.features.DependencyHelperFactory;
import org.apache.karaf.tooling.features.MavenUtil;
import org.apache.karaf.tooling.utils.MojoSupport;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.layout.DefaultRepositoryLayout;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public class InstallKarsMojo
extends MojoSupport {
    protected String workDirectory;
    protected File featuresCfgFile;
    protected File startupPropertiesFile;
    protected int defaultStartLevel = 30;
    protected boolean dontAddToStartup;
    protected File systemDirectory;
    private List<String> startupFeatures;
    private List<String> bootFeatures;
    private List<String> installedFeatures;
    private boolean addTransitiveFeatures = true;
    private URI system;
    private Properties startupProperties = new Properties();
    private Set<org.apache.karaf.features.internal.model.Feature> featureSet = new HashSet<org.apache.karaf.features.internal.model.Feature>();
    private List<Dependency> missingDependencies = new ArrayList<Dependency>();
    protected DependencyHelper dependencyHelper;
    private List<org.apache.karaf.features.internal.model.Feature> localRepoFeatures = new ArrayList<org.apache.karaf.features.internal.model.Feature>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        File target;
        block33: {
            this.dependencyHelper = DependencyHelperFactory.createDependencyHelper(this.container, this.project, this.mavenSession, this.getLog());
            this.systemDirectory.mkdirs();
            this.system = this.systemDirectory.toURI();
            if (this.startupPropertiesFile.exists()) {
                try {
                    FileInputStream in = new FileInputStream(this.startupPropertiesFile);
                    try {
                        this.startupProperties.load((InputStream)in);
                        break block33;
                    }
                    finally {
                        ((InputStream)in).close();
                    }
                }
                catch (IOException e) {
                    throw new MojoFailureException("Could not open existing startup.properties file at " + this.startupPropertiesFile, (Throwable)e);
                }
            }
            this.startupProperties.setHeader(Collections.singletonList("#Bundles to be started on startup, with startlevel"));
            if (!this.startupPropertiesFile.getParentFile().exists()) {
                this.startupPropertiesFile.getParentFile().mkdirs();
            }
        }
        OfflineFeaturesService featuresService = new OfflineFeaturesService();
        Set dependencies = this.project.getDependencyArtifacts();
        StringBuilder buf = new StringBuilder();
        for (Artifact artifact : dependencies) {
            this.dontAddToStartup = "runtime".equals(artifact.getScope());
            if ("kar".equals(artifact.getType()) && this.acceptScope(artifact)) {
                File file = artifact.getFile();
                try {
                    Kar kar = new Kar(file.toURI());
                    kar.extract(new File(this.system.getPath()), new File(this.workDirectory));
                    for (URI repoUri : kar.getFeatureRepos()) {
                        featuresService.removeRepository(repoUri);
                        featuresService.addRepository(repoUri);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not install kar: " + artifact.toString() + "\n", e);
                }
            }
            if (!"features".equals(artifact.getClassifier()) || !this.acceptScope(artifact)) continue;
            String uri = this.dependencyHelper.artifactToMvn(artifact);
            File source = artifact.getFile();
            DefaultRepositoryLayout layout = new DefaultRepositoryLayout();
            target = new File(this.system.resolve(layout.pathOf(artifact = this.factory.createArtifactWithClassifier(artifact.getGroupId(), artifact.getArtifactId(), artifact.getBaseVersion(), artifact.getType(), artifact.getClassifier()))));
            if (!target.exists()) {
                target.getParentFile().mkdirs();
                try {
                    this.copy(source, target);
                }
                catch (RuntimeException e) {
                    this.getLog().error((CharSequence)("Could not copy features " + uri + " from source file " + source), (Throwable)e);
                }
                if (artifact.isSnapshot()) {
                    this.getLog().debug((CharSequence)("Feature " + uri + " is a SNAPSHOT, generate the maven-metadata-local.xml file"));
                    File metadataTarget = new File(target.getParentFile(), "maven-metadata-local.xml");
                    try {
                        MavenUtil.generateMavenMetadata(artifact, metadataTarget);
                    }
                    catch (Exception e) {
                        this.getLog().warn((CharSequence)"Could not create maven-metadata-local.xml", (Throwable)e);
                        this.getLog().warn((CharSequence)"It means that this SNAPSHOT could be overwritten by an older one present on remote repositories");
                    }
                }
            }
            try {
                featuresService.addRepository(URI.create(uri));
            }
            catch (Exception e) {
                buf.append("Could not install feature: ").append(artifact.toString()).append("\n");
                buf.append(e.getMessage()).append("\n\n");
            }
        }
        Set keySet = this.startupProperties.keySet();
        for (Object keyObject : keySet) {
            String key = (String)keyObject;
            String path = this.dependencyHelper.pathFromMaven(key);
            target = new File(this.system.resolve(path));
            if (target.exists()) continue;
            this.install(key, target);
        }
        for (org.apache.karaf.features.internal.model.Feature feature : this.localRepoFeatures) {
            for (Bundle bundle : feature.getBundle()) {
                File target2;
                String path;
                File test;
                if (bundle.isDependency()) continue;
                String key = bundle.getLocation();
                if (key.startsWith("wrap:")) {
                    key = key.substring(5);
                }
                if ((test = new File(this.system.resolve(path = this.dependencyHelper.pathFromMaven(key)))).exists() || (target2 = new File(this.system.resolve(path))).exists()) continue;
                this.install(key, target2);
                Artifact artifact = this.dependencyHelper.mvnToArtifact(key);
                if (!artifact.isSnapshot()) continue;
                File metadataSource = new File(this.dependencyHelper.resolveById(key, this.getLog()).getParentFile(), "maven-metadata-local.xml");
                File metadataTarget = new File(target2.getParentFile(), "maven-metadata-local.xml");
                metadataTarget.getParentFile().mkdirs();
                try {
                    if (!metadataSource.exists()) {
                        MavenUtil.generateMavenMetadata(artifact, metadataTarget);
                        continue;
                    }
                    this.copy(metadataSource, metadataTarget);
                }
                catch (IOException ioException) {
                    this.getLog().warn((Throwable)ioException);
                    this.getLog().warn((CharSequence)"Unable to copy the maven-metadata-local.xml, it means that this SNAPSHOT will be overwritten by a remote one (if exist)");
                }
            }
        }
        try {
            FileOutputStream out = new FileOutputStream(this.startupPropertiesFile);
            try {
                this.startupProperties.save((OutputStream)out);
            }
            finally {
                ((OutputStream)out).close();
            }
        }
        catch (IOException e) {
            throw new MojoFailureException("Could not write startup.properties file at " + this.startupPropertiesFile, (Throwable)e);
        }
        if (buf.length() > 0) {
            throw new MojoExecutionException("Could not unpack all dependencies:\n" + buf.toString());
        }
    }

    private void install(String key, File target) throws MojoFailureException {
        File source = this.dependencyHelper.resolveById(key, this.getLog());
        target.getParentFile().mkdirs();
        this.copy(source, target);
    }

    private boolean acceptScope(Artifact artifact) {
        return "compile".equals(artifact.getScope()) || "runtime".equals(artifact.getScope());
    }

    private class OfflineFeaturesService
    implements FeaturesService {
        private static final String FEATURES_REPOSITORIES = "featuresRepositories";
        private static final String FEATURES_BOOT = "featuresBoot";

        private OfflineFeaturesService() {
        }

        public void validateRepository(URI uri) throws Exception {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addRepository(URI uri) throws Exception {
            if (InstallKarsMojo.this.dontAddToStartup) {
                InstallKarsMojo.this.getLog().info((CharSequence)("Adding feature repository to system: " + uri));
                if (InstallKarsMojo.this.featuresCfgFile.exists()) {
                    Properties properties = new Properties();
                    FileInputStream in = new FileInputStream(InstallKarsMojo.this.featuresCfgFile);
                    try {
                        properties.load((InputStream)in);
                    }
                    finally {
                        ((InputStream)in).close();
                    }
                    String existingFeatureRepos = this.retrieveProperty(properties, FEATURES_REPOSITORIES);
                    if (!existingFeatureRepos.contains(uri.toString())) {
                        existingFeatureRepos = existingFeatureRepos + uri.toString();
                        properties.put(FEATURES_REPOSITORIES, existingFeatureRepos);
                    }
                    Features repo = this.readFeatures(uri);
                    for (String innerRepository : repo.getRepository()) {
                        String innerRepositoryPath = InstallKarsMojo.this.dependencyHelper.pathFromMaven(innerRepository);
                        File innerRepositoryTargetInSystemRepository = new File(InstallKarsMojo.this.system.resolve(innerRepositoryPath));
                        if (innerRepositoryTargetInSystemRepository.exists()) continue;
                        File innerRepositorySourceFile = InstallKarsMojo.this.dependencyHelper.resolveById(innerRepository, InstallKarsMojo.this.getLog());
                        innerRepositoryTargetInSystemRepository.getParentFile().mkdirs();
                        InstallKarsMojo.this.copy(innerRepositorySourceFile, innerRepositoryTargetInSystemRepository);
                        Artifact innerRepositoryArtifact = InstallKarsMojo.this.dependencyHelper.mvnToArtifact(innerRepository);
                        if (!innerRepositoryArtifact.isSnapshot()) continue;
                        InstallKarsMojo.this.getLog().debug((CharSequence)("Feature repository " + innerRepository + " is a SNAPSHOT, generate the maven-metadata-local.xml file"));
                        File metadataTarget = new File(innerRepositoryTargetInSystemRepository.getParentFile(), "maven-metadata-local.xml");
                        try {
                            MavenUtil.generateMavenMetadata(innerRepositoryArtifact, metadataTarget);
                        }
                        catch (Exception e) {
                            InstallKarsMojo.this.getLog().warn((CharSequence)"Could not create maven-metadata-local.xml", (Throwable)e);
                            InstallKarsMojo.this.getLog().warn((CharSequence)"It means that this SNAPSHOT could be overwritten by an older one present on remote repositories");
                        }
                    }
                    for (org.apache.karaf.features.internal.model.Feature feature : repo.getFeature()) {
                        InstallKarsMojo.this.featureSet.add(feature);
                        if (InstallKarsMojo.this.startupFeatures != null && InstallKarsMojo.this.startupFeatures.contains(feature.getName())) {
                            this.installFeature((Feature)feature, null);
                            continue;
                        }
                        if (InstallKarsMojo.this.bootFeatures != null && InstallKarsMojo.this.bootFeatures.contains(feature.getName())) {
                            InstallKarsMojo.this.localRepoFeatures.add(feature);
                            InstallKarsMojo.this.missingDependencies.addAll(feature.getDependencies());
                            String existingBootFeatures = this.retrieveProperty(properties, FEATURES_BOOT);
                            if (existingBootFeatures.contains(feature.getName())) continue;
                            existingBootFeatures = existingBootFeatures + feature.getName();
                            properties.put(FEATURES_BOOT, existingBootFeatures);
                            continue;
                        }
                        if (InstallKarsMojo.this.installedFeatures == null || !InstallKarsMojo.this.installedFeatures.contains(feature.getName())) continue;
                        InstallKarsMojo.this.localRepoFeatures.add(feature);
                        InstallKarsMojo.this.missingDependencies.addAll(feature.getDependencies());
                    }
                    if (InstallKarsMojo.this.addTransitiveFeatures) {
                        this.addMissingDependenciesToRepo();
                    }
                    FileOutputStream out = new FileOutputStream(InstallKarsMojo.this.featuresCfgFile);
                    try {
                        properties.save((OutputStream)out);
                    }
                    finally {
                        out.close();
                    }
                }
            } else {
                InstallKarsMojo.this.getLog().info((CharSequence)("Installing feature " + uri + " to system and startup.properties"));
                Features features = this.readFeatures(uri);
                for (org.apache.karaf.features.internal.model.Feature feature : features.getFeature()) {
                    this.installFeature((Feature)feature, null);
                }
            }
        }

        private void addMissingDependenciesToRepo() {
            ListIterator<Dependency> iterator = InstallKarsMojo.this.missingDependencies.listIterator();
            while (iterator.hasNext()) {
                Dependency dependency = (Dependency)iterator.next();
                org.apache.karaf.features.internal.model.Feature depFeature = this.lookupFeature(dependency);
                if (depFeature == null) continue;
                InstallKarsMojo.this.localRepoFeatures.add(depFeature);
                iterator.remove();
                this.addAllMissingDependencies(iterator, depFeature);
            }
        }

        private void addAllMissingDependencies(ListIterator<Dependency> iterator, org.apache.karaf.features.internal.model.Feature depFeature) {
            for (Dependency dependency : depFeature.getDependencies()) {
                if (InstallKarsMojo.this.missingDependencies.contains(dependency)) continue;
                iterator.add(dependency);
            }
        }

        public void addRepository(URI uri, boolean install) throws Exception {
        }

        private String retrieveProperty(Properties properties, String key) {
            String val = properties.getProperty(key);
            return val != null && val.length() > 0 ? val + "," : "";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Features readFeatures(URI uri) throws MojoExecutionException, XMLStreamException, JAXBException, IOException {
            Features features;
            File repoFile;
            if (uri.toString().startsWith("mvn:")) {
                URI featuresPath = InstallKarsMojo.this.system.resolve(InstallKarsMojo.this.dependencyHelper.pathFromMaven(uri.toString()));
                repoFile = new File(featuresPath);
            } else {
                repoFile = new File(uri);
            }
            FileInputStream in = new FileInputStream(repoFile);
            try {
                features = JaxbUtil.unmarshal((InputStream)in, (boolean)false);
            }
            finally {
                ((InputStream)in).close();
            }
            return features;
        }

        public void removeRepository(URI uri) {
        }

        public void removeRepository(URI uri, boolean install) {
        }

        public void restoreRepository(URI uri) throws Exception {
        }

        public Repository[] listRepositories() {
            return new Repository[0];
        }

        public void installFeature(String name) throws Exception {
        }

        public void installFeature(String name, EnumSet<FeaturesService.Option> options) throws Exception {
        }

        public void installFeature(String name, String version) throws Exception {
        }

        public void installFeature(String name, String version, EnumSet<FeaturesService.Option> options) throws Exception {
        }

        public void installFeature(Feature feature, EnumSet<FeaturesService.Option> options) throws Exception {
            List<String> comment = Arrays.asList("", "# feature: " + feature.getName() + " version: " + feature.getVersion());
            for (BundleInfo bundle : feature.getBundles()) {
                String location = bundle.getLocation();
                String startLevel = Integer.toString(bundle.getStartLevel() == 0 ? InstallKarsMojo.this.defaultStartLevel : bundle.getStartLevel());
                if (InstallKarsMojo.this.startupProperties.containsKey((Object)location)) {
                    int oldStartLevel = Integer.decode((String)InstallKarsMojo.this.startupProperties.get((Object)location));
                    if (oldStartLevel <= bundle.getStartLevel()) continue;
                    InstallKarsMojo.this.startupProperties.put(location, startLevel);
                    continue;
                }
                if (comment == null) {
                    InstallKarsMojo.this.startupProperties.put(location, startLevel);
                    continue;
                }
                InstallKarsMojo.this.startupProperties.put(location, comment, startLevel);
                comment = null;
            }
        }

        private org.apache.karaf.features.internal.model.Feature lookupFeature(Dependency dependency) {
            for (org.apache.karaf.features.internal.model.Feature feature : InstallKarsMojo.this.featureSet) {
                if (!this.featureSatisfiesDependency(feature, dependency)) continue;
                return feature;
            }
            return null;
        }

        private boolean featureSatisfiesDependency(org.apache.karaf.features.internal.model.Feature feature, Dependency dependency) {
            return feature.getName().equals(dependency.getName());
        }

        public void installFeatures(Set<Feature> features, EnumSet<FeaturesService.Option> options) throws Exception {
        }

        public void uninstallFeature(String name) throws Exception {
        }

        public void uninstallFeature(String name, EnumSet<FeaturesService.Option> options) {
        }

        public void uninstallFeature(String name, String version) throws Exception {
        }

        public void uninstallFeature(String name, String version, EnumSet<FeaturesService.Option> options) {
        }

        public org.apache.karaf.features.internal.model.Feature[] listFeatures() throws Exception {
            return new org.apache.karaf.features.internal.model.Feature[0];
        }

        public org.apache.karaf.features.internal.model.Feature[] listInstalledFeatures() {
            return new org.apache.karaf.features.internal.model.Feature[0];
        }

        public boolean isInstalled(Feature f) {
            return false;
        }

        public Feature getFeature(String name, String version) throws Exception {
            return null;
        }

        public Feature getFeature(String name) throws Exception {
            return null;
        }

        public Repository getRepository(String repoName) {
            return null;
        }

        public void refreshRepository(URI uri) throws Exception {
        }
    }
}

