/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.tooling.features.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.karaf.tooling.features.model.ArtifactRef;
import org.apache.karaf.tooling.features.model.BundleRef;

public class Feature {
    private String name;
    private String version;
    private List<String> dependencies = new ArrayList<String>();
    private List<BundleRef> bundles = new ArrayList<BundleRef>();
    private Map<String, Map<String, String>> configs = new HashMap<String, Map<String, String>>();
    private List<ArtifactRef> configFiles = new ArrayList<ArtifactRef>();

    public Feature(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public List<String> getDependencies() {
        return this.dependencies;
    }

    public List<BundleRef> getBundles() {
        return this.bundles;
    }

    public Map<String, Map<String, String>> getConfigurations() {
        return this.configs;
    }

    public List<ArtifactRef> getConfigFiles() {
        return this.configFiles;
    }

    public void addDependency(String dependency) {
        this.dependencies.add(dependency);
    }

    public void addBundle(BundleRef bundle) {
        this.bundles.add(bundle);
    }

    public void addConfig(String name, Map<String, String> properties) {
        this.configs.put(name, properties);
    }

    public void addConfigFile(ArtifactRef configFile) {
        this.configFiles.add(configFile);
    }
}

