/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.tooling.url;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import org.apache.karaf.deployer.features.FeatureTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureURLHandler
extends URLStreamHandler {
    private final Logger logger = LoggerFactory.getLogger(FeatureURLHandler.class);
    private static String SYNTAX = "feature: xml-uri";
    private URL featureXmlURL;

    @Override
    public URLConnection openConnection(URL url) throws IOException {
        if (url.getPath() == null || url.getPath().trim().length() == 0) {
            throw new MalformedURLException("Path can not be null or empty. Syntax: " + SYNTAX);
        }
        this.featureXmlURL = new URL(url.getPath());
        this.logger.debug("Features xml URL is: [" + this.featureXmlURL + "]");
        return new Connection(url);
    }

    public URL getFeatureXmlURL() {
        return this.featureXmlURL;
    }

    public class Connection
    extends URLConnection {
        public Connection(URL url) {
            super(url);
        }

        @Override
        public void connect() throws IOException {
        }

        @Override
        public InputStream getInputStream() throws IOException {
            try {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                FeatureTransformer.transform((URL)FeatureURLHandler.this.featureXmlURL, (OutputStream)os);
                os.close();
                return new ByteArrayInputStream(os.toByteArray());
            }
            catch (Exception e) {
                FeatureURLHandler.this.logger.error("Error opening features xml url", (Throwable)e);
                throw (IOException)new IOException("Error opening features xml url").initCause(e);
            }
        }
    }
}

