/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.tooling.commands;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.karaf.shell.commands.Action;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.HelpOption;
import org.apache.karaf.shell.commands.Option;
import org.apache.karaf.shell.commands.meta.ActionMetaData;
import org.apache.karaf.tooling.commands.CommandHelpPrinter;

public class UserConfCommandHelpPrinter
implements CommandHelpPrinter {
    @Override
    public void printHelp(Action action, ActionMetaData actionMeta, PrintStream out, boolean includeHelpOption) {
        String detailedDesc;
        Map optionsMap = actionMeta.getOptions();
        Map argsMap = actionMeta.getArguments();
        Command command = actionMeta.getCommand();
        ArrayList arguments = new ArrayList(argsMap.keySet());
        Collections.sort(arguments, new Comparator<Argument>(){

            @Override
            public int compare(Argument o1, Argument o2) {
                return Integer.valueOf(o1.index()).compareTo(o2.index());
            }
        });
        HashSet options = new HashSet(optionsMap.keySet());
        if (includeHelpOption) {
            options.add(HelpOption.HELP);
        }
        out.println("h1. " + command.scope() + ":" + command.name());
        out.println();
        out.println("h2. Description");
        out.println(command.description());
        out.println();
        StringBuffer syntax = new StringBuffer();
        syntax.append(String.format("%s:%s", command.scope(), command.name()));
        if (options.size() > 0) {
            syntax.append(" \\[options\\]");
        }
        if (arguments.size() > 0) {
            syntax.append(' ');
            for (Argument argument : arguments) {
                syntax.append(String.format(argument.required() ? "%s " : "\\[%s\\] ", argument.name()));
            }
        }
        out.println("h2. Syntax");
        out.println(syntax.toString());
        out.println();
        if (arguments.size() > 0) {
            out.println("h2. Arguments");
            out.println("|| Name || Description ||");
            for (Argument argument : arguments) {
                Object o;
                String defaultValue;
                String description = argument.description();
                if (!argument.required() && (defaultValue = actionMeta.getDefaultValueString(o = actionMeta.getDefaultValue((org.apache.felix.gogo.commands.Action)action, argument))) != null) {
                    description = description + " (defaults to " + o.toString() + ")";
                }
                out.println("| " + argument.name() + " | " + description + " |");
            }
            out.println();
        }
        if (options.size() > 0) {
            out.println("h2. Options");
            out.println("|| Name || Description ||");
            for (Option option : options) {
                String opt = option.name();
                String desc = option.description();
                for (String alias : option.aliases()) {
                    opt = opt + ", " + alias;
                }
                Object o = actionMeta.getDefaultValue((org.apache.felix.gogo.commands.Action)action, option);
                String defaultValue = actionMeta.getDefaultValueString(o);
                if (defaultValue != null) {
                    desc = desc + " (defaults to " + defaultValue + ")";
                }
                out.println("| " + opt + " | " + desc + " |");
            }
            out.println();
        }
        if ((detailedDesc = actionMeta.getDetailedDescription()) != null) {
            out.println("h2. Details");
            out.println(detailedDesc);
        }
        out.println();
    }

    @Override
    public void printOverview(Map<String, Set<String>> commands, PrintStream writer) {
        writer.println("h1. Commands");
        writer.println();
        for (String key : commands.keySet()) {
            writer.println("h2. " + key);
            writer.println();
            for (String cmd : commands.get(key)) {
                writer.println("* [" + key + ":" + cmd + "|" + key + "-" + cmd + "]");
            }
            writer.println();
        }
    }
}

