/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.tooling.features;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.felix.utils.version.VersionRange;
import org.apache.felix.utils.version.VersionTable;
import org.apache.karaf.tooling.features.model.ArtifactRef;
import org.apache.karaf.tooling.features.model.Feature;
import org.apache.karaf.tooling.features.model.Repository;
import org.apache.karaf.tooling.utils.MojoSupport;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.MojoExecutionException;
import org.osgi.framework.Version;

public abstract class AbstractFeatureMojo
extends MojoSupport {
    protected List<String> descriptors;
    protected Set<Artifact> descriptorArtifacts = new HashSet<Artifact>();
    protected List<String> features;
    protected boolean addTransitiveFeatures = true;
    private boolean includeMvnBasedDescriptors = false;
    private boolean failOnArtifactResolutionError = true;
    private boolean resolveDefinedRepositoriesRecursively = true;
    protected boolean skipNonMavenProtocols = true;
    private int defaultStartLevel = 80;
    private int resolveCount = 0;

    protected void addFeatureRepo(String featureUrl) throws MojoExecutionException {
        Artifact featureDescArtifact = this.resourceToArtifact(featureUrl, true);
        if (featureDescArtifact == null) {
            return;
        }
        try {
            this.resolveArtifact(featureDescArtifact, this.remoteRepos);
            this.descriptors.add(0, featureUrl);
        }
        catch (Exception e) {
            this.getLog().warn((CharSequence)("Can't add " + featureUrl + " in the descriptors set"));
            this.getLog().debug((Throwable)e);
        }
    }

    protected void retrieveDescriptorsRecursively(String uri, Set<String> bundles, Map<String, Feature> featuresMap) {
        Artifact descriptor;
        try {
            descriptor = this.resourceToArtifact(uri, true);
        }
        catch (MojoExecutionException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        if (descriptor != null) {
            this.resolveArtifact(descriptor, this.remoteRepos);
            this.descriptorArtifacts.add(descriptor);
        }
        if (this.includeMvnBasedDescriptors) {
            bundles.add(uri);
        }
        URI repoURI = URI.create(this.translateFromMaven(uri.replaceAll(" ", "%20")));
        Repository repo = new Repository(repoURI, this.defaultStartLevel);
        for (Feature f : repo.getFeatures()) {
            featuresMap.put(f.getName() + "/" + f.getVersion(), f);
        }
        if (this.resolveDefinedRepositoriesRecursively) {
            for (String r : repo.getDefinedRepositories()) {
                this.retrieveDescriptorsRecursively(r, bundles, featuresMap);
            }
        }
    }

    protected void resolveArtifact(Artifact artifact, List<ArtifactRepository> remoteRepos) {
        try {
            List<ArtifactRepository> usedRemoteRepos = artifact.getRepository() != null ? Collections.singletonList(artifact.getRepository()) : remoteRepos;
            this.resolver.resolve(artifact, usedRemoteRepos, this.localRepo);
        }
        catch (Exception e) {
            if (this.failOnArtifactResolutionError) {
                throw new RuntimeException("Can't resolve artifact " + artifact, e);
            }
            this.getLog().warn((CharSequence)("Can't resolve artifact " + artifact));
            this.getLog().debug((Throwable)e);
        }
    }

    protected void addFeatures(List<String> featureNames, Set<Feature> features, Map<String, Feature> featuresMap, boolean transitive) {
        for (String feature : featureNames) {
            Feature f = this.getMatchingFeature(featuresMap, feature);
            features.add(f);
            if (!transitive) continue;
            this.addFeatures(f.getDependencies(), features, featuresMap, true);
        }
    }

    private Feature getMatchingFeature(Map<String, Feature> featuresMap, String feature) {
        int delimIndex = feature.indexOf(47);
        String version = null;
        if (delimIndex > 0) {
            version = feature.substring(delimIndex + 1);
            feature = feature.substring(0, delimIndex);
        }
        Feature f = null;
        if (version != null) {
            f = featuresMap.get(feature + "/" + version);
            if (f == null) {
                VersionRange versionRange = new VersionRange(version);
                for (String key : featuresMap.keySet()) {
                    String verStr;
                    Version ver;
                    String[] nameVersion = key.split("/");
                    if (!feature.equals(nameVersion[0]) || !versionRange.contains(ver = VersionTable.getVersion((String)(verStr = featuresMap.get(key).getVersion()))) || f != null && VersionTable.getVersion((String)f.getVersion()).compareTo(VersionTable.getVersion((String)featuresMap.get(key).getVersion())) >= 0) continue;
                    f = featuresMap.get(key);
                }
            }
        } else {
            for (String key : featuresMap.keySet()) {
                String[] nameVersion = key.split("/");
                if (!feature.equals(nameVersion[0])) continue;
                f = featuresMap.get(key);
                break;
            }
        }
        if (f == null) {
            throw new IllegalArgumentException("Unable to find the feature '" + feature + "'");
        }
        return f;
    }

    protected Set<Feature> resolveFeatures() throws MojoExecutionException {
        HashSet<Feature> featuresSet = new HashSet<Feature>();
        try {
            HashSet<String> artifactsToCopy = new HashSet<String>();
            HashMap<String, Feature> featuresMap = new HashMap<String, Feature>();
            for (String uri : this.descriptors) {
                this.retrieveDescriptorsRecursively(uri, artifactsToCopy, featuresMap);
            }
            if (this.features == null) {
                this.features = new ArrayList(featuresMap.keySet());
            }
            this.addFeatures(this.features, featuresSet, featuresMap, this.addTransitiveFeatures);
            this.getLog().info((CharSequence)("Base repo: " + this.localRepo.getUrl()));
            for (Feature feature : featuresSet) {
                this.resolveArtifacts(feature.getBundles());
                this.resolveArtifacts(feature.getConfigFiles());
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error populating repository", e);
        }
        return featuresSet;
    }

    private void resolveArtifacts(List<? extends ArtifactRef> artifactRefs) throws MojoExecutionException {
        for (ArtifactRef artifactRef : artifactRefs) {
            Artifact artifact = this.resourceToArtifact(artifactRef.getUrl(), this.skipNonMavenProtocols);
            if (artifact != null) {
                artifactRef.setArtifact(artifact);
                this.resolveArtifact(artifact, this.remoteRepos);
            }
            this.checkDoGarbageCollect();
        }
    }

    protected void checkDoGarbageCollect() {
        if (this.resolveCount++ % 100 == 0) {
            System.gc();
            System.runFinalization();
        }
    }
}

