/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.tooling.features;

import java.io.File;
import java.io.FileOutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.karaf.tooling.features.AbstractFeatureMojo;
import org.apache.karaf.tooling.features.FeatureMetaDataExporter;
import org.apache.karaf.tooling.features.model.BundleRef;
import org.apache.karaf.tooling.features.model.Feature;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.osgi.framework.Version;

public class ExportFeatureMetaDataMojo
extends AbstractFeatureMojo {
    private boolean mergedFeature;
    protected boolean oneVersion;
    private File metaDataFile;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Set<Feature> featuresSet = this.resolveFeatures();
        if (this.mergedFeature) {
            Feature feature = this.oneVersion ? this.mergeFeatureOneVersion(featuresSet) : this.mergeFeature(featuresSet);
            featuresSet = new HashSet<Feature>();
            featuresSet.add(feature);
        }
        try {
            this.metaDataFile.getParentFile().mkdirs();
            FeatureMetaDataExporter exporter = new FeatureMetaDataExporter(new FileOutputStream(this.metaDataFile));
            for (Feature feature : featuresSet) {
                exporter.writeFeature(feature);
            }
            exporter.close();
        }
        catch (Exception e) {
            throw new RuntimeException("Error writing feature meta data to " + this.metaDataFile + ": " + e.getMessage(), e);
        }
    }

    private Feature mergeFeature(Set<Feature> featuresSet) {
        Feature merged = new Feature("merged");
        HashSet<String> bundleIds = new HashSet<String>();
        for (Feature feature : featuresSet) {
            for (BundleRef bundle : feature.getBundles()) {
                bundle.readManifest();
                String bundleId = bundle.getBundleSymbolicName() + ":" + bundle.getBundleVersion();
                if (bundleIds.contains(bundleId)) continue;
                bundleIds.add(bundleId);
                merged.getBundles().add(bundle);
            }
        }
        return merged;
    }

    private Feature mergeFeatureOneVersion(Set<Feature> featuresSet) {
        Feature merged = new Feature("merged");
        HashMap<String, BundleRef> bundleVersions = new HashMap<String, BundleRef>();
        for (Feature feature : featuresSet) {
            for (BundleRef bundle : feature.getBundles()) {
                bundle.readManifest();
                BundleRef existingBundle = (BundleRef)bundleVersions.get(bundle.getBundleSymbolicName());
                if (existingBundle != null) {
                    Version existingVersion = new Version(existingBundle.getBundleVersion());
                    Version newVersion = new Version(bundle.getBundleVersion());
                    if (newVersion.compareTo(existingVersion) <= 0) continue;
                    bundleVersions.put(bundle.getBundleSymbolicName(), bundle);
                    continue;
                }
                bundleVersions.put(bundle.getBundleSymbolicName(), bundle);
            }
        }
        for (BundleRef bundle : bundleVersions.values()) {
            merged.getBundles().add(bundle);
        }
        return merged;
    }
}

