/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.tooling.features.model;

import java.io.File;
import java.io.FileInputStream;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.apache.karaf.tooling.features.model.ArtifactRef;
import org.apache.maven.artifact.Artifact;

public class BundleRef
extends ArtifactRef {
    Integer startLevel;
    Artifact artifact;
    String bundleSymbolicName;
    String bundleVersion;

    public BundleRef(String url, Integer startLevel) {
        super(url);
        this.startLevel = startLevel;
    }

    public Integer getStartLevel() {
        return this.startLevel;
    }

    public void readManifest() {
        JarInputStream bundleJar = null;
        try {
            File file = this.artifact.getFile();
            bundleJar = new JarInputStream(new FileInputStream(file));
            Manifest manifest = bundleJar.getManifest();
            this.bundleSymbolicName = manifest.getMainAttributes().getValue("Bundle-SymbolicName");
            this.bundleVersion = manifest.getMainAttributes().getValue("Bundle-Version");
            bundleJar.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getBundleSymbolicName() {
        return this.bundleSymbolicName;
    }

    public String getBundleVersion() {
        return this.bundleVersion;
    }
}

