/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.tooling.utils;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.DefaultArtifactRepository;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.artifact.repository.layout.DefaultRepositoryLayout;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.repository.Proxy;
import org.codehaus.plexus.PlexusContainer;

public abstract class MojoSupport
extends AbstractMojo {
    protected MavenProjectHelper projectHelper;
    protected MavenProject project;
    protected File workDirectory;
    protected MavenProjectBuilder projectBuilder;
    protected ArtifactRepository localRepo;
    protected List<ArtifactRepository> remoteRepos;
    protected ArtifactMetadataSource artifactMetadataSource;
    protected ArtifactResolver resolver;
    protected ArtifactFactory factory;
    private String featureArtifactType = "xml";
    protected MavenSession mavenSession;
    protected PlexusContainer container;

    protected MavenProject getProject() {
        return this.project;
    }

    protected File getWorkDirectory() {
        return this.workDirectory;
    }

    public MavenProjectHelper getProjectHelper() {
        return this.projectHelper;
    }

    protected Map createManagedVersionMap(String projectId, DependencyManagement dependencyManagement) throws ProjectBuildingException {
        HashMap<String, Artifact> map;
        if (dependencyManagement != null && dependencyManagement.getDependencies() != null) {
            map = new HashMap<String, Artifact>();
            for (Dependency d : dependencyManagement.getDependencies()) {
                try {
                    VersionRange versionRange = VersionRange.createFromVersionSpec((String)d.getVersion());
                    Artifact artifact = this.factory.createDependencyArtifact(d.getGroupId(), d.getArtifactId(), versionRange, d.getType(), d.getClassifier(), d.getScope());
                    map.put(d.getManagementKey(), artifact);
                }
                catch (InvalidVersionSpecificationException e) {
                    throw new ProjectBuildingException(projectId, "Unable to parse version '" + d.getVersion() + "' for dependency '" + d.getManagementKey() + "': " + e.getMessage(), (Throwable)e);
                }
            }
        } else {
            map = Collections.EMPTY_MAP;
        }
        return map;
    }

    protected String translateFromMaven(String uri) {
        if (uri.startsWith("mvn:")) {
            String[] parts = uri.substring("mvn:".length()).split("/");
            String groupId = parts[0];
            String artifactId = parts[1];
            String version = null;
            String classifier = null;
            String type = "jar";
            if (parts.length > 2) {
                version = parts[2];
                if (parts.length > 3) {
                    type = parts[3];
                    if (parts.length > 4) {
                        classifier = parts[4];
                    }
                }
            }
            String dir = groupId.replace('.', '/') + "/" + artifactId + "/" + version + "/";
            String name = artifactId + "-" + version + (classifier != null ? "-" + classifier : "") + "." + type;
            return this.getLocalRepoUrl() + "/" + dir + name;
        }
        if (System.getProperty("os.name").startsWith("Windows") && uri.startsWith("file:")) {
            String baseDir;
            String result = baseDir = uri.substring(5).replace('\\', '/').replaceAll(" ", "%20");
            if (baseDir.indexOf(":") > 0) {
                result = "file:///" + baseDir;
            }
            return result;
        }
        return uri;
    }

    protected String getLocalRepoUrl() {
        if (System.getProperty("os.name").startsWith("Windows")) {
            String baseDir = this.localRepo.getBasedir().replace('\\', '/').replaceAll(" ", "%20");
            return this.extractProtocolFromLocalMavenRepo() + ":///" + baseDir;
        }
        return this.localRepo.getUrl();
    }

    private String extractProtocolFromLocalMavenRepo() {
        try {
            return new URL(this.localRepo.getUrl()).getProtocol();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Repository URL is not valid", e);
        }
    }

    private Dependency findDependency(List<Dependency> dependencies, String artifactId, String groupId) {
        for (Dependency dep : dependencies) {
            if (!artifactId.equals(dep.getArtifactId()) || !groupId.equals(dep.getGroupId()) || !this.featureArtifactType.equals(dep.getType()) || dep.getVersion() == null) continue;
            return dep;
        }
        return null;
    }

    protected Artifact resourceToArtifact(String resourceLocation, boolean skipNonMavenProtocols) throws MojoExecutionException {
        int index3;
        int index = (resourceLocation = resourceLocation.replace("\r\n", "").replace("\n", "").replace(" ", "").replace("\t", "")).indexOf("mvn:");
        if (index < 0) {
            if (skipNonMavenProtocols) {
                return null;
            }
            throw new MojoExecutionException("Resource URL is not a Maven URL: " + resourceLocation);
        }
        resourceLocation = resourceLocation.substring(index + "mvn:".length());
        int index1 = resourceLocation.indexOf(63);
        int index2 = resourceLocation.indexOf(35);
        int endIndex = -1;
        if (index1 > 0) {
            endIndex = index2 > 0 ? Math.min(index1, index2) : index1;
        } else if (index2 > 0) {
            endIndex = index2;
        }
        if (endIndex >= 0) {
            resourceLocation = resourceLocation.substring(0, endIndex);
        }
        if ((index3 = resourceLocation.indexOf(36)) > 0) {
            resourceLocation = resourceLocation.substring(0, index3);
        }
        DefaultArtifactRepository repo = null;
        if (resourceLocation.startsWith("http://")) {
            int repoDelimIntex = resourceLocation.indexOf(33);
            String repoUrl = resourceLocation.substring(0, repoDelimIntex);
            repo = new DefaultArtifactRepository(repoUrl, repoUrl, (ArtifactRepositoryLayout)new DefaultRepositoryLayout());
            Proxy mavenProxy = this.configureProxyToInlineRepo();
            if (mavenProxy != null) {
                repo.setProxy(mavenProxy);
            }
            resourceLocation = resourceLocation.substring(repoDelimIntex + 1);
        }
        String[] parts = resourceLocation.split("/");
        String groupId = parts[0];
        String artifactId = parts[1];
        String version = null;
        String classifier = null;
        String type = "jar";
        if (parts.length > 2) {
            version = parts[2];
            if (parts.length > 3) {
                type = parts[3];
                if (parts.length > 4) {
                    classifier = parts[4];
                }
            }
        } else {
            Dependency dep = this.findDependency(this.project.getDependencies(), artifactId, groupId);
            if (dep == null && this.project.getDependencyManagement() != null) {
                dep = this.findDependency(this.project.getDependencyManagement().getDependencies(), artifactId, groupId);
            }
            if (dep != null) {
                version = dep.getVersion();
                classifier = dep.getClassifier();
                type = dep.getType();
            }
        }
        if (version == null || version.isEmpty()) {
            throw new MojoExecutionException("Cannot find version for: " + resourceLocation);
        }
        Artifact artifact = this.factory.createArtifactWithClassifier(groupId, artifactId, version, type, classifier);
        artifact.setRepository((ArtifactRepository)repo);
        return artifact;
    }

    private Proxy configureProxyToInlineRepo() {
        if (this.mavenSession != null && this.mavenSession.getSettings() != null) {
            org.apache.maven.settings.Proxy proxy = this.mavenSession.getSettings().getActiveProxy();
            Proxy mavenProxy = new Proxy();
            if (proxy != null) {
                mavenProxy.setProtocol(proxy.getProtocol());
                mavenProxy.setHost(proxy.getHost());
                mavenProxy.setPort(proxy.getPort());
                mavenProxy.setNonProxyHosts(proxy.getNonProxyHosts());
                mavenProxy.setUserName(proxy.getUsername());
                mavenProxy.setPassword(proxy.getPassword());
                return mavenProxy;
            }
            return null;
        }
        return null;
    }

    protected void silentClose(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected void copy(File sourceFile, File destFile) {
        File targetDir = destFile.getParentFile();
        MojoSupport.ensureDirExists(targetDir);
        FileInputStream is = null;
        BufferedOutputStream bos = null;
        try {
            is = new FileInputStream(sourceFile);
            bos = new BufferedOutputStream(new FileOutputStream(destFile));
            int count = 0;
            byte[] buffer = new byte[8192];
            while ((count = is.read(buffer)) > 0) {
                bos.write(buffer, 0, count);
            }
            bos.close();
            this.silentClose(is);
            this.silentClose(bos);
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                this.silentClose(is);
                this.silentClose(bos);
                throw throwable;
            }
        }
    }

    private static void ensureDirExists(File targetDir) {
        if (!targetDir.exists()) {
            if (!targetDir.mkdirs()) {
                throw new RuntimeException("Unable to create target directory: " + targetDir);
            }
        } else if (!targetDir.isDirectory()) {
            throw new RuntimeException("Target is not a directory: " + targetDir);
        }
    }
}

