/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.tooling.instances;

import java.io.File;
import java.io.IOException;
import org.apache.karaf.tooling.utils.MojoSupport;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Tar;
import org.apache.tools.ant.taskdefs.Zip;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.TarFileSet;
import org.apache.tools.ant.types.ZipFileSet;

public class CreateArchiveMojo
extends MojoSupport {
    private File destDir;
    private File targetServerDirectory;
    private File targetFile;
    private boolean archiveTarGz = true;
    private boolean archiveZip = true;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().debug((CharSequence)("Setting artifact file: " + this.targetFile));
        Artifact artifact = this.project.getArtifact();
        artifact.setFile(this.targetFile);
        try {
            if (this.archiveTarGz) {
                this.archive("tar.gz");
            }
            if (this.archiveZip) {
                this.archive("zip");
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Could not archive plugin", e);
        }
    }

    private void archive(String type) throws IOException {
        Artifact artifact1 = this.factory.createArtifactWithClassifier(this.project.getArtifact().getGroupId(), this.project.getArtifact().getArtifactId(), this.project.getArtifact().getVersion(), type, "bin");
        File target1 = this.archive(this.targetServerDirectory, this.destDir, artifact1);
        this.projectHelper.attachArtifact(this.project, artifact1.getType(), null, target1);
    }

    public File archive(File source, File dest, Artifact artifact) throws IOException {
        Zip archiver;
        String serverName = artifact.getArtifactId() + "-" + artifact.getVersion();
        dest = new File(dest, serverName + "." + artifact.getType());
        Project project = new Project();
        if ("tar.gz".equals(artifact.getType())) {
            Tar tar = new Tar();
            Tar.TarCompressionMethod tarCompressionMethod = new Tar.TarCompressionMethod();
            tarCompressionMethod.setValue("gzip");
            tar.setCompression(tarCompressionMethod);
            Tar.TarLongFileMode fileMode = new Tar.TarLongFileMode();
            fileMode.setValue("gnu");
            tar.setLongfile(fileMode);
            tar.setDestFile(dest);
            TarFileSet rc = new TarFileSet();
            rc.setDir(source);
            rc.setPrefix(serverName);
            rc.setProject(project);
            rc.setExcludes("bin/");
            tar.add((ResourceCollection)rc);
            rc = new TarFileSet();
            rc.setDir(source);
            rc.setPrefix(serverName);
            rc.setProject(project);
            rc.setIncludes("bin/");
            rc.setExcludes("bin/*.bat");
            rc.setFileMode("755");
            tar.add((ResourceCollection)rc);
            rc = new TarFileSet();
            rc.setDir(source);
            rc.setPrefix(serverName);
            rc.setProject(project);
            rc.setIncludes("bin/*.bat");
            tar.add((ResourceCollection)rc);
            for (Resource resource : this.project.getResources()) {
                File resourceFile = new File(resource.getDirectory());
                if (!resourceFile.exists()) continue;
                rc = new TarFileSet();
                rc.setPrefix(serverName);
                rc.setProject(project);
                rc.setDir(resourceFile);
                rc.appendIncludes(resource.getIncludes().toArray(new String[0]));
                rc.appendExcludes(resource.getExcludes().toArray(new String[0]));
                tar.add((ResourceCollection)rc);
            }
            archiver = tar;
        } else if ("zip".equals(artifact.getType())) {
            Zip zip = new Zip();
            zip.setDestFile(dest);
            ZipFileSet fs = new ZipFileSet();
            fs.setDir(source);
            fs.setPrefix(serverName);
            fs.setProject(project);
            fs.setExcludes("bin/");
            zip.addFileset((FileSet)fs);
            fs = new ZipFileSet();
            fs.setDir(source);
            fs.setPrefix(serverName);
            fs.setProject(project);
            fs.setIncludes("bin/");
            fs.setExcludes("bin/*.bat");
            fs.setFileMode("755");
            zip.add((ResourceCollection)fs);
            fs = new ZipFileSet();
            fs.setDir(source);
            fs.setPrefix(serverName);
            fs.setProject(project);
            fs.setIncludes("bin/*.bat");
            zip.add((ResourceCollection)fs);
            for (Resource resource : this.project.getResources()) {
                File resourceFile = new File(resource.getDirectory());
                if (!resourceFile.exists()) continue;
                fs = new ZipFileSet();
                fs.setPrefix(serverName);
                fs.setProject(project);
                fs.setDir(resourceFile);
                fs.appendIncludes(resource.getIncludes().toArray(new String[0]));
                fs.appendExcludes(resource.getExcludes().toArray(new String[0]));
                zip.add((ResourceCollection)fs);
            }
            archiver = zip;
        } else {
            throw new IllegalArgumentException("Unknown target type: " + artifact.getType());
        }
        archiver.setProject(project);
        archiver.execute();
        return dest;
    }
}

