/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.tooling.features;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.felix.utils.properties.Properties;
import org.apache.karaf.features.BundleInfo;
import org.apache.karaf.features.Dependency;
import org.apache.karaf.features.internal.model.Bundle;
import org.apache.karaf.features.internal.model.Conditional;
import org.apache.karaf.features.internal.model.ConfigFile;
import org.apache.karaf.features.internal.model.Feature;
import org.apache.karaf.features.internal.model.Features;
import org.apache.karaf.features.internal.model.JaxbUtil;
import org.apache.karaf.kar.internal.Kar;
import org.apache.karaf.tooling.features.DependencyHelper;
import org.apache.karaf.tooling.features.DependencyHelperFactory;
import org.apache.karaf.tooling.features.MavenUtil;
import org.apache.karaf.tooling.utils.MojoSupport;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public class InstallKarsMojo
extends MojoSupport {
    protected File workDirectory;
    protected File featuresCfgFile;
    protected File startupPropertiesFile;
    protected int defaultStartLevel = 30;
    protected File systemDirectory;
    private List<String> startupFeatures;
    private List<String> bootFeatures;
    private List<String> installedFeatures;
    protected boolean ignoreDependencyFlag;
    private Properties startupProperties = new Properties();
    protected DependencyHelper dependencyHelper;
    private static final String FEATURES_REPOSITORIES = "featuresRepositories";
    private static final String FEATURES_BOOT = "featuresBoot";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        block40: {
            this.dependencyHelper = DependencyHelperFactory.createDependencyHelper(this.container, this.project, this.mavenSession, this.getLog());
            this.getLog().info((CharSequence)"Creating system directory");
            this.systemDirectory.mkdirs();
            if (this.startupPropertiesFile.exists()) {
                this.getLog().info((CharSequence)"Loading startup.properties");
                try {
                    FileInputStream in = new FileInputStream(this.startupPropertiesFile);
                    try {
                        this.startupProperties.load((InputStream)in);
                        break block40;
                    }
                    finally {
                        ((InputStream)in).close();
                    }
                }
                catch (IOException e) {
                    throw new MojoFailureException("Could not open existing startup.properties file at " + this.startupPropertiesFile, (Throwable)e);
                }
            }
            this.getLog().info((CharSequence)"Creating startup.properties");
            this.startupProperties.setHeader(Collections.singletonList("#Bundles to be started on startup, with startlevel"));
            if (!this.startupPropertiesFile.getParentFile().exists()) {
                this.startupPropertiesFile.getParentFile().mkdirs();
            }
        }
        HashSet<String> repositories = new HashSet<String>();
        HashMap<Feature, Boolean> features = new HashMap<Feature, Boolean>();
        this.getLog().info((CharSequence)"Loading kar and features repositories dependencies with compile or runtime scopes");
        this.getLog().info((CharSequence)"The startup.properties file is updated using kar and features dependency with a scope different from runtime, or defined in the <startupFeatures/> plugin configuration");
        Set dependencies = this.project.getDependencyArtifacts();
        for (Artifact artifact : dependencies) {
            boolean addToStartup;
            boolean bl = addToStartup = !artifact.getScope().equals("runtime");
            if (!artifact.getScope().equals("compile") && !artifact.getScope().equals("runtime")) continue;
            if (artifact.getType().equals("kar")) {
                File karFile = artifact.getFile();
                this.getLog().info((CharSequence)("Extracting " + artifact.toString() + " kar"));
                try {
                    Kar kar = new Kar(karFile.toURI());
                    kar.extract(this.systemDirectory, this.workDirectory);
                    for (URI repositoryUri : kar.getFeatureRepos()) {
                        this.resolveRepository(repositoryUri.getPath(), repositories, features, false, addToStartup, false);
                    }
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException("Can not install " + artifact.toString() + " kar", e);
                }
            }
            if (artifact.getClassifier() == null || !artifact.getClassifier().equals("features")) continue;
            this.getLog().info((CharSequence)("Resolving " + artifact.toString() + " features repository"));
            String repositoryUri = this.dependencyHelper.artifactToMvn(artifact);
            try {
                this.resolveRepository(repositoryUri, repositories, features, true, addToStartup, true);
            }
            catch (Exception e) {
                throw new MojoFailureException("Can not install " + artifact.toString() + " features repository", (Throwable)e);
            }
        }
        this.getLog().info((CharSequence)"Checking features resolution");
        if (features != null && this.startupFeatures != null) {
            for (String startupFeature : this.startupFeatures) {
                if (startupFeature == null || startupFeature.isEmpty() || this.resolveFeature(features.keySet(), startupFeature)) continue;
                throw new MojoFailureException("Startup feature " + startupFeature + " is not resolved. Check that <dependencies/> provide the kar of features repository providing this feature (with compile or runtime scope)");
            }
        }
        if (features != null && this.bootFeatures != null) {
            for (String bootFeature : this.bootFeatures) {
                if (bootFeature == null || bootFeature.isEmpty() || this.resolveFeature(features.keySet(), bootFeature)) continue;
                throw new MojoFailureException("Boot feature " + bootFeature + " is not resolved. Check that <dependencies/> provide the kar of features repository providing this feature (with compile or runtime scope)");
            }
        }
        if (features != null && this.installedFeatures != null) {
            for (String installedFeature : this.installedFeatures) {
                if (installedFeature == null || installedFeature.isEmpty() || this.resolveFeature(features.keySet(), installedFeature)) continue;
                throw new MojoFailureException("Boot feature " + installedFeature + " is not resolved. Check that <dependencies/> provide the kar of features repository providing this feature (with compile or runtime scope)");
            }
        }
        this.getLog().info((CharSequence)"Installing features");
        for (Feature feature : features.keySet()) {
            try {
                if (((Boolean)features.get(feature)).booleanValue() || this.startupFeatures != null && this.resolveFeature(this.startupFeatures, feature)) {
                    this.getLog().info((CharSequence)("Feature " + feature.getName() + "/" + feature.getVersion() + " is defined as a startup feature"));
                    this.getLog().info((CharSequence)"= Updating startup.properties file");
                    List<String> comment = Arrays.asList("", "# feature: " + feature.getName() + " version: " + feature.getVersion());
                    for (BundleInfo bundleInfo : feature.getBundles()) {
                        String bundleLocation = bundleInfo.getLocation().trim();
                        String bundleStartLevel = Integer.toString(bundleInfo.getStartLevel() == 0 ? this.defaultStartLevel : bundleInfo.getStartLevel());
                        if (this.startupProperties.containsKey((Object)bundleLocation)) {
                            int oldStartLevel = Integer.decode((String)this.startupProperties.get((Object)bundleLocation));
                            if (oldStartLevel <= bundleInfo.getStartLevel()) continue;
                            this.startupProperties.put(bundleLocation, bundleStartLevel);
                            continue;
                        }
                        if (comment == null) {
                            this.startupProperties.put(bundleLocation, bundleStartLevel);
                            continue;
                        }
                        this.startupProperties.put(bundleLocation, comment, bundleStartLevel);
                        comment = null;
                    }
                    this.resolveFeature(feature, features);
                    continue;
                }
                if (this.bootFeatures != null && this.resolveFeature(this.bootFeatures, feature)) {
                    this.getLog().info((CharSequence)("Feature " + feature.getName() + "/" + feature.getVersion() + " is defined as a boot feature"));
                    this.resolveFeature(feature, features);
                    continue;
                }
                if (this.installedFeatures != null && this.resolveFeature(this.installedFeatures, feature)) {
                    this.getLog().info((CharSequence)("Feature " + feature.getName() + "/" + feature.getVersion() + " is defined as a installed feature"));
                    this.resolveFeature(feature, features);
                    continue;
                }
                this.getLog().debug((CharSequence)("Feature " + feature.getName() + "/" + feature.getVersion() + " is not installed"));
            }
            catch (Exception e) {
                throw new MojoFailureException("Can not install " + feature.getName() + "/" + feature.getVersion() + " feature", (Throwable)e);
            }
        }
        if (this.bootFeatures != null && this.featuresCfgFile.exists()) {
            try {
                this.getLog().info((CharSequence)("= Updating " + this.featuresCfgFile.getPath()));
                Properties featuresProperties = new Properties(this.featuresCfgFile);
                String featuresBoot = featuresProperties.getProperty(FEATURES_BOOT);
                if (featuresBoot == null) {
                    featuresBoot = "";
                }
                Set<String> boot = this.parseBootFeatures(featuresBoot);
                for (String bootFeature : this.bootFeatures) {
                    String[] split = bootFeature.split("/");
                    String name = split[0].trim();
                    if (split.length == 2) {
                        name = name + ";version=\"" + split[1].trim() + "\"";
                    }
                    if (!boot.add(name)) continue;
                    featuresBoot = featuresBoot + (featuresBoot.isEmpty() ? "" : ",") + name;
                }
                featuresProperties.put(FEATURES_BOOT, featuresBoot);
                featuresProperties.save(this.featuresCfgFile);
            }
            catch (Exception e) {
                throw new MojoFailureException("Can not update " + this.featuresCfgFile, (Throwable)e);
            }
        }
        this.getLog().info((CharSequence)"Generating the startup.properties file");
        try {
            FileOutputStream out = new FileOutputStream(this.startupPropertiesFile);
            try {
                this.startupProperties.save((OutputStream)out);
            }
            finally {
                ((OutputStream)out).close();
            }
        }
        catch (IOException e) {
            throw new MojoFailureException("Can not write " + this.startupPropertiesFile, (Throwable)e);
        }
    }

    protected Set<String> parseBootFeatures(String bootFeatures) {
        Pattern pattern = Pattern.compile("(\\s*\\(([^)]+))\\s*\\)\\s*,\\s*|.+");
        Matcher matcher = pattern.matcher(bootFeatures);
        HashSet<String> result = new HashSet<String>();
        while (matcher.find()) {
            String group = matcher.group(2) != null ? matcher.group(2) : matcher.group();
            for (String feature : Arrays.asList(group.trim().split("\\s*,\\s*"))) {
                if (feature.length() <= 0) continue;
                result.add(feature);
            }
        }
        return result;
    }

    private boolean resolveFeature(Set<Feature> features, String featureToCheck) {
        String name = featureToCheck;
        String[] split = name.split("/");
        if (split.length == 2) {
            name = split[0];
            String version = split[1];
            boolean found = false;
            for (Feature feature : features) {
                if (!feature.getName().equals(name) || !feature.getVersion().equals(version)) continue;
                found = true;
                break;
            }
            return found;
        }
        boolean found = false;
        for (Feature feature : features) {
            if (!feature.getName().equals(name)) continue;
            found = true;
            break;
        }
        return found;
    }

    private boolean resolveFeature(List<String> features, Feature feature) {
        for (String f : features) {
            String[] split = f.split("/");
            if (split.length == 2) {
                String name = split[0];
                String version = split[1];
                if (!feature.getName().equals(name) || !feature.getVersion().equals(version)) continue;
                return true;
            }
            if (!feature.getName().equals(f)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resolveRepository(String repository, Set<String> repositories, Map<Feature, Boolean> features, boolean updateFeaturesCfgFile, boolean updateStartupProperties, boolean copy) throws Exception {
        File repositoryFileInSystemFolder;
        File repositoryFile;
        if (repositories.contains(repository)) {
            return;
        }
        this.getLog().info((CharSequence)("Resolving " + repository + " features repository"));
        repositories.add(repository);
        if (updateFeaturesCfgFile && this.featuresCfgFile.exists()) {
            Properties featuresProperties = new Properties();
            FileInputStream in = new FileInputStream(this.featuresCfgFile);
            try {
                featuresProperties.load((InputStream)in);
            }
            finally {
                ((InputStream)in).close();
            }
            String featureRepos = featuresProperties.getProperty(FEATURES_REPOSITORIES);
            String string = featureRepos = featureRepos != null && featureRepos.length() > 0 ? featureRepos + "," : "";
            if (!featureRepos.contains(repository)) {
                featureRepos = featureRepos + repository;
                featuresProperties.put(FEATURES_REPOSITORIES, featureRepos);
                featuresProperties.save(this.featuresCfgFile);
            }
        }
        if (repository.startsWith("mvn")) {
            repositoryFile = this.dependencyHelper.resolveById(repository, this.getLog());
            repository = this.dependencyHelper.pathFromMaven(repository);
        } else {
            repositoryFile = new File(repository);
        }
        if (copy && !(repositoryFileInSystemFolder = new File(this.systemDirectory, repository)).exists()) {
            Artifact repositoryArtifact;
            repositoryFileInSystemFolder.getParentFile().mkdirs();
            this.copy(repositoryFile, repositoryFileInSystemFolder);
            if (repository.startsWith("mvn") && (repositoryArtifact = this.dependencyHelper.mvnToArtifact(repository)).isSnapshot()) {
                File metadataTarget = new File(repositoryFileInSystemFolder.getParentFile(), "maven-metadata-local.xml");
                try {
                    MavenUtil.generateMavenMetadata(repositoryArtifact, metadataTarget);
                }
                catch (Exception e) {
                    this.getLog().warn((CharSequence)"Could not create maven-metadata-local.xml", (Throwable)e);
                    this.getLog().warn((CharSequence)"It means that this SNAPSHOT could be overwritten by an older one present on remote repositories");
                }
            }
        }
        Features featuresModel = JaxbUtil.unmarshal((InputStream)new FileInputStream(repositoryFile), (boolean)false);
        for (String innerRepository : featuresModel.getRepository()) {
            this.resolveRepository(innerRepository, repositories, features, false, updateStartupProperties, true);
        }
        for (Feature feature : featuresModel.getFeature()) {
            features.put(feature, updateStartupProperties);
        }
    }

    private void resolveFeature(Feature feature, Map<Feature, Boolean> features) throws Exception {
        for (Dependency dependency : feature.getFeature()) {
            for (Feature f : features.keySet()) {
                if (!f.getName().equals(dependency.getName())) continue;
                this.resolveFeature(f, features);
            }
        }
        this.getLog().info((CharSequence)("Resolving feature " + feature.getName()));
        this.getLog().info((CharSequence)("= Installing bundles from " + feature.getName() + " feature"));
        for (Bundle bundle : feature.getBundle()) {
            this.installBundle(bundle);
        }
        this.getLog().info((CharSequence)("= Installing configuration files from " + feature.getName() + " feature"));
        for (ConfigFile configFile : feature.getConfigfile()) {
            this.installConfigFile(configFile);
        }
        for (Conditional conditional : feature.getConditional()) {
            boolean found = true;
            for (Dependency condition : conditional.getCondition()) {
                if (this.installedFeatures == null || this.installedFeatures.contains(condition.getName()) || this.bootFeatures == null || this.bootFeatures.contains(condition.getName())) continue;
                found = false;
                break;
            }
            if (!found) continue;
            this.getLog().info((CharSequence)("= Installing conditional " + conditional.getCondition().toString()));
            this.getLog().debug((CharSequence)"== Conditional features ...");
            for (Dependency dependency : conditional.getFeature()) {
                for (Feature f : features.keySet()) {
                    if (!f.getName().equals(dependency.getName())) continue;
                    this.resolveFeature(f, features);
                }
            }
            this.getLog().debug((CharSequence)"== Conditional bundles");
            for (Bundle bundle : conditional.getBundle()) {
                this.installBundle(bundle);
            }
            this.getLog().debug((CharSequence)"== Conditional configuration files");
            for (ConfigFile configFile : conditional.getConfigfile()) {
                this.installConfigFile(configFile);
            }
        }
    }

    private void installBundle(Bundle bundle) throws Exception {
        if (!this.ignoreDependencyFlag && bundle.isDependency()) {
            this.getLog().warn((CharSequence)("== Bundle " + bundle.getLocation().trim() + " is defined as dependency, so it's not installed"));
        } else {
            Artifact bundleArtifact;
            File bundleFile;
            int index;
            this.getLog().info((CharSequence)("== Installing bundle " + bundle.getLocation().trim()));
            String bundleLocation = bundle.getLocation().trim();
            if (bundleLocation.startsWith("wrap:") && (index = (bundleLocation = bundleLocation.substring("wrap:".length())).indexOf("$")) != -1) {
                bundleLocation = bundleLocation.substring(0, index);
            }
            if (bundleLocation.startsWith("blueprint:")) {
                bundleLocation = bundleLocation.substring("blueprint:".length());
            }
            if (bundleLocation.startsWith("webbundle:")) {
                bundleLocation = bundleLocation.substring("webbundle:".length());
            }
            if (bundleLocation.startsWith("war:")) {
                bundleLocation = bundleLocation.substring("war:".length());
            }
            if (bundleLocation.startsWith("mvn:")) {
                int index2;
                if (bundleLocation.endsWith("/")) {
                    bundleLocation = bundleLocation.substring(0, bundleLocation.length() - 1);
                }
                if (bundleLocation.startsWith("mvn:http") && (index2 = bundleLocation.indexOf("!")) != -1) {
                    bundleLocation = bundleLocation.substring(index2 + 1);
                    bundleLocation = "mvn:" + bundleLocation;
                }
                bundleFile = this.dependencyHelper.resolveById(bundleLocation, this.getLog());
                bundleLocation = this.dependencyHelper.pathFromMaven(bundleLocation);
            } else {
                bundleFile = new File(new URI(bundleLocation));
            }
            File bundleSystemFile = new File(this.systemDirectory, bundleLocation);
            this.copy(bundleFile, bundleSystemFile);
            if (bundleLocation.startsWith("mvn") && (bundleArtifact = this.dependencyHelper.mvnToArtifact(bundleLocation)).isSnapshot()) {
                File metadataTarget = new File(bundleSystemFile.getParentFile(), "maven-metadata-local.xml");
                try {
                    MavenUtil.generateMavenMetadata(bundleArtifact, metadataTarget);
                }
                catch (Exception e) {
                    this.getLog().warn((CharSequence)"Could not create maven-metadata-local.xml", (Throwable)e);
                    this.getLog().warn((CharSequence)"It means that this SNAPSHOT could be overwritten by an older one present on remote repositories");
                }
            }
        }
    }

    private void installConfigFile(ConfigFile configFile) throws Exception {
        Artifact configFileArtifact;
        File configFileFile;
        this.getLog().warn((CharSequence)("== Installing configuration file " + configFile.getLocation().trim()));
        String configFileLocation = configFile.getLocation().trim();
        if (configFileLocation.startsWith("mvn:")) {
            configFileFile = this.dependencyHelper.resolveById(configFileLocation, this.getLog());
            configFileLocation = this.dependencyHelper.pathFromMaven(configFileLocation);
        } else {
            configFileFile = new File(new URI(configFileLocation));
        }
        File configFileSystemFile = new File(this.systemDirectory, configFileLocation);
        this.copy(configFileFile, configFileSystemFile);
        if (configFileLocation.startsWith("mvn") && (configFileArtifact = this.dependencyHelper.mvnToArtifact(configFileLocation)).isSnapshot()) {
            File metadataTarget = new File(configFileSystemFile.getParentFile(), "maven-metadata-local.xml");
            try {
                MavenUtil.generateMavenMetadata(configFileArtifact, metadataTarget);
            }
            catch (Exception e) {
                this.getLog().warn((CharSequence)"Could not create maven-metadata-local.xml", (Throwable)e);
                this.getLog().warn((CharSequence)"It means that this SNAPSHOT could be overwritten by an older one present on remote repositories");
            }
        }
    }
}

