/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.tooling.features.model;

import java.io.ByteArrayInputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.karaf.tooling.features.model.ArtifactRef;
import org.apache.karaf.tooling.features.model.BundleRef;
import org.apache.karaf.tooling.features.model.ConfigRef;
import org.apache.karaf.tooling.features.model.Feature;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Repository {
    private URI uri;
    private List<Feature> features;
    private List<String> repositories;
    private Integer defaultStartLevel;

    public Repository(URI uri, Integer defaultStartLevel) {
        this.uri = uri;
        this.defaultStartLevel = defaultStartLevel;
    }

    public URI getURI() {
        return this.uri;
    }

    public Feature[] getFeatures() {
        if (this.features == null) {
            this.loadFeatures();
        }
        return this.features.toArray(new Feature[this.features.size()]);
    }

    public String[] getDefinedRepositories() {
        if (this.repositories == null) {
            this.loadRepositories();
        }
        return this.repositories.toArray(new String[this.repositories.size()]);
    }

    private void loadRepositories() {
        try {
            this.repositories = new ArrayList<String>();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            Document doc = factory.newDocumentBuilder().parse(this.uri.toURL().openStream());
            NodeList nodes = doc.getDocumentElement().getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                if (!(node instanceof Element) || !"repository".equals(node.getNodeName())) continue;
                Element e = (Element)nodes.item(i);
                this.repositories.add(e.getTextContent().trim());
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error loading feature descriptors from " + this.uri, e);
        }
    }

    private void loadFeatures() {
        try {
            this.features = new ArrayList<Feature>();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            Document doc = factory.newDocumentBuilder().parse(this.uri.toURL().openStream());
            NodeList nodes = doc.getDocumentElement().getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                if (!(node instanceof Element) || !"feature".equals(node.getNodeName())) continue;
                Element e = (Element)nodes.item(i);
                String name = e.getAttribute("name");
                String version = e.getAttribute("version");
                Feature f = new Feature(name);
                f.setVersion(version);
                NodeList featureNodes = e.getElementsByTagName("feature");
                for (int j = 0; j < featureNodes.getLength(); ++j) {
                    Element b = (Element)featureNodes.item(j);
                    if (b.getAttribute("version") != null && b.getAttribute("version").length() > 0) {
                        f.addDependency(b.getTextContent() + "/" + b.getAttribute("version"));
                        continue;
                    }
                    f.addDependency(b.getTextContent());
                }
                NodeList configNodes = e.getElementsByTagName("config");
                for (int j = 0; j < configNodes.getLength(); ++j) {
                    Element c = (Element)configNodes.item(j);
                    String cfgName = c.getAttribute("name");
                    String data = c.getTextContent();
                    String append = c.getAttribute("append");
                    Properties properties = new Properties();
                    properties.load(new ByteArrayInputStream(data.getBytes()));
                    Hashtable<String, String> hashtable = new Hashtable<String, String>();
                    for (Object key : properties.keySet()) {
                        String n = key.toString();
                        hashtable.put(n, properties.getProperty(n));
                    }
                    f.addConfig(new ConfigRef(cfgName, hashtable, append));
                }
                NodeList configFileNodes = e.getElementsByTagName("configfile");
                for (int j = 0; j < configFileNodes.getLength(); ++j) {
                    Element c = (Element)configFileNodes.item(j);
                    f.addConfigFile(new ArtifactRef(c.getTextContent()));
                }
                NodeList bundleNodes = e.getElementsByTagName("bundle");
                for (int j = 0; j < bundleNodes.getLength(); ++j) {
                    Element b = (Element)bundleNodes.item(j);
                    Integer startLevel = this.getInt(b, "start-level", this.defaultStartLevel);
                    f.addBundle(new BundleRef(b.getTextContent(), startLevel));
                }
                this.features.add(f);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error loading features for " + this.uri, e);
        }
    }

    private Integer getInt(Element el, String key, Integer defaultValue) {
        Integer value;
        try {
            value = Integer.parseInt(el.getAttribute(key));
        }
        catch (Exception e1) {
            value = null;
        }
        return value == null || value == 0 ? defaultValue : value;
    }
}

