/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.tooling.instances;

import java.io.File;
import java.io.IOException;
import org.apache.karaf.tooling.utils.MojoSupport;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.taskdefs.Tar;
import org.apache.tools.ant.taskdefs.Zip;
import org.apache.tools.ant.types.ArchiveFileSet;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.TarFileSet;
import org.apache.tools.ant.types.ZipFileSet;

public class CreateArchiveMojo
extends MojoSupport {
    private File destDir;
    private File targetServerDirectory;
    private File targetFile;
    private boolean archiveTarGz = true;
    private boolean archiveZip = true;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().debug((CharSequence)("Setting artifact file: " + this.targetFile));
        Artifact artifact = this.project.getArtifact();
        artifact.setFile(this.targetFile);
        try {
            if (this.archiveTarGz) {
                this.archive("tar.gz");
            }
            if (this.archiveZip) {
                this.archive("zip");
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Could not archive plugin", e);
        }
    }

    private void archive(String type) throws IOException {
        Artifact artifact1 = this.factory.createArtifactWithClassifier(this.project.getArtifact().getGroupId(), this.project.getArtifact().getArtifactId(), this.project.getArtifact().getVersion(), type, "bin");
        File target1 = this.archive(this.targetServerDirectory, this.destDir, artifact1);
        this.projectHelper.attachArtifact(this.project, artifact1.getType(), null, target1);
    }

    public File archive(File source, File dest, Artifact artifact) throws IOException {
        Archiver<TarFileSet> archiver;
        String serverName = null;
        serverName = this.targetFile != null && this.project.getPackaging().equals("karaf-assembly") ? this.targetFile.getName() : artifact.getArtifactId() + "-" + artifact.getVersion();
        dest = new File(dest, serverName + "." + artifact.getType());
        if ("tar.gz".equals(artifact.getType())) {
            archiver = new TarArchiver(dest);
        } else if ("zip".equals(artifact.getType())) {
            archiver = new ZipArchiver(dest);
        } else {
            throw new IllegalArgumentException("Unknown target type: " + artifact.getType());
        }
        this.populateArchive(archiver, source, serverName);
        return dest;
    }

    private <T extends ArchiveFileSet> void populateArchive(Archiver<T> archiver, File source, String serverName) {
        Project project = new Project();
        T fileSet = archiver.createFileSet();
        fileSet.setDir(source);
        fileSet.setPrefix(serverName);
        fileSet.setProject(project);
        fileSet.setExcludes("bin/");
        archiver.add(fileSet);
        fileSet = archiver.createFileSet();
        fileSet.setDir(source);
        fileSet.setPrefix(serverName);
        fileSet.setProject(project);
        fileSet.setIncludes("bin/");
        fileSet.setExcludes("bin/*.bat");
        fileSet.setFileMode("755");
        archiver.add(fileSet);
        fileSet = archiver.createFileSet();
        fileSet.setDir(source);
        fileSet.setPrefix(serverName);
        fileSet.setProject(project);
        fileSet.setIncludes("bin/*.bat");
        archiver.add(fileSet);
        File outputDirectory = new File(this.project.getBuild().getOutputDirectory());
        if (outputDirectory.exists()) {
            fileSet = archiver.createFileSet();
            fileSet.setPrefix(serverName);
            fileSet.setDir(outputDirectory);
            fileSet.setProject(project);
            fileSet.setExcludes("**/*.class");
            archiver.add(fileSet);
        }
        MatchingTask task = archiver.getTask();
        task.setProject(project);
        task.execute();
    }

    private static interface Archiver<T extends ArchiveFileSet> {
        public MatchingTask getTask();

        public T createFileSet();

        public void add(T var1);
    }

    private class TarArchiver
    implements Archiver<TarFileSet> {
        private final Tar tar = new Tar();

        public TarArchiver(File dest) {
            Tar.TarCompressionMethod tarCompressionMethod = new Tar.TarCompressionMethod();
            tarCompressionMethod.setValue("gzip");
            this.tar.setCompression(tarCompressionMethod);
            Tar.TarLongFileMode fileMode = new Tar.TarLongFileMode();
            fileMode.setValue("gnu");
            this.tar.setLongfile(fileMode);
            this.tar.setDestFile(dest);
        }

        @Override
        public TarFileSet createFileSet() {
            return new TarFileSet();
        }

        @Override
        public void add(TarFileSet fileSet) {
            this.tar.add((ResourceCollection)fileSet);
        }

        @Override
        public MatchingTask getTask() {
            return this.tar;
        }
    }

    private class ZipArchiver
    implements Archiver<ZipFileSet> {
        private final Zip zip = new Zip();

        public ZipArchiver(File dest) {
            this.zip.setDestFile(dest);
        }

        @Override
        public ZipFileSet createFileSet() {
            return new ZipFileSet();
        }

        @Override
        public void add(ZipFileSet fileSet) {
            this.zip.add((ResourceCollection)fileSet);
        }

        @Override
        public MatchingTask getTask() {
            return this.zip;
        }
    }
}

