/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.tooling.commands;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.karaf.shell.commands.Action;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.HelpOption;
import org.apache.karaf.shell.commands.Option;
import org.apache.karaf.shell.commands.meta.ActionMetaData;
import org.apache.karaf.tooling.commands.CommandHelpPrinter;

public class AsciiDoctorCommandHelpPrinter
implements CommandHelpPrinter {
    @Override
    public void printHelp(Action action, ActionMetaData actionMeta, PrintStream out, boolean includeHelpOption) {
        String desc;
        Map optionsMap = actionMeta.getOptions();
        Map argsMap = actionMeta.getArguments();
        Command command = action.getClass().getAnnotation(Command.class);
        ArrayList arguments = new ArrayList(argsMap.keySet());
        Collections.sort(arguments, new Comparator<Argument>(){

            @Override
            public int compare(Argument o1, Argument o2) {
                return Integer.valueOf(o1.index()).compareTo(o2.index());
            }
        });
        HashSet options = new HashSet(optionsMap.keySet());
        if (includeHelpOption) {
            options.add(HelpOption.HELP);
        }
        out.println("= " + command.scope() + ":" + command.name());
        out.println();
        out.println("== Description");
        out.println(command.description());
        out.println();
        StringBuffer syntax = new StringBuffer();
        syntax.append(String.format("%s:%s", command.scope(), command.name()));
        if (options.size() > 0) {
            syntax.append(" [options]");
        }
        if (arguments.size() > 0) {
            syntax.append(' ');
            for (Argument argument : arguments) {
                syntax.append(String.format(argument.required() ? "%s " : "[%s] ", argument.name()));
            }
        }
        out.println("== Syntax");
        out.println();
        out.println(syntax.toString());
        out.println();
        if (arguments.size() > 0) {
            out.println("== Arguments");
            out.println();
            out.println("|===");
            out.println("|Name |Description");
            for (Argument argument : arguments) {
                Object o;
                String defaultValue;
                String description = argument.description();
                if (!argument.required() && (defaultValue = actionMeta.getDefaultValueString(o = actionMeta.getDefaultValue((org.apache.felix.gogo.commands.Action)action, argument))) != null) {
                    description = description + " (defaults to " + o.toString() + ")";
                }
                out.println();
                out.println("| " + argument.name());
                out.println("| " + description);
            }
            out.println("|===");
            out.println();
        }
        if (options.size() > 0) {
            out.println("== Options");
            out.println();
            out.println("|===");
            out.println("|Name |Description");
            for (Option option : options) {
                String opt = option.name();
                String description = option.description();
                for (String alias : option.aliases()) {
                    opt = opt + ", " + alias;
                }
                Object o = actionMeta.getDefaultValue((org.apache.felix.gogo.commands.Action)action, option);
                String defaultValue = actionMeta.getDefaultValueString(o);
                if (defaultValue != null) {
                    description = description + " (defaults to " + o.toString() + ")";
                }
                out.println();
                out.println("|" + opt);
                out.println("|" + description);
            }
            out.println("|===");
            out.println();
        }
        if ((desc = actionMeta.getDetailedDescription()) != null) {
            out.println("== Details");
            out.println();
            out.println(desc);
            out.println();
        }
        out.println();
    }

    @Override
    public void printOverview(Map<String, Set<String>> commands, PrintStream writer) {
        writer.println("= Commands");
        writer.println();
        for (String key : commands.keySet()) {
            writer.println("== " + key);
            writer.println();
            for (String cmd : commands.get(key)) {
                writer.println("* link:" + key + "-" + cmd + "[" + key + ":" + cmd + "]");
            }
        }
        writer.println();
    }
}

