/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.tooling.features;

import java.io.OutputStream;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartDocument;
import org.apache.karaf.tooling.features.MavenUtil;
import org.apache.karaf.tooling.features.model.ArtifactRef;
import org.apache.karaf.tooling.features.model.BundleRef;
import org.apache.karaf.tooling.features.model.Feature;
import org.apache.maven.artifact.Artifact;

public class FeatureMetaDataExporter {
    private XMLEventWriter writer;
    private XMLEventFactory factory;

    public FeatureMetaDataExporter(OutputStream out) throws XMLStreamException {
        XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
        this.writer = outputFactory.createXMLEventWriter(out);
        this.factory = XMLEventFactory.newInstance();
        StartDocument startDocument = this.factory.createStartDocument();
        this.writer.add(startDocument);
        this.newLine();
        this.writer.add(this.factory.createStartElement("", "", "features"));
        this.newLine();
    }

    public void writeFeature(Feature feature) throws XMLStreamException {
        Artifact artifact;
        String name;
        this.writeFeatureTag(feature);
        for (String featureDep : feature.getDependencies()) {
            this.writer.add(this.factory.createStartElement("", "", "feature"));
            this.writer.add(this.factory.createCharacters(featureDep));
            this.endElement("feature");
        }
        for (BundleRef bundle : feature.getBundles()) {
            this.writer.add(this.factory.createStartElement("", "", "bundle"));
            if (bundle.getStartLevel() != null) {
                this.writer.add(this.factory.createAttribute("start-level", bundle.getStartLevel().toString()));
            }
            if (bundle.getArtifact() != null) {
                name = MavenUtil.getFileName(bundle.getArtifact());
                this.writer.add(this.factory.createAttribute("name", name));
                artifact = bundle.getArtifact();
                bundle.readManifest();
                if (bundle.getBundleSymbolicName() != null) {
                    String[] results = bundle.getBundleSymbolicName().split(";");
                    this.writer.add(this.factory.createAttribute("Bundle-SymbolicName", results[0]));
                    this.writer.add(this.factory.createAttribute("Bundle-Version", bundle.getBundleVersion()));
                }
                this.writer.add(this.factory.createAttribute("groupId", artifact.getGroupId()));
                this.writer.add(this.factory.createAttribute("artifactId", artifact.getArtifactId()));
                if (artifact.getType() != null) {
                    this.writer.add(this.factory.createAttribute("type", artifact.getType()));
                }
                if (artifact.getClassifier() != null) {
                    this.writer.add(this.factory.createAttribute("classifier", artifact.getClassifier()));
                }
                this.writer.add(this.factory.createAttribute("version", artifact.getBaseVersion()));
            }
            this.writer.add(this.factory.createCharacters(bundle.getUrl()));
            this.endElement("bundle");
        }
        for (ArtifactRef config : feature.getConfigFiles()) {
            this.writer.add(this.factory.createStartElement("", "", "config"));
            if (config.getArtifact() != null) {
                name = MavenUtil.getFileName(config.getArtifact());
                this.writer.add(this.factory.createAttribute("name", name));
                artifact = config.getArtifact();
                this.writer.add(this.factory.createAttribute("groupId", artifact.getGroupId()));
                this.writer.add(this.factory.createAttribute("artifactId", artifact.getArtifactId()));
                if (artifact.getType() != null) {
                    this.writer.add(this.factory.createAttribute("type", artifact.getType()));
                }
                if (artifact.getClassifier() != null) {
                    this.writer.add(this.factory.createAttribute("classifier", artifact.getClassifier()));
                }
                this.writer.add(this.factory.createAttribute("version", artifact.getBaseVersion()));
            }
            this.writer.add(this.factory.createCharacters(config.getUrl()));
            this.endElement("config");
        }
        this.endElement("feature");
    }

    private void writeFeatureTag(Feature feature) throws XMLStreamException {
        this.writer.add(this.factory.createStartElement("", "", "feature"));
        this.writer.add(this.factory.createAttribute("name", feature.getName()));
        if (feature.getVersion() != null) {
            this.writer.add(this.factory.createAttribute("version", feature.getVersion()));
        }
        this.newLine();
    }

    public void close() throws XMLStreamException {
        this.endElement("features");
        this.writer.add(this.factory.createEndDocument());
        this.writer.close();
    }

    private void endElement(String elementName) throws XMLStreamException {
        this.writer.add(this.factory.createEndElement("", "", elementName));
        this.newLine();
    }

    private void newLine() throws XMLStreamException {
        this.writer.add(this.factory.createCharacters("\r\n"));
    }
}

