/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.tooling;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.karaf.profile.assembly.Builder;
import org.apache.karaf.tooling.utils.IoUtils;
import org.apache.karaf.tooling.utils.MavenUtil;
import org.apache.karaf.tooling.utils.MojoSupport;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="assembly", defaultPhase=LifecyclePhase.PROCESS_RESOURCES, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class AssemblyMojo
extends MojoSupport {
    @Parameter(defaultValue="${project.build.directory}/assembly")
    protected File workDirectory;
    @Parameter(defaultValue="${project.build.directory}/assembly/etc/org.apache.karaf.features.cfg")
    protected File featuresCfgFile;
    @Parameter(defaultValue="${project.build.directory}/assembly/etc/startup.properties")
    protected File startupPropertiesFile;
    @Parameter(defaultValue="${project.build.directory}/assembly/system")
    protected File systemDirectory;
    @Parameter
    protected int defaultStartLevel = 30;
    @Parameter
    private List<String> startupRepositories;
    @Parameter
    private List<String> bootRepositories;
    @Parameter
    private List<String> installedRepositories;
    @Parameter
    private List<String> startupFeatures;
    @Parameter
    private List<String> bootFeatures;
    @Parameter
    private List<String> installedFeatures;
    @Parameter
    private List<String> blacklistedFeatures;
    @Parameter
    private List<String> startupBundles;
    @Parameter
    private List<String> bootBundles;
    @Parameter
    private List<String> installedBundles;
    @Parameter
    private List<String> blacklistedBundles;
    @Parameter
    private String profilesUri;
    @Parameter
    private List<String> bootProfiles;
    @Parameter
    private List<String> startupProfiles;
    @Parameter
    private List<String> installedProfiles;
    @Parameter
    private List<String> blacklistedProfiles;
    @Parameter
    private Builder.BlacklistPolicy blacklistPolicy;
    @Parameter(defaultValue="false")
    protected boolean ignoreDependencyFlag;
    @Parameter
    protected List<String> featureRepositories;
    @Parameter
    protected List<String> libraries;
    @Parameter(defaultValue="false")
    protected boolean useReferenceUrls;
    @Parameter(defaultValue="true")
    protected boolean includeBuildOutputDirectory;
    @Parameter
    protected boolean installAllFeaturesByDefault = true;
    @Parameter
    protected Builder.KarafVersion karafVersion = Builder.KarafVersion.v4x;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.doExecute();
        }
        catch (MojoExecutionException | MojoFailureException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to build assembly", e);
        }
    }

    protected void doExecute() throws Exception {
        this.startupRepositories = this.nonNullList(this.startupRepositories);
        this.bootRepositories = this.nonNullList(this.bootRepositories);
        this.installedRepositories = this.nonNullList(this.installedRepositories);
        this.startupBundles = this.nonNullList(this.startupBundles);
        this.bootBundles = this.nonNullList(this.bootBundles);
        this.installedBundles = this.nonNullList(this.installedBundles);
        this.blacklistedBundles = this.nonNullList(this.blacklistedBundles);
        this.startupFeatures = this.nonNullList(this.startupFeatures);
        this.bootFeatures = this.nonNullList(this.bootFeatures);
        this.installedFeatures = this.nonNullList(this.installedFeatures);
        this.blacklistedFeatures = this.nonNullList(this.blacklistedFeatures);
        this.startupProfiles = this.nonNullList(this.startupProfiles);
        this.bootProfiles = this.nonNullList(this.bootProfiles);
        this.installedProfiles = this.nonNullList(this.installedProfiles);
        this.blacklistedProfiles = this.nonNullList(this.blacklistedProfiles);
        if (!(this.startupProfiles.isEmpty() && this.bootProfiles.isEmpty() && this.installedProfiles.isEmpty() || this.profilesUri != null)) {
            throw new IllegalArgumentException("profilesDirectory must be specified");
        }
        if (this.featureRepositories != null && !this.featureRepositories.isEmpty()) {
            this.getLog().warn((CharSequence)"Use of featureRepositories is deprecated, use startupRepositories, bootRepositories or installedRepositories instead");
            this.startupRepositories.addAll(this.featureRepositories);
            this.bootRepositories.addAll(this.featureRepositories);
            this.installedRepositories.addAll(this.featureRepositories);
        }
        Builder builder = Builder.newInstance();
        builder.blacklistBundles(this.blacklistedBundles);
        builder.blacklistFeatures(this.blacklistedFeatures);
        builder.blacklistProfiles(this.blacklistedProfiles);
        builder.blacklistPolicy(this.blacklistPolicy);
        this.getLog().info((CharSequence)"Creating work directory");
        builder.homeDirectory(this.workDirectory.toPath());
        IoUtils.deleteRecursive(this.workDirectory);
        this.workDirectory.mkdirs();
        ArrayList<String> startupKars = new ArrayList<String>();
        ArrayList<String> bootKars = new ArrayList<String>();
        ArrayList<String> installedKars = new ArrayList<String>();
        this.getLog().info((CharSequence)"Loading kar and features repositories dependencies");
        block25: for (Artifact artifact : this.project.getDependencyArtifacts()) {
            String uri;
            Builder.Stage stage;
            switch (artifact.getScope()) {
                case "compile": {
                    stage = Builder.Stage.Startup;
                    break;
                }
                case "runtime": {
                    stage = Builder.Stage.Boot;
                    break;
                }
                case "provided": {
                    stage = Builder.Stage.Installed;
                    break;
                }
                default: {
                    continue block25;
                }
            }
            if ("kar".equals(artifact.getType())) {
                uri = this.artifactToMvn(artifact);
                switch (stage) {
                    case Startup: {
                        startupKars.add(uri);
                        break;
                    }
                    case Boot: {
                        bootKars.add(uri);
                        break;
                    }
                    case Installed: {
                        installedKars.add(uri);
                    }
                }
                continue;
            }
            if ("features".equals(artifact.getClassifier())) {
                uri = this.artifactToMvn(artifact);
                switch (stage) {
                    case Startup: {
                        this.startupRepositories.add(uri);
                        break;
                    }
                    case Boot: {
                        this.bootRepositories.add(uri);
                        break;
                    }
                    case Installed: {
                        this.installedRepositories.add(uri);
                    }
                }
                continue;
            }
            if (!"jar".equals(artifact.getType()) && !"bundle".equals(artifact.getType())) continue;
            uri = this.artifactToMvn(artifact);
            switch (stage) {
                case Startup: {
                    this.startupBundles.add(uri);
                    break;
                }
                case Boot: {
                    this.bootBundles.add(uri);
                    break;
                }
                case Installed: {
                    this.installedBundles.add(uri);
                }
            }
        }
        builder.karafVersion(this.karafVersion).useReferenceUrls(this.useReferenceUrls).defaultAddAll(this.installAllFeaturesByDefault).ignoreDependencyFlag(this.ignoreDependencyFlag);
        if (this.profilesUri != null) {
            builder.profilesUris(new String[]{this.profilesUri});
        }
        if (this.libraries != null) {
            builder.libraries(this.libraries.toArray(new String[this.libraries.size()]));
        }
        builder.defaultStage(Builder.Stage.Startup).kars(this.toArray(startupKars)).repositories(this.startupFeatures.isEmpty() && this.startupProfiles.isEmpty() && this.installAllFeaturesByDefault, this.toArray(this.startupRepositories)).features(this.toArray(this.startupFeatures)).bundles(this.toArray(this.startupBundles)).profiles(this.toArray(this.startupProfiles));
        builder.defaultStage(Builder.Stage.Boot).kars(this.toArray(bootKars)).repositories(this.bootFeatures.isEmpty() && this.bootProfiles.isEmpty() && this.installAllFeaturesByDefault, this.toArray(this.bootRepositories)).features(this.toArray(this.bootFeatures)).bundles(this.toArray(this.bootBundles)).profiles(this.toArray(this.bootProfiles));
        builder.defaultStage(Builder.Stage.Installed).kars(this.toArray(installedKars)).repositories(this.installedFeatures.isEmpty() && this.installedProfiles.isEmpty() && this.installAllFeaturesByDefault, this.toArray(this.installedRepositories)).features(this.toArray(this.installedFeatures)).bundles(this.toArray(this.installedBundles)).profiles(this.toArray(this.installedProfiles));
        builder.generateAssembly();
        if (this.includeBuildOutputDirectory) {
            IoUtils.copyDirectory(new File(this.project.getBuild().getOutputDirectory()), this.workDirectory);
        }
    }

    private String artifactToMvn(Artifact artifact) throws MojoExecutionException {
        String groupId = artifact.getGroupId();
        String artifactId = artifact.getArtifactId();
        String version = artifact.getBaseVersion();
        String type = artifact.getArtifactHandler().getExtension();
        String classifier = artifact.getClassifier();
        String uri = MavenUtil.isEmpty(classifier) ? ("jar".equals(type) ? String.format("mvn:%s/%s/%s", groupId, artifactId, version) : String.format("mvn:%s/%s/%s/%s", groupId, artifactId, version, type)) : String.format("mvn:%s/%s/%s/%s/%s", groupId, artifactId, version, type, classifier);
        return uri;
    }

    private String[] toArray(List<String> strings) {
        return strings.toArray(new String[strings.size()]);
    }

    private List<String> nonNullList(List<String> list) {
        return list == null ? new ArrayList() : list;
    }
}

