/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.tooling;

import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.karaf.features.BundleInfo;
import org.apache.karaf.features.ConfigFileInfo;
import org.apache.karaf.features.internal.model.Feature;
import org.apache.karaf.features.internal.model.Features;
import org.apache.karaf.features.internal.model.JaxbUtil;
import org.apache.karaf.tooling.utils.MavenUtil;
import org.apache.karaf.tooling.utils.MojoSupport;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.layout.DefaultRepositoryLayout;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.apache.maven.artifact.repository.metadata.Snapshot;
import org.apache.maven.artifact.repository.metadata.SnapshotVersion;
import org.apache.maven.artifact.repository.metadata.Versioning;
import org.apache.maven.artifact.repository.metadata.io.xpp3.MetadataXpp3Writer;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.jar.JarArchiver;

@Mojo(name="kar", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class KarMojo
extends MojoSupport {
    @Parameter
    private MavenArchiveConfiguration archive = new MavenArchiveConfiguration();
    @Component(role=Archiver.class, hint="jar")
    private JarArchiver jarArchiver = null;
    @Parameter(defaultValue="${project.build.directory}")
    private File outputDirectory = null;
    @Parameter(defaultValue="${project.build.finalName}")
    private String finalName = null;
    @Parameter(defaultValue="false")
    private boolean ignoreDependencyFlag;
    @Parameter
    protected String classifier;
    @Parameter(defaultValue="${project.build.directory}/classes")
    private File resourcesDir;
    @Parameter(defaultValue="${project.build.directory}/feature/feature.xml")
    private String featuresFile;
    @Parameter(defaultValue="${repositoryPath}")
    private String repositoryPath = "repository/";
    private static final Pattern mvnPattern = Pattern.compile("mvn:([^/ ]+)/([^/ ]+)/([^/ ]*)(/([^/ ]+)(/([^/ ]+))?)?");

    public void execute() throws MojoExecutionException, MojoFailureException {
        File featuresFileResolved = this.resolveFile(this.featuresFile);
        String groupId = this.project.getGroupId();
        String artifactId = this.project.getArtifactId();
        String version = this.project.getVersion();
        if (KarMojo.isMavenUrl(this.featuresFile)) {
            Artifact artifactTemp = this.resourceToArtifact(this.featuresFile, false);
            if (artifactTemp.getGroupId() != null) {
                groupId = artifactTemp.getGroupId();
            }
            if (artifactTemp.getArtifactHandler() != null) {
                artifactId = artifactTemp.getArtifactId();
            }
            if (artifactTemp.getVersion() != null) {
                version = artifactTemp.getVersion();
            }
        }
        List<Artifact> resources = this.readResources(featuresFileResolved);
        File archive = this.createArchive(resources, featuresFileResolved, groupId, artifactId, version);
        if (this.classifier == null && !this.getProject().getPackaging().equals("kar")) {
            this.getLog().warn((CharSequence)"Your project should use the \"kar\" packaging or configure a \"classifier\" for kar attachment");
            this.projectHelper.attachArtifact(this.getProject(), "kar", null, archive);
            return;
        }
        if (this.classifier != null) {
            this.projectHelper.attachArtifact(this.getProject(), "kar", this.classifier, archive);
        } else {
            this.getProject().getArtifact().setFile(archive);
        }
    }

    private File resolveFile(String file) {
        File fileResolved;
        block7: {
            fileResolved = null;
            if (KarMojo.isMavenUrl(file)) {
                fileResolved = new File(KarMojo.fromMaven(file));
                try {
                    Artifact artifactTemp = this.resourceToArtifact(file, false);
                    if (fileResolved.exists()) break block7;
                    try {
                        this.artifactResolver.resolve(artifactTemp, this.remoteRepos, this.localRepo);
                        fileResolved = artifactTemp.getFile();
                    }
                    catch (ArtifactResolutionException e) {
                        this.getLog().error((CharSequence)"Artifact was not resolved", (Throwable)e);
                    }
                    catch (ArtifactNotFoundException e) {
                        this.getLog().error((CharSequence)"Artifact was not found", (Throwable)e);
                    }
                }
                catch (MojoExecutionException e) {
                    this.getLog().error((Throwable)e);
                }
            } else {
                fileResolved = new File(file);
            }
        }
        return fileResolved;
    }

    private List<Artifact> readResources(File featuresFile) throws MojoExecutionException {
        ArrayList<Artifact> resources = new ArrayList<Artifact>();
        try {
            Features features = JaxbUtil.unmarshal((String)featuresFile.toURI().toASCIIString(), (boolean)false);
            for (Feature feature : features.getFeature()) {
                for (BundleInfo bundle : feature.getBundles()) {
                    if (!this.ignoreDependencyFlag && (this.ignoreDependencyFlag || bundle.isDependency())) continue;
                    resources.add(this.resourceToArtifact(bundle.getLocation(), false));
                }
                for (ConfigFileInfo configFile : feature.getConfigurationFiles()) {
                    resources.add(this.resourceToArtifact(configFile.getLocation(), false));
                }
            }
            return resources;
        }
        catch (MojoExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Could not interpret features.xml", e);
        }
    }

    private File createArchive(List<Artifact> bundles, File featuresFile, String groupId, String artifactId, String version) throws MojoExecutionException {
        DefaultRepositoryLayout layout = new DefaultRepositoryLayout();
        File archiveFile = KarMojo.getArchiveFile(this.outputDirectory, this.finalName, this.classifier);
        MavenArchiver archiver = new MavenArchiver();
        archiver.setArchiver(this.jarArchiver);
        archiver.setOutputFile(archiveFile);
        try {
            Artifact featureArtifact = this.factory.createArtifactWithClassifier(groupId, artifactId, version, "xml", "features");
            this.jarArchiver.addFile(featuresFile, this.repositoryPath + layout.pathOf(featureArtifact));
            if (featureArtifact.isSnapshot()) {
                this.getLog().debug((CharSequence)"Feature artifact is a SNAPSHOT, handling the maven-metadata-local.xml");
                File metadataTarget = new File(featuresFile.getParentFile(), "maven-metadata-local.xml");
                this.getLog().debug((CharSequence)("Looking for " + metadataTarget.getAbsolutePath()));
                if (!metadataTarget.exists()) {
                    this.getLog().debug((CharSequence)(metadataTarget.getAbsolutePath() + " doesn't exist, create it"));
                    Metadata metadata = new Metadata();
                    metadata.setGroupId(featureArtifact.getGroupId());
                    metadata.setArtifactId(featureArtifact.getArtifactId());
                    metadata.setVersion(featureArtifact.getVersion());
                    metadata.setModelVersion("1.1.0");
                    Versioning versioning = new Versioning();
                    versioning.setLastUpdatedTimestamp(new Date(System.currentTimeMillis()));
                    Snapshot snapshot = new Snapshot();
                    snapshot.setLocalCopy(true);
                    versioning.setSnapshot(snapshot);
                    SnapshotVersion snapshotVersion = new SnapshotVersion();
                    snapshotVersion.setClassifier(featureArtifact.getClassifier());
                    snapshotVersion.setVersion(featureArtifact.getVersion());
                    snapshotVersion.setExtension(featureArtifact.getType());
                    snapshotVersion.setUpdated(versioning.getLastUpdated());
                    versioning.addSnapshotVersion(snapshotVersion);
                    metadata.setVersioning(versioning);
                    MetadataXpp3Writer metadataWriter = new MetadataXpp3Writer();
                    try {
                        FileWriter writer = new FileWriter(metadataTarget);
                        metadataWriter.write((Writer)writer, metadata);
                    }
                    catch (Exception e) {
                        this.getLog().warn((CharSequence)"Could not create maven-metadata-local.xml", (Throwable)e);
                        this.getLog().warn((CharSequence)"It means that this SNAPSHOT could be overwritten by an older one present on remote repositories");
                    }
                }
                this.getLog().debug((CharSequence)("Adding file " + metadataTarget.getAbsolutePath() + " in the jar path " + this.repositoryPath + layout.pathOf(featureArtifact).substring(0, layout.pathOf(featureArtifact).lastIndexOf(47)) + "/maven-metadata-local.xml"));
                this.jarArchiver.addFile(metadataTarget, this.repositoryPath + layout.pathOf(featureArtifact).substring(0, layout.pathOf(featureArtifact).lastIndexOf(47)) + "/maven-metadata-local.xml");
            }
            for (Artifact artifact : bundles) {
                this.artifactResolver.resolve(artifact, this.remoteRepos, this.localRepo);
                File localFile = artifact.getFile();
                if (artifact.isSnapshot()) {
                    File metadataTarget = new File(localFile.getParentFile(), "maven-metadata-local.xml");
                    if (!metadataTarget.exists()) {
                        try {
                            MavenUtil.generateMavenMetadata(artifact, metadataTarget);
                        }
                        catch (Exception e) {
                            this.getLog().warn((CharSequence)"Could not create maven-metadata-local.xml", (Throwable)e);
                            this.getLog().warn((CharSequence)"It means that this SNAPSHOT could be overwritten by an older one present on remote repositories");
                        }
                    }
                    this.jarArchiver.addFile(metadataTarget, this.repositoryPath + layout.pathOf(artifact).substring(0, layout.pathOf(artifact).lastIndexOf(47)) + "/maven-metadata-local.xml");
                }
                artifact.setVersion(artifact.getBaseVersion());
                String targetFileName = this.repositoryPath + layout.pathOf(artifact);
                this.jarArchiver.addFile(localFile, targetFileName);
            }
            if (this.resourcesDir.isDirectory()) {
                archiver.getArchiver().addDirectory(this.resourcesDir);
            }
            archiver.createArchive(this.project, this.archive);
            return archiveFile;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to create archive", e);
        }
    }

    protected static boolean isMavenUrl(String name) {
        Matcher m = mvnPattern.matcher(name);
        return m.matches();
    }

    private static String fromMaven(String name) {
        Matcher m = mvnPattern.matcher(name);
        if (!m.matches()) {
            return name;
        }
        StringBuilder b = new StringBuilder();
        b.append(m.group(1));
        for (int i = 0; i < b.length(); ++i) {
            if (b.charAt(i) != '.') continue;
            b.setCharAt(i, '/');
        }
        b.append("/");
        String artifactId = m.group(2);
        String version = m.group(3);
        String extension = m.group(5);
        String classifier = m.group(7);
        b.append(artifactId).append("/");
        b.append(version).append("/");
        b.append(artifactId).append("-").append(version);
        if (KarMojo.present(classifier)) {
            b.append("-").append(classifier);
        }
        if (KarMojo.present(classifier)) {
            b.append(".").append(extension);
        } else {
            b.append(".jar");
        }
        return b.toString();
    }

    private static boolean present(String part) {
        return part != null && !part.isEmpty();
    }

    protected static File getArchiveFile(File basedir, String finalName, String classifier) {
        if (classifier == null) {
            classifier = "";
        } else if (classifier.trim().length() > 0 && !classifier.startsWith("-")) {
            classifier = "-" + classifier;
        }
        return new File(basedir, finalName + classifier + ".kar");
    }
}

