/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.tooling.features;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.felix.utils.version.VersionRange;
import org.apache.felix.utils.version.VersionTable;
import org.apache.karaf.features.internal.model.Bundle;
import org.apache.karaf.features.internal.model.ConfigFile;
import org.apache.karaf.features.internal.model.Dependency;
import org.apache.karaf.features.internal.model.Feature;
import org.apache.karaf.features.internal.model.Features;
import org.apache.karaf.features.internal.model.JaxbUtil;
import org.apache.karaf.tooling.utils.MojoSupport;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.osgi.framework.Version;

public abstract class AbstractFeatureMojo
extends MojoSupport {
    @Parameter
    protected List<String> descriptors;
    protected Set<Artifact> descriptorArtifacts = new HashSet<Artifact>();
    @Parameter
    protected List<String> features;
    @Parameter
    protected boolean addTransitiveFeatures = true;
    @Parameter
    private boolean includeMvnBasedDescriptors = false;
    @Parameter
    private boolean failOnArtifactResolutionError = true;
    @Parameter
    private boolean resolveDefinedRepositoriesRecursively = true;
    @Parameter
    protected boolean skipNonMavenProtocols = true;
    @Parameter
    private int defaultStartLevel = 80;
    private int resolveCount = 0;

    protected void addFeatureRepo(String featureUrl) throws MojoExecutionException {
        Artifact featureDescArtifact = this.resourceToArtifact(featureUrl, true);
        if (featureDescArtifact == null) {
            return;
        }
        try {
            this.resolveArtifact(featureDescArtifact, this.remoteRepos);
            this.descriptors.add(0, featureUrl);
        }
        catch (Exception e) {
            this.getLog().warn((CharSequence)("Can't add " + featureUrl + " in the descriptors set"));
            this.getLog().debug((Throwable)e);
        }
    }

    protected void retrieveDescriptorsRecursively(String uri, Set<String> bundles, Map<String, Feature> featuresMap) {
        Artifact descriptor;
        try {
            descriptor = this.resourceToArtifact(uri, true);
        }
        catch (MojoExecutionException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        if (descriptor != null) {
            this.resolveArtifact(descriptor, this.remoteRepos);
            this.descriptorArtifacts.add(descriptor);
        }
        if (this.includeMvnBasedDescriptors) {
            bundles.add(uri);
        }
        Features repo = JaxbUtil.unmarshal((String)this.translateFromMaven(uri.replaceAll(" ", "%20")), (boolean)true);
        for (Feature f : repo.getFeature()) {
            featuresMap.put(f.getId(), f);
        }
        if (this.resolveDefinedRepositoriesRecursively) {
            for (String r : repo.getRepository()) {
                this.retrieveDescriptorsRecursively(r, bundles, featuresMap);
            }
        }
    }

    protected void resolveArtifact(Artifact artifact, List<ArtifactRepository> remoteRepos) {
        try {
            if (artifact == null) {
                return;
            }
            List<ArtifactRepository> usedRemoteRepos = artifact.getRepository() != null ? Collections.singletonList(artifact.getRepository()) : remoteRepos;
            this.artifactResolver.resolve(artifact, usedRemoteRepos, this.localRepo);
        }
        catch (Exception e) {
            if (this.failOnArtifactResolutionError) {
                throw new RuntimeException("Can't resolve artifact " + artifact, e);
            }
            this.getLog().warn((CharSequence)("Can't resolve artifact " + artifact));
            this.getLog().debug((Throwable)e);
        }
    }

    protected void addFeatures(List<String> featureNames, Set<Feature> features, Map<String, Feature> featuresMap, boolean transitive) {
        for (String feature : featureNames) {
            String[] split = feature.split("/");
            Feature f = this.getMatchingFeature(featuresMap, split[0], split.length > 1 ? split[1] : null);
            features.add(f);
            if (!transitive) continue;
            this.addFeaturesDependencies(f.getFeature(), features, featuresMap, true);
        }
    }

    protected void addFeaturesDependencies(List<Dependency> featureNames, Set<Feature> features, Map<String, Feature> featuresMap, boolean transitive) {
        for (Dependency dependency : featureNames) {
            Feature f = this.getMatchingFeature(featuresMap, dependency.getName(), dependency.getVersion());
            features.add(f);
            if (!transitive) continue;
            this.addFeaturesDependencies(f.getFeature(), features, featuresMap, true);
        }
    }

    private Feature getMatchingFeature(Map<String, Feature> featuresMap, String feature, String version) {
        Feature f = null;
        if (version != null && !version.equals("0.0.0")) {
            f = featuresMap.get(feature + "/" + version);
            if (f == null) {
                VersionRange versionRange = new VersionRange(version);
                for (String key : featuresMap.keySet()) {
                    String verStr;
                    Version ver;
                    String[] nameVersion = key.split("/");
                    if (!feature.equals(nameVersion[0]) || !versionRange.contains(ver = VersionTable.getVersion((String)(verStr = featuresMap.get(key).getVersion()))) || f != null && VersionTable.getVersion((String)f.getVersion()).compareTo(VersionTable.getVersion((String)featuresMap.get(key).getVersion())) >= 0) continue;
                    f = featuresMap.get(key);
                }
            }
        } else {
            for (String key : featuresMap.keySet()) {
                String[] nameVersion = key.split("/");
                if (!feature.equals(nameVersion[0])) continue;
                f = featuresMap.get(key);
                break;
            }
        }
        if (f == null) {
            throw new IllegalArgumentException("Unable to find the feature '" + feature + "'");
        }
        return f;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Set<Feature> resolveFeatures() throws MojoExecutionException {
        HashSet<Feature> featuresSet = new HashSet<Feature>();
        try {
            HashSet<String> artifactsToCopy = new HashSet<String>();
            HashMap<String, Feature> featuresMap = new HashMap<String, Feature>();
            for (String uri : this.descriptors) {
                this.retrieveDescriptorsRecursively(uri, artifactsToCopy, featuresMap);
            }
            if (this.features == null) {
                this.features = new ArrayList(featuresMap.keySet());
            }
            this.addFeatures(this.features, featuresSet, featuresMap, this.addTransitiveFeatures);
            this.getLog().info((CharSequence)("Using local repository at: " + this.localRepo.getUrl()));
            for (Feature feature : featuresSet) {
                try {
                    for (Bundle bundle : feature.getBundle()) {
                        this.resolveArtifact(bundle.getLocation());
                    }
                    for (ConfigFile configfile : feature.getConfigfile()) {
                        this.resolveArtifact(configfile.getLocation());
                    }
                }
                catch (RuntimeException e) {
                    throw new RuntimeException("Error resolving feature " + feature.getName() + "/" + feature.getVersion(), e);
                    return featuresSet;
                }
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error populating repository", e);
        }
    }

    private Artifact resolveArtifact(String location) throws MojoExecutionException {
        Artifact artifact = this.resourceToArtifact(location, this.skipNonMavenProtocols);
        if (artifact != null) {
            try {
                this.resolveArtifact(artifact, this.remoteRepos);
            }
            catch (RuntimeException e) {
                throw new RuntimeException("Error resolving artifact " + location, e);
            }
        }
        this.checkDoGarbageCollect();
        return artifact;
    }

    protected void checkDoGarbageCollect() {
        if (this.resolveCount++ % 100 == 0) {
            System.gc();
            System.runFinalization();
        }
    }
}

