/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.tooling.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;

public class IoUtils {
    private static final long FILE_COPY_BUFFER_SIZE = 30720L;

    public static void deleteRecursive(File file) {
        if (file != null) {
            File[] children;
            if (file.isDirectory() && (children = file.listFiles()) != null) {
                for (File child : children) {
                    IoUtils.deleteRecursive(child);
                }
            }
            file.delete();
        }
    }

    public static void copyDirectory(File srcDir, File destDir) throws IOException {
        File[] srcFiles;
        if (srcDir == null || !srcDir.exists()) {
            return;
        }
        if (destDir == null || !destDir.exists()) {
            destDir.mkdirs();
        }
        if ((srcFiles = srcDir.listFiles()) == null) {
            throw new IOException("Failed to list contents of " + srcDir);
        }
        if (destDir.exists()) {
            if (!destDir.isDirectory()) {
                throw new IOException("Destination '" + destDir + "' exists but is not a directory");
            }
        } else if (!destDir.mkdirs() && !destDir.isDirectory()) {
            throw new IOException("Destination '" + destDir + "' directory cannot be created");
        }
        if (!destDir.canWrite()) {
            throw new IOException("Destination '" + destDir + "' cannot be written to");
        }
        for (File srcFile : srcFiles) {
            File dstFile = new File(destDir, srcFile.getName());
            if (srcFile.isDirectory()) {
                IoUtils.copyDirectory(srcFile, dstFile);
                continue;
            }
            IoUtils.copyFile(srcFile, dstFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File srcFile, File destFile) throws IOException {
        long dstLen;
        long srcLen;
        if (destFile.exists() && destFile.isDirectory()) {
            throw new IOException("Destination '" + destFile + "' exists but is a directory");
        }
        FileInputStream fis = null;
        FileOutputStream fos = null;
        AbstractInterruptibleChannel input = null;
        AbstractInterruptibleChannel output = null;
        try {
            long bytesCopied;
            fis = new FileInputStream(srcFile);
            fos = new FileOutputStream(destFile);
            input = fis.getChannel();
            output = fos.getChannel();
            long size = ((FileChannel)input).size();
            long count = 0L;
            for (long pos = 0L; pos < size; pos += bytesCopied) {
                long remain = size - pos;
                count = remain > 30720L ? 30720L : remain;
                bytesCopied = ((FileChannel)output).transferFrom((ReadableByteChannel)((Object)input), pos, count);
                if (bytesCopied != 0L) continue;
                break;
            }
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (Exception e) {}
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception e) {}
            }
            if (input != null) {
                try {
                    input.close();
                }
                catch (Exception e) {}
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception e) {}
            }
        }
        if ((srcLen = srcFile.length()) != (dstLen = destFile.length())) {
            throw new IOException("Failed to copy full contents from '" + srcFile + "' to '" + destFile + "' Expected length: " + srcLen + " Actual: " + dstLen);
        }
    }
}

