/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.tooling.features;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import org.apache.karaf.features.internal.model.Bundle;
import org.apache.karaf.features.internal.model.Dependency;
import org.apache.karaf.features.internal.model.Feature;
import org.apache.karaf.features.internal.model.Features;
import org.apache.karaf.features.internal.model.JaxbUtil;
import org.apache.karaf.features.internal.model.ObjectFactory;
import org.apache.karaf.tooling.utils.DependencyHelper;
import org.apache.karaf.tooling.utils.DependencyHelperFactory;
import org.apache.karaf.tooling.utils.LocalDependency;
import org.apache.karaf.tooling.utils.ManifestUtils;
import org.apache.karaf.tooling.utils.MavenUtil;
import org.apache.karaf.tooling.utils.MojoSupport;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.logging.SystemStreamLog;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.shared.filtering.AbstractMavenFilteringRequest;
import org.apache.maven.shared.filtering.MavenFileFilter;
import org.apache.maven.shared.filtering.MavenFilteringException;
import org.apache.maven.shared.filtering.MavenResourcesExecution;
import org.apache.maven.shared.filtering.MavenResourcesFiltering;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.xml.sax.SAXException;

@Mojo(name="features-generate-descriptor", defaultPhase=LifecyclePhase.COMPILE, requiresDependencyResolution=ResolutionScope.RUNTIME, threadSafe=true)
public class GenerateDescriptorMojo
extends MojoSupport {
    @Parameter(defaultValue="${project.basedir}/src/main/feature/feature.xml")
    private File inputFile;
    @Parameter(defaultValue="${project.build.directory}/feature/filteredInputFeature.xml")
    private File filteredInputFile;
    @Parameter(defaultValue="${project.build.directory}/feature/feature.xml")
    private File outputFile;
    @Parameter
    private List<String> excludedArtifactIds = new ArrayList<String>();
    @Parameter(defaultValue="${resolver}")
    private String resolver;
    @Parameter(defaultValue="xml")
    private String attachmentArtifactType = "xml";
    @Parameter(defaultValue="features")
    private String attachmentArtifactClassifier = "features";
    @Parameter(defaultValue="false")
    private boolean aggregateFeatures = false;
    @Parameter
    private Integer startLevel;
    @Parameter
    private String installMode;
    @Parameter(defaultValue="true")
    private boolean includeTransitiveDependency;
    @Parameter(defaultValue="true")
    private boolean addBundlesToPrimaryFeature;
    @Parameter(defaultValue="false")
    private boolean ignoreScopeProvided;
    @Parameter(defaultValue="false")
    private boolean includeProjectArtifact;
    @Parameter(defaultValue="${project.artifactId}")
    private String primaryFeatureName;
    @Parameter(defaultValue="false")
    private boolean useVersionRange;
    @Parameter(defaultValue="false")
    private boolean includeTransitiveVersionRanges;
    @Parameter
    private Boolean enableGeneration;
    @Parameter(defaultValue="false")
    private boolean simplifyBundleDependencies;
    @Parameter
    private List<String> prerequisiteFeatures = new ArrayList<String>();
    @Parameter
    private List<String> dependencyFeatures = new ArrayList<String>();
    @Component
    private PlexusContainer container;
    @Component
    private RepositorySystem repoSystem;
    @Component
    protected MavenResourcesFiltering mavenResourcesFiltering;
    @Component
    protected MavenFileFilter mavenFileFilter;
    @Component
    private ProjectBuilder mavenProjectBuilder;
    protected Collection<LocalDependency> localDependencies;
    protected String treeListing;
    protected DependencyHelper dependencyHelper;
    private Log log;
    private final Map<Artifact, MavenProject> resolvedProjects = new HashMap<Artifact, MavenProject>();
    @Parameter(defaultValue="false")
    private boolean checkDependencyChange;
    @Parameter(defaultValue="${basedir}/src/main/history/dependencies.xml")
    private File dependencyCache;
    @Parameter(defaultValue="${basedir}/target/history/dependencies.xml", readonly=true)
    private File filteredDependencyCache;
    @Parameter(defaultValue="true")
    private boolean failOnDependencyChange;
    @Parameter(defaultValue="false")
    private boolean logDependencyChanges;
    @Parameter(defaultValue="false")
    private boolean overwriteChangedDependencies;
    @Parameter(defaultValue="${project.build.sourceEncoding}")
    protected String encoding;
    @Parameter(defaultValue="${maven.resources.escapeString}")
    protected String escapeString = "\\";
    @Parameter
    protected Map<String, String> systemProperties;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            File dir;
            if (this.enableGeneration == null) {
                String packaging = this.project.getPackaging();
                this.enableGeneration = !"feature".equals(packaging);
            }
            if (!this.enableGeneration.booleanValue()) {
                if (this.inputFile.exists()) {
                    dir = this.outputFile.getParentFile();
                    if (!dir.isDirectory() && !dir.mkdirs()) {
                        throw new MojoExecutionException("Could not create directory for features file: " + dir);
                    }
                    this.filter(this.inputFile, this.outputFile);
                    this.projectHelper.attachArtifact(this.project, this.attachmentArtifactType, this.attachmentArtifactClassifier, this.outputFile);
                }
                return;
            }
            this.dependencyHelper = DependencyHelperFactory.createDependencyHelper(this.container, this.project, this.mavenSession, this.getLog());
            this.dependencyHelper.getDependencies(this.project, this.includeTransitiveDependency);
            this.localDependencies = this.dependencyHelper.getLocalDependencies();
            this.treeListing = this.dependencyHelper.getTreeListing();
            dir = this.outputFile.getParentFile();
            if (dir.isDirectory() || dir.mkdirs()) {
                try (PrintStream out = new PrintStream(new FileOutputStream(this.outputFile));){
                    this.writeFeatures(out);
                }
            } else {
                throw new MojoExecutionException("Could not create directory for features file: " + dir);
            }
            this.projectHelper.attachArtifact(this.project, this.attachmentArtifactType, this.attachmentArtifactClassifier, this.outputFile);
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)e.getMessage());
            throw new MojoExecutionException("Unable to create features.xml file: " + e, e);
        }
    }

    private MavenProject resolveProject(Object artifact) throws MojoExecutionException {
        MavenProject resolvedProject = this.project;
        if (this.includeTransitiveVersionRanges && (resolvedProject = this.resolvedProjects.get(artifact)) == null) {
            DefaultProjectBuildingRequest request = new DefaultProjectBuildingRequest();
            request.setSystemProperties(System.getProperties());
            request.setResolveDependencies(true);
            request.setRemoteRepositories(this.project.getPluginArtifactRepositories());
            request.setLocalRepository(this.localRepo);
            request.setProfiles(new ArrayList(this.mavenSession.getRequest().getProfiles()));
            request.setActiveProfileIds(new ArrayList(this.mavenSession.getRequest().getActiveProfiles()));
            this.dependencyHelper.setRepositorySession((ProjectBuildingRequest)request);
            Artifact pomArtifact = this.repoSystem.createArtifact(this.dependencyHelper.getGroupId(artifact), this.dependencyHelper.getArtifactId(artifact), this.dependencyHelper.getBaseVersion(artifact), "pom");
            try {
                resolvedProject = this.mavenProjectBuilder.build(pomArtifact, (ProjectBuildingRequest)request).getProject();
                this.resolvedProjects.put(pomArtifact, resolvedProject);
            }
            catch (ProjectBuildingException e) {
                throw new MojoExecutionException(String.format("Maven-project could not be built for artifact %s", pomArtifact), (Exception)((Object)e));
            }
        }
        return resolvedProject;
    }

    private String getVersionOrRange(Object parent, Object artifact) throws MojoExecutionException {
        String versionOrRange = this.dependencyHelper.getBaseVersion(artifact);
        if (this.useVersionRange) {
            for (org.apache.maven.model.Dependency dependency : this.resolveProject(parent).getDependencies()) {
                if (!dependency.getGroupId().equals(this.dependencyHelper.getGroupId(artifact)) || !dependency.getArtifactId().equals(this.dependencyHelper.getArtifactId(artifact))) continue;
                versionOrRange = dependency.getVersion();
                break;
            }
        }
        return versionOrRange;
    }

    private void writeFeatures(PrintStream out) throws ArtifactResolutionException, ArtifactNotFoundException, IOException, JAXBException, SAXException, ParserConfigurationException, XMLStreamException, MojoExecutionException {
        Object artifact;
        Features features;
        this.getLog().info((CharSequence)("Generating feature descriptor file " + this.outputFile.getAbsolutePath()));
        ObjectFactory objectFactory = new ObjectFactory();
        if (this.inputFile.exists()) {
            this.filter(this.inputFile, this.filteredInputFile);
            features = this.readFeaturesFile(this.filteredInputFile);
        } else {
            features = objectFactory.createFeaturesRoot();
        }
        if (features.getName() == null) {
            features.setName(this.project.getArtifactId());
        }
        Feature feature = null;
        for (Feature test : features.getFeature()) {
            if (!test.getName().equals(this.primaryFeatureName)) continue;
            feature = test;
        }
        if (feature == null) {
            feature = objectFactory.createFeature();
            feature.setName(this.primaryFeatureName);
        }
        if (!feature.hasVersion()) {
            feature.setVersion(this.project.getArtifact().getBaseVersion());
        }
        if (feature.getDescription() == null) {
            feature.setDescription(this.project.getName());
        }
        if (this.installMode != null) {
            feature.setInstall(this.installMode);
        }
        if (this.project.getDescription() != null && feature.getDetails() == null) {
            feature.setDetails(this.project.getDescription());
        }
        if (this.includeProjectArtifact) {
            Bundle bundle = objectFactory.createBundle();
            bundle.setLocation(this.dependencyHelper.artifactToMvn(this.project.getArtifact(), this.project.getVersion()));
            if (this.startLevel != null) {
                bundle.setStartLevel(this.startLevel);
            }
            feature.getBundle().add(bundle);
        }
        boolean needWrap = false;
        HashMap<Dependency, Feature> otherFeatures = new HashMap<Dependency, Feature>();
        HashMap<Feature, String> featureRepositories = new HashMap<Feature, String>();
        for (LocalDependency entry : this.localDependencies) {
            artifact = entry.getArtifact();
            if (this.excludedArtifactIds.contains(this.dependencyHelper.getArtifactId(artifact))) continue;
            this.processFeatureArtifact(features, feature, otherFeatures, featureRepositories, artifact, entry.getParent(), true);
        }
        if (this.addBundlesToPrimaryFeature) {
            block4: for (LocalDependency entry : this.localDependencies) {
                Object cf2;
                artifact = entry.getArtifact();
                if (this.excludedArtifactIds.contains(this.dependencyHelper.getArtifactId(artifact)) || this.dependencyHelper.isArtifactAFeature(artifact)) continue;
                String bundleName = this.dependencyHelper.artifactToMvn(artifact, this.getVersionOrRange(entry.getParent(), artifact));
                File bundleFile = this.dependencyHelper.resolve(artifact, this.getLog());
                Manifest manifest = this.getManifest(bundleFile);
                for (Object cf2 : feature.getConfigfile()) {
                    if (!bundleName.equals(cf2.getLocation().replace('\n', ' ').trim())) continue;
                    continue block4;
                }
                if (manifest == null || !ManifestUtils.isBundle(this.getManifest(bundleFile))) {
                    bundleName = "wrap:" + bundleName;
                    needWrap = true;
                }
                Bundle bundle = null;
                cf2 = feature.getBundle().iterator();
                while (cf2.hasNext()) {
                    Bundle b = (Bundle)cf2.next();
                    if (!bundleName.equals(b.getLocation())) continue;
                    bundle = b;
                    break;
                }
                if (bundle == null) {
                    boolean includedTransitively;
                    bundle = objectFactory.createBundle();
                    bundle.setLocation(bundleName);
                    boolean bl = includedTransitively = this.simplifyBundleDependencies && this.isBundleIncludedTransitively(feature, otherFeatures, bundle);
                    if (!(includedTransitively || "provided".equals(entry.getScope()) && this.ignoreScopeProvided)) {
                        feature.getBundle().add(bundle);
                    }
                }
                if ("runtime".equals(entry.getScope())) {
                    bundle.setDependency(Boolean.valueOf(true));
                }
                if (this.startLevel == null || bundle.getStartLevel() != 0) continue;
                bundle.setStartLevel(this.startLevel);
            }
        }
        if (needWrap) {
            Dependency wrapDependency = new Dependency();
            wrapDependency.setName("wrap");
            wrapDependency.setDependency(false);
            wrapDependency.setPrerequisite(true);
            feature.getFeature().add(wrapDependency);
        }
        if (!(feature.getBundle().isEmpty() && feature.getFeature().isEmpty() || features.getFeature().contains(feature))) {
            features.getFeature().add(feature);
        }
        for (Feature includedFeature : features.getFeature()) {
            for (Dependency dependency : includedFeature.getFeature()) {
                String repository;
                Feature dependedFeature = (Feature)otherFeatures.get(dependency);
                if (dependedFeature == null || features.getFeature().contains(dependedFeature) || (repository = (String)featureRepositories.get(dependedFeature)) == null || features.getRepository().contains(repository)) continue;
                features.getRepository().add(repository);
            }
        }
        JaxbUtil.marshal((Features)features, (OutputStream)out);
        try {
            this.checkChanges(features, objectFactory);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Features contents have changed", e);
        }
        this.getLog().info((CharSequence)"...done!");
    }

    private void processFeatureArtifact(Features features, Feature feature, Map<Dependency, Feature> otherFeatures, Map<Feature, String> featureRepositories, Object artifact, Object parent, boolean add) throws MojoExecutionException, XMLStreamException, JAXBException, IOException {
        if (this.dependencyHelper.isArtifactAFeature(artifact) && "features".equals(this.dependencyHelper.getClassifier(artifact))) {
            File featuresFile = this.dependencyHelper.resolve(artifact, this.getLog());
            if (featuresFile == null || !featuresFile.exists()) {
                throw new MojoExecutionException("Cannot locate file for feature: " + artifact + " at " + featuresFile);
            }
            Features includedFeatures = this.readFeaturesFile(featuresFile);
            for (String repository : includedFeatures.getRepository()) {
                this.processFeatureArtifact(features, feature, otherFeatures, featureRepositories, new DefaultArtifact(MavenUtil.mvnToAether(repository)), parent, false);
            }
            for (Feature includedFeature : includedFeatures.getFeature()) {
                Dependency dependency = new Dependency(includedFeature.getName(), includedFeature.getVersion());
                dependency.setPrerequisite(this.prerequisiteFeatures.contains(dependency.getName()));
                dependency.setDependency(this.dependencyFeatures.contains(dependency.getName()));
                Dependency matchingDependency = this.findMatchingDependency(feature.getFeature(), dependency);
                if (matchingDependency != null) {
                    this.mergeDependencies(matchingDependency, dependency);
                    dependency = matchingDependency;
                }
                otherFeatures.put(dependency, includedFeature);
                if (add) {
                    if (!feature.getFeature().contains(dependency)) {
                        feature.getFeature().add(dependency);
                    }
                    if (this.aggregateFeatures) {
                        features.getFeature().add(includedFeature);
                    }
                }
                if (featureRepositories.containsKey(includedFeature)) continue;
                featureRepositories.put(includedFeature, this.dependencyHelper.artifactToMvn(artifact, this.getVersionOrRange(parent, artifact)));
            }
        }
    }

    private Dependency findMatchingDependency(List<Dependency> dependencies, Dependency reference) {
        String referenceName = reference.getName();
        for (Dependency dependency : dependencies) {
            if (!referenceName.equals(dependency.getName())) continue;
            return dependency;
        }
        return null;
    }

    private void mergeDependencies(Dependency target, Dependency source) {
        if (target.getVersion() == null || "0.0.0".equals(target.getVersion())) {
            target.setVersion(source.getVersion());
        }
        if (source.isDependency()) {
            target.setDependency(true);
        }
        if (source.isPrerequisite()) {
            target.setPrerequisite(true);
        }
    }

    private boolean isBundleIncludedTransitively(Feature feature, Map<Dependency, Feature> otherFeatures, Bundle bundle) {
        for (Dependency dependency : feature.getFeature()) {
            Feature otherFeature = otherFeatures.get(dependency);
            if (otherFeature == null || !otherFeature.getBundle().contains(bundle) && !this.isBundleIncludedTransitively(otherFeature, otherFeatures, bundle)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Manifest getManifest(File file) throws IOException {
        BufferedInputStream is;
        try {
            is = new BufferedInputStream(new FileInputStream(file));
        }
        catch (Exception e) {
            this.getLog().warn((CharSequence)"Error while opening artifact", (Throwable)e);
            return null;
        }
        try {
            ((InputStream)is).mark(262144);
            JarInputStream jar = new JarInputStream(is);
            Manifest m = jar.getManifest();
            if (m == null) {
                this.getLog().warn((CharSequence)("Manifest not present in the first entry of the zip - " + file.getName()));
            }
            jar.close();
            Manifest manifest = m;
            return manifest;
        }
        finally {
            ((InputStream)is).close();
        }
    }

    private Features readFeaturesFile(File featuresFile) throws XMLStreamException, JAXBException, IOException {
        return JaxbUtil.unmarshal((String)featuresFile.toURI().toASCIIString(), (boolean)false);
    }

    public void setLog(Log log) {
        this.log = log;
    }

    public Log getLog() {
        if (this.log == null) {
            this.setLog((Log)new SystemStreamLog());
        }
        return this.log;
    }

    private void checkChanges(Features newFeatures, ObjectFactory objectFactory) throws Exception, IOException, JAXBException, XMLStreamException {
        if (this.checkDependencyChange) {
            Features features = objectFactory.createFeaturesRoot();
            features.setName(newFeatures.getName());
            Feature feature = objectFactory.createFeature();
            features.getFeature().add(feature);
            for (Feature f : newFeatures.getFeature()) {
                for (Bundle b : f.getBundle()) {
                    Bundle bundle = objectFactory.createBundle();
                    bundle.setLocation(b.getLocation());
                    feature.getBundle().add(bundle);
                }
                for (Dependency d : f.getFeature()) {
                    Dependency dependency = objectFactory.createDependency();
                    dependency.setName(d.getName());
                    feature.getFeature().add(dependency);
                }
            }
            Collections.sort(feature.getBundle(), new Comparator<Bundle>(){

                @Override
                public int compare(Bundle bundle, Bundle bundle1) {
                    return bundle.getLocation().compareTo(bundle1.getLocation());
                }
            });
            Collections.sort(feature.getFeature(), new Comparator<Dependency>(){

                @Override
                public int compare(Dependency dependency, Dependency dependency1) {
                    return dependency.getName().compareTo(dependency1.getName());
                }
            });
            if (this.dependencyCache.exists()) {
                this.filter(this.dependencyCache, this.filteredDependencyCache);
                Features oldfeatures = this.readFeaturesFile(this.filteredDependencyCache);
                Feature oldFeature = (Feature)oldfeatures.getFeature().get(0);
                ArrayList<Bundle> addedBundles = new ArrayList<Bundle>(feature.getBundle());
                ArrayList<Bundle> removedBundles = new ArrayList<Bundle>();
                for (Bundle test : oldFeature.getBundle()) {
                    boolean t1 = addedBundles.contains(test);
                    int s1 = addedBundles.size();
                    boolean t2 = addedBundles.remove(test);
                    int s2 = addedBundles.size();
                    if (t1 != t2) {
                        this.getLog().warn((CharSequence)("dependencies.contains: " + t1 + ", dependencies.remove(test): " + t2));
                    }
                    if (t1 == (s1 == s2)) {
                        this.getLog().warn((CharSequence)("dependencies.contains: " + t1 + ", size before: " + s1 + ", size after: " + s2));
                    }
                    if (t2) continue;
                    removedBundles.add(test);
                }
                ArrayList<Dependency> addedDependencys = new ArrayList<Dependency>(feature.getFeature());
                ArrayList<Dependency> removedDependencys = new ArrayList<Dependency>();
                for (Dependency test : oldFeature.getFeature()) {
                    boolean t1 = addedDependencys.contains(test);
                    int s1 = addedDependencys.size();
                    boolean t2 = addedDependencys.remove(test);
                    int s2 = addedDependencys.size();
                    if (t1 != t2) {
                        this.getLog().warn((CharSequence)("dependencies.contains: " + t1 + ", dependencies.remove(test): " + t2));
                    }
                    if (t1 == (s1 == s2)) {
                        this.getLog().warn((CharSequence)("dependencies.contains: " + t1 + ", size before: " + s1 + ", size after: " + s2));
                    }
                    if (t2) continue;
                    removedDependencys.add(test);
                }
                if (!(addedBundles.isEmpty() && removedBundles.isEmpty() && addedDependencys.isEmpty() && removedDependencys.isEmpty())) {
                    this.saveDependencyChanges(addedBundles, removedBundles, addedDependencys, removedDependencys, objectFactory);
                    if (this.overwriteChangedDependencies) {
                        this.writeDependencies(features, this.dependencyCache);
                    }
                } else {
                    this.getLog().info((CharSequence)this.saveTreeListing());
                }
            } else {
                this.writeDependencies(features, this.dependencyCache);
            }
        }
    }

    protected void saveDependencyChanges(Collection<Bundle> addedBundles, Collection<Bundle> removedBundles, Collection<Dependency> addedDependencys, Collection<Dependency> removedDependencys, ObjectFactory objectFactory) throws Exception {
        File addedFile = new File(this.filteredDependencyCache.getParentFile(), "dependencies.added.xml");
        Features added = this.toFeatures(addedBundles, addedDependencys, objectFactory);
        this.writeDependencies(added, addedFile);
        File removedFile = new File(this.filteredDependencyCache.getParentFile(), "dependencies.removed.xml");
        Features removed = this.toFeatures(removedBundles, removedDependencys, objectFactory);
        this.writeDependencies(removed, removedFile);
        StringWriter out = new StringWriter();
        out.write(this.saveTreeListing());
        out.write("Dependencies have changed:\n");
        if (!addedBundles.isEmpty() || !addedDependencys.isEmpty()) {
            out.write("\tAdded dependencies are saved here: " + addedFile.getAbsolutePath() + "\n");
            if (this.logDependencyChanges) {
                JaxbUtil.marshal((Features)added, (Writer)out);
            }
        }
        if (!removedBundles.isEmpty() || !removedDependencys.isEmpty()) {
            out.write("\tRemoved dependencies are saved here: " + removedFile.getAbsolutePath() + "\n");
            if (this.logDependencyChanges) {
                JaxbUtil.marshal((Features)removed, (Writer)out);
            }
        }
        out.write("Delete " + this.dependencyCache.getAbsolutePath() + " if you are happy with the dependency changes.");
        if (this.failOnDependencyChange) {
            throw new MojoFailureException(out.toString());
        }
        this.getLog().warn((CharSequence)out.toString());
    }

    private Features toFeatures(Collection<Bundle> addedBundles, Collection<Dependency> addedDependencys, ObjectFactory objectFactory) {
        Features features = objectFactory.createFeaturesRoot();
        Feature feature = objectFactory.createFeature();
        feature.getBundle().addAll(addedBundles);
        feature.getFeature().addAll(addedDependencys);
        features.getFeature().add(feature);
        return features;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeDependencies(Features features, File file) throws JAXBException, IOException {
        file.getParentFile().mkdirs();
        if (!file.getParentFile().exists() || !file.getParentFile().isDirectory()) {
            throw new IOException("Cannot create directory at " + file.getParent());
        }
        try (FileOutputStream out = new FileOutputStream(file);){
            JaxbUtil.marshal((Features)features, (OutputStream)out);
        }
    }

    protected void filter(File sourceFile, File targetFile) throws MojoExecutionException {
        try {
            if (StringUtils.isEmpty((String)this.encoding)) {
                this.getLog().warn((CharSequence)("File encoding has not been set, using platform encoding " + ReaderFactory.FILE_ENCODING + ", i.e. build is platform dependent!"));
            }
            targetFile.getParentFile().mkdirs();
            MavenResourcesExecution mre = new MavenResourcesExecution();
            mre.setMavenProject(this.project);
            mre.setMavenSession(this.mavenSession);
            mre.setFilters(null);
            mre.setEscapedBackslashesInFilePath(true);
            LinkedHashSet<String> delimiters = new LinkedHashSet<String>();
            delimiters.add("${*}");
            mre.setDelimiters(delimiters);
            List filters = this.mavenFileFilter.getDefaultFilterWrappers((AbstractMavenFilteringRequest)mre);
            this.mavenFileFilter.copyFile(sourceFile, targetFile, true, filters, this.encoding, true);
        }
        catch (MavenFilteringException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String saveTreeListing() throws IOException {
        File treeListFile = new File(this.filteredDependencyCache.getParentFile(), "treeListing.txt");
        FileOutputStream os = new FileOutputStream(treeListFile);
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(os));){
            writer.write(this.treeListing);
        }
        return "\tTree listing is saved here: " + treeListFile.getAbsolutePath() + "\n";
    }
}

