/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.tooling.client;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Console;
import java.io.File;
import java.io.FileReader;
import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.security.KeyPair;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.sshd.agent.SshAgent;
import org.apache.sshd.agent.SshAgentFactory;
import org.apache.sshd.agent.local.AgentImpl;
import org.apache.sshd.agent.local.LocalAgentFactory;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.client.auth.keyboard.UserInteraction;
import org.apache.sshd.client.channel.ClientChannel;
import org.apache.sshd.client.channel.ClientChannelEvent;
import org.apache.sshd.client.future.ConnectFuture;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.RuntimeSshException;
import org.apache.sshd.common.keyprovider.FileKeyPairProvider;
import org.fusesource.jansi.Ansi;
import org.fusesource.jansi.AnsiConsole;

@Mojo(name="client", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.RUNTIME, threadSafe=true)
public class ClientMojo
extends AbstractMojo {
    @Parameter(defaultValue="8101")
    private int port;
    @Parameter(defaultValue="localhost")
    private String host;
    @Parameter(defaultValue="karaf")
    private String user;
    @Parameter(defaultValue="karaf")
    private String password;
    @Parameter(defaultValue="0")
    private int attempts;
    @Parameter(defaultValue="2")
    private int delay;
    @Parameter
    private List<String> commands;
    @Parameter
    private List<File> scripts;
    @Parameter
    private File keyFile;
    private static final String NEW_LINE = System.getProperty("line.separator");

    public void execute() throws MojoExecutionException {
        if (this.scripts != null) {
            for (File script : this.scripts) {
                try {
                    BufferedReader br = new BufferedReader(new FileReader(script));
                    Throwable throwable = null;
                    try {
                        String line;
                        while ((line = br.readLine()) != null) {
                            if ((line = line.trim()).isEmpty()) continue;
                            this.commands.add(line);
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (br == null) continue;
                        if (throwable != null) {
                            try {
                                br.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        br.close();
                    }
                }
                catch (Exception e) {
                    throw new MojoExecutionException((Object)e, e.getMessage(), e.toString());
                }
            }
        }
        if (this.commands == null || this.commands.isEmpty()) {
            this.getLog().warn((CharSequence)"No OSGi command was specified");
            return;
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        for (String cmd : this.commands) {
            this.getLog().info((CharSequence)cmd);
            pw.println(cmd);
        }
        this.execute(sw.toString());
    }

    protected void execute(String cmd) throws MojoExecutionException {
        SshClient client = null;
        try {
            boolean isError;
            final Console console = System.console();
            client = SshClient.setUpDefaultClient();
            this.setupAgent(this.user, this.keyFile, client);
            client.setUserInteraction(new UserInteraction(){

                public void welcome(ClientSession s, String banner, String lang) {
                    console.printf(banner, new Object[0]);
                }

                public String[] interactive(ClientSession s, String name, String instruction, String lang, String[] prompt, boolean[] echo) {
                    String[] answers = new String[prompt.length];
                    try {
                        for (int i = 0; i < prompt.length; ++i) {
                            if (console == null) continue;
                            answers[i] = echo[i] ? console.readLine(prompt[i] + " ", new Object[0]) : new String(console.readPassword(prompt[i] + " ", new Object[0]));
                        }
                    }
                    catch (IOError iOError) {
                        // empty catch block
                    }
                    return answers;
                }

                public boolean isInteractionAllowed(ClientSession session) {
                    return true;
                }

                public void serverVersionInfo(ClientSession session, List<String> lines) {
                }

                public String getUpdatedPassword(ClientSession session, String prompt, String lang) {
                    return null;
                }
            });
            client.start();
            if (console != null) {
                console.printf("Logging in as %s\n", this.user);
            }
            ClientSession session = this.connect(client);
            if (this.password != null) {
                session.addPasswordIdentity(this.password);
            }
            session.auth().verify();
            ClientChannel channel = session.createChannel("exec", cmd.concat(NEW_LINE));
            channel.setIn((InputStream)new ByteArrayInputStream(new byte[0]));
            ByteArrayOutputStream sout = new ByteArrayOutputStream();
            ByteArrayOutputStream serr = new ByteArrayOutputStream();
            channel.setOut(AnsiConsole.wrapOutputStream((OutputStream)sout));
            channel.setErr(AnsiConsole.wrapOutputStream((OutputStream)serr));
            channel.open();
            channel.waitFor(EnumSet.of(ClientChannelEvent.CLOSED), 0L);
            sout.writeTo(System.out);
            serr.writeTo(System.err);
            boolean bl = isError = channel.getExitStatus() != null && channel.getExitStatus() != 0;
            if (isError) {
                String errorMarker = Ansi.ansi().fg(Ansi.Color.RED).toString();
                int fromIndex = sout.toString().indexOf(errorMarker) + errorMarker.length();
                int toIndex = sout.toString().lastIndexOf(Ansi.ansi().fg(Ansi.Color.DEFAULT).toString());
                throw new MojoExecutionException(NEW_LINE + sout.toString().substring(fromIndex, toIndex));
            }
        }
        catch (MojoExecutionException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new MojoExecutionException((Object)t, t.getMessage(), t.toString());
        }
        finally {
            try {
                client.stop();
            }
            catch (Throwable t) {
                throw new MojoExecutionException((Object)t, t.getMessage(), t.toString());
            }
        }
    }

    private void setupAgent(String user, File keyFile, SshClient client) {
        URL builtInPrivateKey = ClientMojo.class.getClassLoader().getResource("karaf.key");
        SshAgent agent = this.startAgent(user, builtInPrivateKey, keyFile);
        client.setAgentFactory((SshAgentFactory)new LocalAgentFactory(agent));
        client.getProperties().put("SSH_AUTH_SOCK", "local");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SshAgent startAgent(String user, URL privateKeyUrl, File keyFile) {
        try (InputStream is = privateKeyUrl.openStream();){
            AgentImpl agent = new AgentImpl();
            ObjectInputStream r = new ObjectInputStream(is);
            KeyPair keyPair = (KeyPair)r.readObject();
            is.close();
            agent.addIdentity(keyPair, user);
            if (keyFile != null) {
                FileKeyPairProvider fileKeyPairProvider = new FileKeyPairProvider(keyFile.getAbsoluteFile().toPath());
                for (KeyPair key : fileKeyPairProvider.loadKeys()) {
                    agent.addIdentity(key, user);
                }
            }
            AgentImpl agentImpl = agent;
            return agentImpl;
        }
        catch (Throwable e) {
            this.getLog().error((CharSequence)("Error starting ssh agent for: " + e.getMessage()), e);
            return null;
        }
    }

    private ClientSession connect(SshClient client) throws IOException, InterruptedException {
        int retries = 0;
        ClientSession session = null;
        do {
            ConnectFuture future = client.connect(this.user, this.host, this.port);
            future.await();
            try {
                session = future.getSession();
            }
            catch (RuntimeSshException ex) {
                if (retries++ < this.attempts) {
                    Thread.sleep(TimeUnit.SECONDS.toMillis(this.delay));
                    this.getLog().info((CharSequence)("retrying (attempt " + retries + ") ..."));
                    continue;
                }
                throw ex;
            }
        } while (session == null);
        return session;
    }
}

