/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kdc.identitybackend;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.directory.api.ldap.model.cursor.CursorException;
import org.apache.directory.api.ldap.model.cursor.EntryCursor;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.DefaultEntry;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidAttributeValueException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.message.ModifyRequest;
import org.apache.directory.api.ldap.model.message.ModifyRequestImpl;
import org.apache.directory.api.ldap.model.message.SearchScope;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.name.Rdn;
import org.apache.directory.api.util.GeneralizedTime;
import org.apache.directory.ldap.client.api.LdapConnection;
import org.apache.directory.ldap.client.api.LdapNetworkConnection;
import org.apache.directory.ldap.client.api.search.FilterBuilder;
import org.apache.kerby.config.Config;
import org.apache.kerby.kerberos.kdc.identitybackend.LdapIdentityGetHelper;
import org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.kerby.kerberos.kerb.identity.backend.AbstractIdentityBackend;
import org.apache.kerby.kerberos.kerb.request.KrbIdentity;
import org.apache.kerby.kerberos.kerb.type.KerberosTime;
import org.apache.kerby.kerberos.kerb.type.base.EncryptionKey;
import org.apache.kerby.kerberos.kerb.type.base.EncryptionType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapIdentityBackend
extends AbstractIdentityBackend {
    private int currentConnectionIndex = 0;
    private Map<String, LdapConnection> connections = new HashMap<String, LdapConnection>();
    private LdapConnection connection;
    private String[] hosts;
    private boolean isLdapNetworkConnection;
    private static final Logger LOG = LoggerFactory.getLogger(LdapIdentityBackend.class);

    public LdapIdentityBackend() {
        this.isLdapNetworkConnection = true;
    }

    public LdapIdentityBackend(Config config) {
        this.setConfig(config);
        this.isLdapNetworkConnection = true;
    }

    public LdapIdentityBackend(Config config, LdapConnection connection) {
        this.setConfig(config);
        if (this.isHa()) {
            throw new IllegalArgumentException("Only one ldap connection provided, but two needed when set ha hosts[" + config.getString("host") + "]");
        }
        this.connection = connection;
        String hostConfig = this.getConfig().getString("host");
        this.hosts = new String[]{hostConfig};
        this.connections.put(hostConfig, connection);
    }

    public LdapIdentityBackend(Config config, Map<String, LdapConnection> connections) {
        this.setConfig(config);
        String hostConfig = this.getConfig().getString("host");
        this.hosts = hostConfig.trim().split(",");
        if (this.hosts.length > 2) {
            throw new IllegalArgumentException("More than two ldap hosts is not supported.");
        }
        if (this.hosts.length != connections.size()) {
            throw new IllegalArgumentException("Number of ldap hosts[" + this.hosts.length + "] not equal to ldap connections[" + connections.size() + "].");
        }
        this.connections = new HashMap<String, LdapConnection>(connections);
        this.connection = connections.get(this.hosts[this.currentConnectionIndex]);
    }

    private void startConnection() throws LdapException {
        if (this.isLdapNetworkConnection) {
            String hostConfig = this.getConfig().getString("host");
            this.hosts = hostConfig.trim().split(",");
            if (this.hosts.length > 2) {
                throw new IllegalArgumentException("More than two ldap hosts is not supported.");
            }
            for (String host : this.hosts) {
                LdapNetworkConnection connection = new LdapNetworkConnection(host, this.getConfig().getInt("port").intValue());
                this.connections.put(host, (LdapConnection)connection);
            }
            String currentHost = this.hosts[this.currentConnectionIndex];
            this.connection = this.connections.get(currentHost);
        }
        for (LdapConnection connection : this.connections.values()) {
            connection.bind(this.getConfig().getString("admin_dn"), this.getConfig().getString("admin_pw"));
        }
        LOG.info("Start connection with ldap host[" + this.getConfig().getString("host") + "]");
    }

    protected void doInitialize() throws KrbException {
        LOG.info("Initializing the Ldap identity backend.");
        try {
            this.startConnection();
        }
        catch (LdapException e) {
            LOG.error("Failed to start connection with LDAP", (Throwable)e);
            throw new KrbException("Failed to start connection with LDAP", (Throwable)e);
        }
    }

    protected void doStop() throws KrbException {
        try {
            this.closeConnection();
        }
        catch (IOException e) {
            LOG.error("Failed to close connection with LDAP", (Throwable)e);
            throw new KrbException("Failed to close connection with LDAP", (Throwable)e);
        }
        LOG.info("closed connection with LDAP.");
    }

    private void closeConnection() throws IOException {
        IOException cause = null;
        for (Map.Entry<String, LdapConnection> entry : this.connections.entrySet()) {
            LdapConnection connection = entry.getValue();
            try {
                if (!connection.isConnected()) continue;
                connection.close();
            }
            catch (IOException e) {
                LOG.error("Catch exception when close connection with host[" + entry.getKey() + "].");
                if (cause == null) {
                    cause = e;
                    continue;
                }
                cause.addSuppressed(e);
            }
        }
        if (cause != null) {
            throw cause;
        }
    }

    private String toGeneralizedTime(KerberosTime kerberosTime) {
        GeneralizedTime generalizedTime = new GeneralizedTime((Date)kerberosTime.getValue());
        return generalizedTime.toString();
    }

    protected KrbIdentity doAddIdentity(KrbIdentity identity) throws KrbException {
        String principalName = identity.getPrincipalName();
        String[] names = principalName.split("@");
        DefaultEntry entry = new DefaultEntry();
        KeysInfo keysInfo = new KeysInfo(identity);
        try {
            Dn dn = this.toDn(principalName);
            entry.setDn(dn);
            entry.add("objectClass", new String[]{"top", "person", "inetOrgPerson", "krb5principal", "krb5kdcentry"});
            entry.add("uid", new String[]{names[0]});
            entry.add("cn", new String[]{names[0]});
            entry.add("sn", new String[]{names[0]});
            entry.add("krb5Key", keysInfo.getKeys());
            entry.add("krb5EncryptionType", keysInfo.getEtypes());
            entry.add("krb5PrincipalName", new String[]{principalName});
            entry.add("krb5KeyVersionNumber", new String[]{identity.getKeyVersion() + ""});
            entry.add("krb5KDCFlags", new String[]{"" + identity.getKdcFlags()});
            entry.add("krb5AccountDisabled", new String[]{"" + identity.isDisabled()});
            entry.add("krb5AccountLockedOut", new String[]{"" + identity.isLocked()});
            entry.add("krb5AccountExpirationTime", new String[]{this.toGeneralizedTime(identity.getExpireTime())});
            new FailoverInvocationHandler<Void>((Entry)entry){
                final /* synthetic */ Entry val$entry;
                {
                    this.val$entry = entry;
                }

                @Override
                public Void execute() throws LdapException {
                    LdapIdentityBackend.this.connection.add(this.val$entry);
                    return null;
                }
            }.run();
        }
        catch (LdapInvalidDnException e) {
            LOG.error("Error occurred while adding identity", (Throwable)e);
            throw new KrbException("Failed to add identity", (Throwable)e);
        }
        catch (LdapException e) {
            LOG.error("Error occurred while adding identity", (Throwable)e);
            throw new KrbException("Failed to add identity", (Throwable)e);
        }
        return this.getIdentity(principalName);
    }

    protected KrbIdentity doGetIdentity(String principalName) throws KrbException {
        KrbIdentity krbIdentity = new KrbIdentity(principalName);
        final String searchFilter = FilterBuilder.and((FilterBuilder[])new FilterBuilder[]{FilterBuilder.equal((String)"objectclass", (String)"krb5principal"), FilterBuilder.equal((String)"krb5PrincipalName", (String)principalName)}).toString();
        try {
            EntryCursor cursor = (EntryCursor)new FailoverInvocationHandler<EntryCursor>(){

                @Override
                public EntryCursor execute() throws LdapException {
                    return LdapIdentityBackend.this.connection.search(LdapIdentityBackend.this.getConfig().getString("base_dn"), searchFilter, SearchScope.SUBTREE, new String[]{"dn"});
                }
            }.run();
            if (cursor == null || !cursor.next()) {
                return null;
            }
            final Dn dn = ((Entry)cursor.get()).getDn();
            cursor.close();
            Entry entry = (Entry)new FailoverInvocationHandler<Entry>(){

                @Override
                public Entry execute() throws LdapException {
                    return LdapIdentityBackend.this.connection.lookup(dn, new String[]{"*", "+"});
                }
            }.run();
            if (entry == null) {
                return null;
            }
            LdapIdentityGetHelper getHelper = new LdapIdentityGetHelper(entry);
            krbIdentity.setPrincipal(getHelper.getPrincipalName());
            krbIdentity.setKeyVersion(getHelper.getKeyVersion());
            krbIdentity.addKeys(getHelper.getKeys());
            krbIdentity.setCreatedTime(getHelper.getCreatedTime());
            krbIdentity.setExpireTime(getHelper.getExpireTime());
            krbIdentity.setDisabled(getHelper.getDisabled());
            krbIdentity.setKdcFlags(getHelper.getKdcFlags());
            krbIdentity.setLocked(getHelper.getLocked());
        }
        catch (LdapException e) {
            throw new KrbException("Failed to retrieve identity", (Throwable)e);
        }
        catch (CursorException e) {
            throw new KrbException("Failed to retrieve identity", (Throwable)e);
        }
        catch (ParseException e) {
            throw new KrbException("Failed to retrieve identity", (Throwable)e);
        }
        catch (IOException e) {
            throw new KrbException("Failed to retrieve identity", (Throwable)e);
        }
        return krbIdentity;
    }

    protected KrbIdentity doUpdateIdentity(KrbIdentity identity) throws KrbException {
        String principalName = identity.getPrincipalName();
        KeysInfo keysInfo = new KeysInfo(identity);
        try {
            Dn dn = this.toDn(principalName);
            ModifyRequestImpl modifyRequest = new ModifyRequestImpl();
            modifyRequest.setName(dn);
            modifyRequest.replace("krb5KeyVersionNumber", new String[]{"" + identity.getKeyVersion()});
            modifyRequest.replace("krb5Key", keysInfo.getKeys());
            modifyRequest.replace("krb5EncryptionType", keysInfo.getEtypes());
            modifyRequest.replace("krb5PrincipalName", new String[]{identity.getPrincipalName()});
            modifyRequest.replace("krb5AccountExpirationTime", new String[]{this.toGeneralizedTime(identity.getExpireTime())});
            modifyRequest.replace("krb5AccountDisabled", new String[]{"" + identity.isDisabled()});
            modifyRequest.replace("krb5KDCFlags", new String[]{"" + identity.getKdcFlags()});
            modifyRequest.replace("krb5AccountLockedOut", new String[]{"" + identity.isLocked()});
            new FailoverInvocationHandler<Void>((ModifyRequest)modifyRequest){
                final /* synthetic */ ModifyRequest val$modifyRequest;
                {
                    this.val$modifyRequest = modifyRequest;
                }

                @Override
                public Void execute() throws LdapException {
                    LdapIdentityBackend.this.connection.modify(this.val$modifyRequest);
                    return null;
                }
            }.run();
        }
        catch (LdapException e) {
            LOG.error("Error occurred while updating identity: " + principalName, (Throwable)e);
            throw new KrbException("Failed to update identity", (Throwable)e);
        }
        return this.getIdentity(principalName);
    }

    protected void doDeleteIdentity(String principalName) throws KrbException {
        try {
            final Dn dn = this.toDn(principalName);
            new FailoverInvocationHandler<Void>(){

                @Override
                public Void execute() throws LdapException {
                    LdapIdentityBackend.this.connection.delete(dn);
                    return null;
                }
            }.run();
        }
        catch (LdapException e) {
            LOG.error("Error occurred while deleting identity: " + principalName);
            throw new KrbException("Failed to remove identity", (Throwable)e);
        }
    }

    private Dn toDn(String principalName) throws LdapInvalidDnException, LdapInvalidAttributeValueException {
        String[] names = principalName.split("@");
        String uid = names[0];
        Dn dn = new Dn(new Rdn("uid", uid), new Dn(new String[]{this.getConfig().getString("base_dn")}));
        return dn;
    }

    protected Iterable<String> doGetIdentities() {
        ArrayList<String> identityNames = new ArrayList<String>();
        try {
            EntryCursor cursor = (EntryCursor)new FailoverInvocationHandler<EntryCursor>(){

                @Override
                public EntryCursor execute() throws LdapException {
                    return LdapIdentityBackend.this.connection.search(LdapIdentityBackend.this.getConfig().getString("base_dn"), "(objectclass=krb5principal)", SearchScope.SUBTREE, new String[]{"krb5PrincipalName"});
                }
            }.run();
            if (cursor == null) {
                return null;
            }
            while (cursor.next()) {
                Entry entry = (Entry)cursor.get();
                Attribute krb5PrincipalNameAt = entry.get("krb5PrincipalName");
                if (krb5PrincipalNameAt == null) continue;
                identityNames.add(krb5PrincipalNameAt.getString());
            }
            cursor.close();
            Collections.sort(identityNames);
        }
        catch (LdapException e) {
            LOG.error("With LdapException when LdapConnection searching. " + (Object)((Object)e));
        }
        catch (CursorException e) {
            LOG.error("With CursorException when EntryCursor getting. " + (Object)((Object)e));
        }
        catch (IOException e) {
            LOG.error("With IOException when closing EntryCursor. " + e);
        }
        return identityNames;
    }

    private void performFailover() {
        this.currentConnectionIndex = (this.currentConnectionIndex + 1) % this.hosts.length;
        String host = this.hosts[this.currentConnectionIndex];
        this.connection = this.connections.get(host);
    }

    private boolean isHa() {
        String host = this.getConfig().getString("host");
        if (host != null) {
            return host.trim().split(",").length == 2;
        }
        return false;
    }

    abstract class FailoverInvocationHandler<T> {
        FailoverInvocationHandler() {
        }

        public abstract T execute() throws LdapException;

        public T run() throws LdapException {
            try {
                return this.execute();
            }
            catch (LdapException e) {
                if (!LdapIdentityBackend.this.isHa()) {
                    throw e;
                }
                String host = LdapIdentityBackend.this.hosts[LdapIdentityBackend.this.currentConnectionIndex];
                LOG.error("Catch exception with ldap host[" + host + "].", (Throwable)e);
                LdapIdentityBackend.this.performFailover();
                host = LdapIdentityBackend.this.hosts[LdapIdentityBackend.this.currentConnectionIndex];
                LOG.info("Failover to ldap host:" + host + ".");
                return this.execute();
            }
        }
    }

    static class KeysInfo {
        private String[] etypes;
        private byte[][] keys;
        private String[] kvnos;

        KeysInfo(KrbIdentity identity) throws KrbException {
            Map keymap = identity.getKeys();
            this.etypes = new String[keymap.size()];
            this.keys = new byte[keymap.size()][];
            this.kvnos = new String[keymap.size()];
            int i = 0;
            for (Map.Entry entryKey : keymap.entrySet()) {
                this.etypes[i] = ((EncryptionType)entryKey.getKey()).getValue() + "";
                try {
                    this.keys[i] = ((EncryptionKey)entryKey.getValue()).encode();
                }
                catch (IOException e) {
                    throw new KrbException("encode key failed", (Throwable)e);
                }
                this.kvnos[i] = ((EncryptionKey)entryKey.getValue()).getKvno() + "";
                ++i;
            }
        }

        public String[] getEtypes() {
            return this.etypes;
        }

        public byte[][] getKeys() {
            return this.keys;
        }

        public String[] getKvnos() {
            return this.kvnos;
        }
    }
}

